/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.gearpump.translators.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.TimestampedValue;
import org.joda.time.Instant;

public class ValuesSource<T>
extends UnboundedSource<T, UnboundedSource.CheckpointMark> {
    private static final long serialVersionUID = 9113026175795235710L;
    private final byte[] values;
    private final IterableCoder<T> iterableCoder;

    public ValuesSource(Iterable<T> values, Coder<T> coder) {
        this.iterableCoder = IterableCoder.of(coder);
        this.values = this.encode(values, this.iterableCoder);
    }

    private byte[] encode(Iterable<T> values, IterableCoder<T> coder) {
        byte[] byArray;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            coder.encode(values, (OutputStream)stream, Coder.Context.OUTER);
            byArray = stream.toByteArray();
        }
        catch (Throwable throwable2) {
            try {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    ValuesSource.$closeResource(throwable, stream);
                    throw throwable3;
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        ValuesSource.$closeResource(throwable, stream);
        return byArray;
    }

    private Iterable<T> decode(byte[] bytes) throws IOException {
        Iterable iterable;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        Throwable throwable = null;
        try {
            iterable = (Iterable)this.iterableCoder.decode((InputStream)inputStream, Coder.Context.OUTER);
        }
        catch (Throwable throwable2) {
            try {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    ValuesSource.$closeResource(throwable, inputStream);
                    throw throwable3;
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        ValuesSource.$closeResource(throwable, inputStream);
        return iterable;
    }

    public List<? extends UnboundedSource<T, UnboundedSource.CheckpointMark>> split(int desiredNumSplits, PipelineOptions options) throws Exception {
        return Collections.singletonList(this);
    }

    public UnboundedSource.UnboundedReader<T> createReader(PipelineOptions options, @Nullable UnboundedSource.CheckpointMark checkpointMark) {
        try {
            return new ValuesReader<T>(this.decode(this.values), this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public Coder<UnboundedSource.CheckpointMark> getCheckpointMarkCoder() {
        return null;
    }

    public Coder<T> getDefaultOutputCoder() {
        return this.iterableCoder.getElemCoder();
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }

    private static class ValuesReader<T>
    extends UnboundedSource.UnboundedReader<T> {
        private final UnboundedSource<T, UnboundedSource.CheckpointMark> source;
        private final Iterable<T> values;
        private transient Iterator<T> iterator;
        private T current;

        ValuesReader(Iterable<T> values, UnboundedSource<T, UnboundedSource.CheckpointMark> source) {
            this.values = values;
            this.source = source;
        }

        public boolean start() throws IOException {
            if (null == this.iterator) {
                this.iterator = this.values.iterator();
            }
            return this.advance();
        }

        public boolean advance() throws IOException {
            if (this.iterator.hasNext()) {
                this.current = this.iterator.next();
                return true;
            }
            return false;
        }

        public T getCurrent() throws NoSuchElementException {
            return this.current;
        }

        public Instant getCurrentTimestamp() throws NoSuchElementException {
            return this.getTimestamp(this.current);
        }

        public void close() throws IOException {
        }

        public Instant getWatermark() {
            if (this.iterator.hasNext()) {
                return this.getTimestamp(this.current);
            }
            return BoundedWindow.TIMESTAMP_MAX_VALUE;
        }

        public UnboundedSource.CheckpointMark getCheckpointMark() {
            return UnboundedSource.CheckpointMark.NOOP_CHECKPOINT_MARK;
        }

        public UnboundedSource<T, ?> getCurrentSource() {
            return this.source;
        }

        private Instant getTimestamp(Object value) {
            if (value instanceof TimestampedValue) {
                return ((TimestampedValue)value).getTimestamp();
            }
            return Instant.now();
        }
    }
}

