/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.gearpump.translators;

import io.gearpump.streaming.dsl.javaapi.JavaStream;
import io.gearpump.streaming.dsl.javaapi.functions.FlatMapFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import org.apache.beam.runners.gearpump.translators.TransformTranslator;
import org.apache.beam.runners.gearpump.translators.TranslationContext;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.joda.time.Instant;

public class WindowAssignTranslator<T>
implements TransformTranslator<Window.Assign<T>> {
    private static final long serialVersionUID = -964887482120489061L;

    @Override
    public void translate(Window.Assign<T> transform, TranslationContext context) {
        PCollection input = (PCollection)context.getInput();
        PCollection output = (PCollection)context.getOutput();
        JavaStream inputStream = context.getInputStream((PValue)input);
        WindowingStrategy outputStrategy = output.getWindowingStrategy();
        WindowFn windowFn = outputStrategy.getWindowFn();
        JavaStream outputStream = inputStream.flatMap(new AssignWindows(windowFn), "assign_windows");
        context.setOutputStream((PValue)output, outputStream);
    }

    protected static class AssignWindows<T>
    extends FlatMapFunction<WindowedValue<T>, WindowedValue<T>> {
        private static final long serialVersionUID = 7284565861938681360L;
        private final WindowFn<T, BoundedWindow> windowFn;

        AssignWindows(WindowFn<T, BoundedWindow> windowFn) {
            this.windowFn = windowFn;
        }

        public Iterator<WindowedValue<T>> flatMap(final WindowedValue<T> value) {
            try {
                WindowFn<T, BoundedWindow> windowFn = this.windowFn;
                Objects.requireNonNull(windowFn);
                Collection windows = this.windowFn.assignWindows(new WindowFn.AssignContext(windowFn){

                    public T element() {
                        return value.getValue();
                    }

                    public Instant timestamp() {
                        return value.getTimestamp();
                    }

                    public BoundedWindow window() {
                        return (BoundedWindow)Iterables.getOnlyElement((Iterable)value.getWindows());
                    }
                });
                ArrayList<WindowedValue> values = new ArrayList<WindowedValue>(windows.size());
                for (BoundedWindow win : windows) {
                    values.add(WindowedValue.of((Object)value.getValue(), (Instant)value.getTimestamp(), (BoundedWindow)win, (PaneInfo)value.getPane()));
                }
                return values.iterator();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

