/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.gearpump.translators;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.beam.runners.core.construction.PTransformMatchers;
import org.apache.beam.runners.core.construction.SplittableParDo;
import org.apache.beam.runners.core.construction.SplittableParDoNaiveBounded;
import org.apache.beam.runners.core.construction.UnsupportedOverrideFactory;
import org.apache.beam.runners.gearpump.translators.CreateGearpumpPCollectionViewTranslator;
import org.apache.beam.runners.gearpump.translators.CreateStreamingGearpumpView;
import org.apache.beam.runners.gearpump.translators.FlattenPCollectionsTranslator;
import org.apache.beam.runners.gearpump.translators.GroupByKeyTranslator;
import org.apache.beam.runners.gearpump.translators.ParDoMultiOutputTranslator;
import org.apache.beam.runners.gearpump.translators.ReadBoundedTranslator;
import org.apache.beam.runners.gearpump.translators.ReadUnboundedTranslator;
import org.apache.beam.runners.gearpump.translators.TransformTranslator;
import org.apache.beam.runners.gearpump.translators.TranslationContext;
import org.apache.beam.runners.gearpump.translators.WindowAssignTranslator;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.runners.PTransformMatcher;
import org.apache.beam.sdk.runners.PTransformOverride;
import org.apache.beam.sdk.runners.PTransformOverrideFactory;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GearpumpPipelineTranslator
extends Pipeline.PipelineVisitor.Defaults {
    private static final Logger LOG = LoggerFactory.getLogger(GearpumpPipelineTranslator.class);
    private static final Map<Class<? extends PTransform>, TransformTranslator> transformTranslators = new HashMap<Class<? extends PTransform>, TransformTranslator>();
    private final TranslationContext translationContext;

    public GearpumpPipelineTranslator(TranslationContext translationContext) {
        this.translationContext = translationContext;
    }

    public void translate(Pipeline pipeline) {
        ImmutableList overrides = ImmutableList.builder().add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.classEqualTo(View.CreatePCollectionView.class), new CreateStreamingGearpumpView.Factory())).add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.splittableParDo(), (PTransformOverrideFactory)new SplittableParDo.OverrideFactory())).add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.splittableProcessKeyedBounded(), (PTransformOverrideFactory)new SplittableParDoNaiveBounded.OverrideFactory())).add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.requiresStableInputParDoMulti(), (PTransformOverrideFactory)UnsupportedOverrideFactory.withMessage((String)"Gearpump runner currently doesn't support @RequiresStableInput annotation."))).build();
        pipeline.replaceAll((List)overrides);
        pipeline.traverseTopologically((Pipeline.PipelineVisitor)this);
    }

    public Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(TransformHierarchy.Node node) {
        LOG.debug("entering composite transform {}", (Object)node.getTransform());
        return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
    }

    public void leaveCompositeTransform(TransformHierarchy.Node node) {
        LOG.debug("leaving composite transform {}", (Object)node.getTransform());
    }

    public void visitPrimitiveTransform(TransformHierarchy.Node node) {
        LOG.debug("visiting transform {}", (Object)node.getTransform());
        PTransform transform = node.getTransform();
        TransformTranslator<?> translator = this.getTransformTranslator(transform.getClass());
        if (null == translator) {
            throw new IllegalStateException("no translator registered for " + transform);
        }
        this.translationContext.setCurrentTransform(node, this.getPipeline());
        translator.translate(transform, this.translationContext);
    }

    public void visitValue(PValue value, TransformHierarchy.Node producer) {
        LOG.debug("visiting value {}", (Object)value);
    }

    private static <TransformT extends PTransform> void registerTransformTranslator(Class<TransformT> transformClass, TransformTranslator<? extends TransformT> transformTranslator) {
        if (transformTranslators.put(transformClass, transformTranslator) != null) {
            throw new IllegalArgumentException("defining multiple translators for " + transformClass);
        }
    }

    private <TransformT extends PTransform> TransformTranslator<TransformT> getTransformTranslator(Class<TransformT> transformClass) {
        return transformTranslators.get(transformClass);
    }

    static {
        GearpumpPipelineTranslator.registerTransformTranslator(Read.Unbounded.class, new ReadUnboundedTranslator());
        GearpumpPipelineTranslator.registerTransformTranslator(Read.Bounded.class, new ReadBoundedTranslator());
        GearpumpPipelineTranslator.registerTransformTranslator(GroupByKey.class, new GroupByKeyTranslator());
        GearpumpPipelineTranslator.registerTransformTranslator(Flatten.PCollections.class, new FlattenPCollectionsTranslator());
        GearpumpPipelineTranslator.registerTransformTranslator(ParDo.MultiOutput.class, new ParDoMultiOutputTranslator());
        GearpumpPipelineTranslator.registerTransformTranslator(Window.Assign.class, new WindowAssignTranslator());
        GearpumpPipelineTranslator.registerTransformTranslator(CreateStreamingGearpumpView.CreateGearpumpPCollectionView.class, new CreateGearpumpPCollectionViewTranslator());
    }
}

