/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.gearpump.translators.io;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigValueFactory;
import io.gearpump.cluster.ClusterConfig;
import io.gearpump.util.Constants;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.beam.runners.gearpump.GearpumpPipelineOptions;
import org.apache.beam.runners.gearpump.GearpumpRunner;
import org.apache.beam.runners.gearpump.translators.io.ValuesSource;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;
import org.junit.Assert;
import org.junit.Test;

public class ValueSoureTest {
    @Test
    public void testValueSource() {
        GearpumpPipelineOptions options = (GearpumpPipelineOptions)PipelineOptionsFactory.create().as(GearpumpPipelineOptions.class);
        Config config = ClusterConfig.master(null);
        config = config.withValue(Constants.APPLICATION_TOTAL_RETRIES(), ConfigValueFactory.fromAnyRef((Object)0));
        options.setRemote(Boolean.valueOf(false));
        options.setRunner(GearpumpRunner.class);
        options.setParallelism(1);
        Pipeline p = Pipeline.create((PipelineOptions)options);
        ArrayList values = Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4", "5"});
        ValuesSource source = new ValuesSource((Iterable)values, (Coder)StringUtf8Coder.of());
        ((PCollection)p.apply((PTransform)Read.from((UnboundedSource)source))).apply((PTransform)ParDo.of((DoFn)new ResultCollector()));
        p.run().waitUntilFinish();
        Assert.assertEquals((Object)Sets.newHashSet((Iterable)values), (Object)ResultCollector.RESULTS);
    }

    private static class ResultCollector
    extends DoFn<Object, Void> {
        private static final Set<Object> RESULTS = Collections.synchronizedSet(new HashSet());

        private ResultCollector() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) throws Exception {
            RESULTS.add(c.element());
        }
    }
}

