/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.gearpump;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.typesafe.config.Config;
import io.gearpump.cluster.ClusterConfig;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.beam.runners.gearpump.GearpumpPipelineOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.junit.Assert;
import org.junit.Test;

public class PipelineOptionsTest {
    @Test
    public void testIgnoredFieldSerialization() throws IOException {
        String appName = "forTest";
        HashMap serializers = Maps.newHashMap();
        serializers.put("classA", "SerializerA");
        GearpumpPipelineOptions options = (GearpumpPipelineOptions)PipelineOptionsFactory.create().as(GearpumpPipelineOptions.class);
        Config config = ClusterConfig.master(null);
        options.setSerializers((Map)serializers);
        options.setApplicationName(appName);
        options.setRemote(Boolean.valueOf(false));
        options.setParallelism(10);
        byte[] serializedOptions = this.serialize(options);
        GearpumpPipelineOptions deserializedOptions = (GearpumpPipelineOptions)((PipelineOptions)new ObjectMapper().readValue(serializedOptions, PipelineOptions.class)).as(GearpumpPipelineOptions.class);
        Assert.assertNull((Object)deserializedOptions.getSerializers());
        Assert.assertEquals((long)10L, (long)deserializedOptions.getParallelism());
        Assert.assertEquals((Object)appName, (Object)deserializedOptions.getApplicationName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] serialize(Object obj) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            new ObjectMapper().writeValue((OutputStream)baos, obj);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't serialize PipelineOptions.", e);
        }
    }
}

