/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.gearpump.translators;

import io.gearpump.streaming.dsl.api.functions.FilterFunction;
import io.gearpump.streaming.dsl.javaapi.JavaStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.beam.runners.core.construction.ParDoTranslation;
import org.apache.beam.runners.gearpump.translators.TransformTranslator;
import org.apache.beam.runners.gearpump.translators.TranslationContext;
import org.apache.beam.runners.gearpump.translators.functions.DoFnFunction;
import org.apache.beam.runners.gearpump.translators.utils.TranslatorUtils;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;

public class ParDoMultiOutputTranslator<InputT, OutputT>
implements TransformTranslator<ParDo.MultiOutput<InputT, OutputT>> {
    private static final long serialVersionUID = -6023461558200028849L;

    @Override
    public void translate(ParDo.MultiOutput<InputT, OutputT> transform, TranslationContext context) {
        PCollection inputT = (PCollection)context.getInput();
        JavaStream inputStream = context.getInputStream((PValue)inputT);
        List sideInputs = transform.getSideInputs();
        Map<String, PCollectionView<?>> tagsToSideInputs = TranslatorUtils.getTagsToSideInputs(sideInputs);
        Map<TupleTag<?>, PValue> outputs = context.getOutputs();
        TupleTag mainOutput = transform.getMainOutputTag();
        ArrayList sideOutputs = new ArrayList(outputs.size() - 1);
        HashMap outputCoders = new HashMap();
        for (Map.Entry<TupleTag<?>, PValue> entry : outputs.entrySet()) {
            TupleTag<?> tag = entry.getKey();
            if (tag != null && !tag.getId().equals(mainOutput.getId())) {
                sideOutputs.add(tag);
            }
            if (!(entry.getValue() instanceof PCollection)) continue;
            PCollection pCollection = (PCollection)entry.getValue();
            outputCoders.put(tag, pCollection.getCoder());
        }
        JavaStream<TranslatorUtils.RawUnionValue> unionStream = TranslatorUtils.withSideInputStream(context, inputStream, tagsToSideInputs);
        DoFnSchemaInformation doFnSchemaInformation = ParDoTranslation.getSchemaInformation(context.getCurrentTransform());
        JavaStream outputStream = TranslatorUtils.toList(unionStream).flatMap(new DoFnFunction(context.getPipelineOptions(), transform.getFn(), inputT.getWindowingStrategy(), sideInputs, tagsToSideInputs, mainOutput, outputCoders, sideOutputs, doFnSchemaInformation), transform.getName());
        for (Map.Entry<TupleTag<?>, PValue> output : outputs.entrySet()) {
            JavaStream taggedStream = outputStream.filter((FilterFunction)new FilterByOutputTag(output.getKey().getId()), "filter_by_output_tag").map(new TranslatorUtils.FromRawUnionValue(), "from_RawUnionValue");
            context.setOutputStream(output.getValue(), taggedStream);
        }
    }

    private static class FilterByOutputTag
    extends FilterFunction<TranslatorUtils.RawUnionValue> {
        private static final long serialVersionUID = 7276155265895637526L;
        private final String tag;

        FilterByOutputTag(String tag) {
            this.tag = tag;
        }

        public boolean filter(TranslatorUtils.RawUnionValue value) {
            return value.getUnionTag().equals(this.tag);
        }
    }
}

