/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.gearpump.translators.io;

import io.gearpump.DefaultMessage;
import io.gearpump.Message;
import io.gearpump.streaming.source.DataSource;
import io.gearpump.streaming.source.Watermark;
import io.gearpump.streaming.task.TaskContext;
import java.io.IOException;
import java.time.Instant;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.gearpump.translators.utils.TranslatorUtils;
import org.apache.beam.sdk.io.Source;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;

public abstract class GearpumpSource<T>
implements DataSource {
    private final SerializablePipelineOptions serializedOptions;
    private Source.Reader<T> reader;
    private boolean available = false;

    GearpumpSource(PipelineOptions options) {
        this.serializedOptions = new SerializablePipelineOptions(options);
    }

    protected abstract Source.Reader<T> createReader(PipelineOptions var1) throws IOException;

    public void open(TaskContext context, Instant startTime) {
        try {
            PipelineOptions options = this.serializedOptions.get();
            this.reader = this.createReader(options);
            this.available = this.reader.start();
        }
        catch (Exception e) {
            this.close();
            throw new RuntimeException(e);
        }
    }

    public Message read() {
        DefaultMessage message = null;
        try {
            if (this.available) {
                Object data = this.reader.getCurrent();
                org.joda.time.Instant timestamp = this.reader.getCurrentTimestamp();
                message = new DefaultMessage((Object)WindowedValue.timestampedValueInGlobalWindow((Object)data, (org.joda.time.Instant)timestamp), timestamp.getMillis());
            }
            this.available = this.reader.advance();
        }
        catch (Exception e) {
            this.close();
            throw new RuntimeException(e);
        }
        return message;
    }

    public void close() {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Instant getWatermark() {
        if (this.reader instanceof UnboundedSource.UnboundedReader) {
            org.joda.time.Instant watermark = ((UnboundedSource.UnboundedReader)this.reader).getWatermark();
            if (watermark.equals((Object)BoundedWindow.TIMESTAMP_MAX_VALUE)) {
                return Watermark.MAX();
            }
            return TranslatorUtils.jodaTimeToJava8Time(watermark);
        }
        if (this.available) {
            return Watermark.MIN();
        }
        return Watermark.MAX();
    }
}

