/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.gearpump.translators;

import io.gearpump.cluster.UserConfig;
import io.gearpump.streaming.dsl.javaapi.JavaStream;
import io.gearpump.streaming.dsl.javaapi.JavaStreamApp;
import io.gearpump.streaming.source.DataSource;
import java.util.HashMap;
import java.util.Map;
import org.apache.beam.runners.core.construction.TransformInputs;
import org.apache.beam.runners.gearpump.GearpumpPipelineOptions;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Iterables;

public class TranslationContext {
    private final JavaStreamApp streamApp;
    private final GearpumpPipelineOptions pipelineOptions;
    private AppliedPTransform<?, ?, ?> currentTransform;
    private final Map<PValue, JavaStream<?>> streams = new HashMap();

    public TranslationContext(JavaStreamApp streamApp, GearpumpPipelineOptions pipelineOptions) {
        this.streamApp = streamApp;
        this.pipelineOptions = pipelineOptions;
    }

    public void setCurrentTransform(TransformHierarchy.Node treeNode, Pipeline pipeline) {
        this.currentTransform = treeNode.toAppliedPTransform(pipeline);
    }

    public GearpumpPipelineOptions getPipelineOptions() {
        return this.pipelineOptions;
    }

    public <InputT> JavaStream<InputT> getInputStream(PValue input) {
        return this.streams.get(input);
    }

    public <OutputT> void setOutputStream(PValue output, JavaStream<OutputT> outputStream) {
        if (this.streams.containsKey(output)) {
            throw new RuntimeException("set stream for duplicated output " + output);
        }
        this.streams.put(output, outputStream);
    }

    public Map<TupleTag<?>, PValue> getInputs() {
        return this.getCurrentTransform().getInputs();
    }

    public PValue getInput() {
        return (PValue)Iterables.getOnlyElement((Iterable)TransformInputs.nonAdditionalInputs(this.getCurrentTransform()));
    }

    public Map<TupleTag<?>, PValue> getOutputs() {
        return this.getCurrentTransform().getOutputs();
    }

    public PValue getOutput() {
        return (PValue)Iterables.getOnlyElement(this.getOutputs().values());
    }

    public AppliedPTransform<?, ?, ?> getCurrentTransform() {
        Preconditions.checkArgument((this.currentTransform != null ? 1 : 0) != 0, (Object)"current transform not set");
        return this.currentTransform;
    }

    public <T> JavaStream<T> getSourceStream(DataSource dataSource) {
        return this.streamApp.source(dataSource, this.pipelineOptions.getParallelism(), UserConfig.empty(), "source");
    }
}

