/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.gearpump;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import io.gearpump.cluster.ClusterConfig;
import io.gearpump.cluster.UserConfig;
import io.gearpump.cluster.client.ClientContext;
import io.gearpump.cluster.client.RemoteRuntimeEnvironment;
import io.gearpump.cluster.client.RunningApplication;
import io.gearpump.cluster.client.RuntimeEnvironment;
import io.gearpump.cluster.embedded.EmbeddedRuntimeEnvironment;
import io.gearpump.streaming.dsl.javaapi.JavaStreamApp;
import io.gearpump.util.Constants;
import java.util.HashMap;
import java.util.Map;
import org.apache.beam.runners.gearpump.GearpumpPipelineOptions;
import org.apache.beam.runners.gearpump.GearpumpPipelineResult;
import org.apache.beam.runners.gearpump.translators.GearpumpPipelineTranslator;
import org.apache.beam.runners.gearpump.translators.TranslationContext;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineRunner;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsValidator;

public class GearpumpRunner
extends PipelineRunner<GearpumpPipelineResult> {
    private final GearpumpPipelineOptions options;
    private static final String GEARPUMP_SERIALIZERS = "gearpump.serializers";
    private static final String DEFAULT_APPNAME = "beam_gearpump_app";

    public GearpumpRunner(GearpumpPipelineOptions options) {
        this.options = options;
    }

    public static GearpumpRunner fromOptions(PipelineOptions options) {
        GearpumpPipelineOptions pipelineOptions = (GearpumpPipelineOptions)PipelineOptionsValidator.validate(GearpumpPipelineOptions.class, (PipelineOptions)options);
        return new GearpumpRunner(pipelineOptions);
    }

    public GearpumpPipelineResult run(Pipeline pipeline) {
        String appName = this.options.getApplicationName();
        if (null == appName) {
            appName = DEFAULT_APPNAME;
        }
        Config config = this.registerSerializers(ClusterConfig.defaultConfig(), this.options.getSerializers());
        if (this.options.getRemote().booleanValue()) {
            RuntimeEnvironment.setRuntimeEnv((RuntimeEnvironment)new RemoteRuntimeEnvironment());
        } else {
            RuntimeEnvironment.setRuntimeEnv((RuntimeEnvironment)new EmbeddedRuntimeEnvironment());
            config = config.withValue(Constants.APPLICATION_TOTAL_RETRIES(), ConfigValueFactory.fromAnyRef((Object)0));
        }
        ClientContext clientContext = ClientContext.apply((Config)config);
        this.options.setClientContext(clientContext);
        UserConfig userConfig = UserConfig.empty();
        JavaStreamApp streamApp = new JavaStreamApp(appName, clientContext, userConfig);
        TranslationContext translationContext = new TranslationContext(streamApp, this.options);
        GearpumpPipelineTranslator translator = new GearpumpPipelineTranslator(translationContext);
        translator.translate(pipeline);
        RunningApplication app = streamApp.submit();
        return new GearpumpPipelineResult(clientContext, app);
    }

    private Config registerSerializers(Config config, Map<String, String> userSerializers) {
        HashMap<String, String> serializers = new HashMap<String, String>();
        serializers.put("org.apache.beam.sdk.util.WindowedValue$ValueInGlobalWindow", "");
        serializers.put("org.apache.beam.sdk.util.WindowedValue$TimestampedValueInSingleWindow", "");
        serializers.put("org.apache.beam.sdk.util.WindowedValue$TimestampedValueInGlobalWindow", "");
        serializers.put("org.apache.beam.sdk.util.WindowedValue$TimestampedValueInMultipleWindows", "");
        serializers.put("org.apache.beam.sdk.transforms.windowing.PaneInfo", "");
        serializers.put("org.apache.beam.sdk.transforms.windowing.PaneInfo$Timing", "");
        serializers.put("org.joda.time.Instant", "");
        serializers.put("org.apache.beam.sdk.values.KV", "");
        serializers.put("org.apache.beam.sdk.transforms.windowing.IntervalWindow", "");
        serializers.put("org.apache.beam.sdk.values.TimestampedValue", "");
        serializers.put("org.apache.beam.runners.gearpump.translators.utils.TranslatorUtils$RawUnionValue", "");
        if (userSerializers != null && !userSerializers.isEmpty()) {
            serializers.putAll(userSerializers);
        }
        return config.withValue(GEARPUMP_SERIALIZERS, (ConfigValue)ConfigValueFactory.fromMap(serializers));
    }
}

