/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.gearpump.translators.utils;

import io.gearpump.streaming.dsl.api.functions.FoldFunction;
import io.gearpump.streaming.dsl.api.functions.MapFunction;
import io.gearpump.streaming.dsl.javaapi.JavaStream;
import io.gearpump.streaming.dsl.window.impl.Window;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.beam.runners.gearpump.translators.TranslationContext;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Lists;

public class TranslatorUtils {
    public static Instant jodaTimeToJava8Time(org.joda.time.Instant time) {
        return Instant.ofEpochMilli(time.getMillis());
    }

    public static org.joda.time.Instant java8TimeToJodaTime(Instant time) {
        return new org.joda.time.Instant(time.toEpochMilli());
    }

    public static Window boundedWindowToGearpumpWindow(BoundedWindow window) {
        Instant end = TranslatorUtils.jodaTimeToJava8Time(window.maxTimestamp().plus(1L));
        if (window instanceof IntervalWindow) {
            IntervalWindow intervalWindow = (IntervalWindow)window;
            Instant start = TranslatorUtils.jodaTimeToJava8Time(intervalWindow.start());
            return new Window(start, end);
        }
        if (window instanceof GlobalWindow) {
            return new Window(TranslatorUtils.jodaTimeToJava8Time(BoundedWindow.TIMESTAMP_MIN_VALUE), end);
        }
        throw new RuntimeException("unknown window " + window.getClass().getName());
    }

    public static <InputT> JavaStream<RawUnionValue> withSideInputStream(TranslationContext context, JavaStream<WindowedValue<InputT>> inputStream, Map<String, PCollectionView<?>> tagsToSideInputs) {
        JavaStream mainStream = inputStream.map(new ToRawUnionValue("0"), "map_to_RawUnionValue");
        for (Map.Entry<String, PCollectionView<?>> tagToSideInput : tagsToSideInputs.entrySet()) {
            JavaStream sideInputStream = context.getInputStream((PValue)tagToSideInput.getValue());
            mainStream = mainStream.merge(sideInputStream.map(new ToRawUnionValue(tagToSideInput.getKey()), "map_to_RawUnionValue"), 1, "merge_to_MainStream");
        }
        return mainStream;
    }

    public static Map<String, PCollectionView<?>> getTagsToSideInputs(Collection<PCollectionView<?>> sideInputs) {
        HashMap tagsToSideInputs = new HashMap();
        int tag = 1;
        for (PCollectionView<?> sideInput : sideInputs) {
            tagsToSideInputs.put(Integer.toString(tag), sideInput);
            ++tag;
        }
        return tagsToSideInputs;
    }

    public static JavaStream<List<RawUnionValue>> toList(JavaStream<RawUnionValue> stream) {
        return stream.fold((FoldFunction)new FoldFunction<RawUnionValue, List<RawUnionValue>>(){

            public List<RawUnionValue> init() {
                return Lists.newArrayList();
            }

            public List<RawUnionValue> fold(List<RawUnionValue> accumulator, RawUnionValue rawUnionValue) {
                accumulator.add(rawUnionValue);
                return accumulator;
            }
        }, "fold_to_iterable");
    }

    public static class RawUnionValue {
        private final String unionTag;
        private final Object value;

        public RawUnionValue(String unionTag, Object value) {
            this.unionTag = unionTag;
            this.value = value;
        }

        public String getUnionTag() {
            return this.unionTag;
        }

        public Object getValue() {
            return this.value;
        }

        public String toString() {
            return this.unionTag + ":" + this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RawUnionValue that = (RawUnionValue)o;
            if (!this.unionTag.equals(that.unionTag)) {
                return false;
            }
            return this.value != null ? this.value.equals(that.value) : that.value == null;
        }

        public int hashCode() {
            int result = this.unionTag.hashCode();
            result = 31 * result + this.value.hashCode();
            return result;
        }
    }

    private static class ToRawUnionValue<T>
    extends MapFunction<WindowedValue<T>, RawUnionValue> {
        private static final long serialVersionUID = 8648852871014813583L;
        private final String tag;

        ToRawUnionValue(String tag) {
            this.tag = tag;
        }

        public RawUnionValue map(WindowedValue<T> windowedValue) {
            return new RawUnionValue(this.tag, windowedValue);
        }
    }

    public static class FromRawUnionValue<OutputT>
    extends MapFunction<RawUnionValue, WindowedValue<OutputT>> {
        private static final long serialVersionUID = -4764968219713478955L;

        public WindowedValue<OutputT> map(RawUnionValue value) {
            return (WindowedValue)value.getValue();
        }
    }
}

