/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.gearpump;

import io.gearpump.cluster.client.ClientContext;
import org.apache.beam.runners.gearpump.GearpumpPipelineOptions;
import org.apache.beam.runners.gearpump.GearpumpPipelineResult;
import org.apache.beam.runners.gearpump.GearpumpRunner;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineRunner;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsValidator;

public class TestGearpumpRunner
extends PipelineRunner<GearpumpPipelineResult> {
    private final GearpumpRunner delegate;

    private TestGearpumpRunner(GearpumpPipelineOptions options) {
        options.setRemote(false);
        this.delegate = GearpumpRunner.fromOptions(options);
    }

    public static TestGearpumpRunner fromOptions(PipelineOptions options) {
        GearpumpPipelineOptions pipelineOptions = (GearpumpPipelineOptions)PipelineOptionsValidator.validate(GearpumpPipelineOptions.class, (PipelineOptions)options);
        return new TestGearpumpRunner(pipelineOptions);
    }

    public GearpumpPipelineResult run(Pipeline pipeline) {
        GearpumpPipelineResult result = this.delegate.run(pipeline);
        result.waitUntilFinish();
        ClientContext client = result.getClientContext();
        client.close();
        return result;
    }
}

