/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.gearpump.translators.utils;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.beam.runners.core.DoFnRunner;
import org.apache.beam.runners.core.DoFnRunners;
import org.apache.beam.runners.core.PushbackSideInputDoFnRunner;
import org.apache.beam.runners.core.ReadyCheckingSideInputReader;
import org.apache.beam.runners.core.SideInputReader;
import org.apache.beam.runners.core.SimplePushbackSideInputDoFnRunner;
import org.apache.beam.runners.core.StepContext;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.gearpump.GearpumpPipelineOptions;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;

public class DoFnRunnerFactory<InputT, OutputT>
implements Serializable {
    private static final long serialVersionUID = -4109539010014189725L;
    private final DoFn<InputT, OutputT> fn;
    private final SerializablePipelineOptions serializedOptions;
    private final Collection<PCollectionView<?>> sideInputs;
    private final DoFnRunners.OutputManager outputManager;
    private final TupleTag<OutputT> mainOutputTag;
    private final List<TupleTag<?>> sideOutputTags;
    private final StepContext stepContext;
    Map<TupleTag<?>, Coder<?>> outputCoders;
    private final WindowingStrategy<?, ?> windowingStrategy;

    public DoFnRunnerFactory(GearpumpPipelineOptions pipelineOptions, DoFn<InputT, OutputT> doFn, Collection<PCollectionView<?>> sideInputs, DoFnRunners.OutputManager outputManager, TupleTag<OutputT> mainOutputTag, List<TupleTag<?>> sideOutputTags, StepContext stepContext, Map<TupleTag<?>, Coder<?>> outputCoders, WindowingStrategy<?, ?> windowingStrategy) {
        this.fn = doFn;
        this.serializedOptions = new SerializablePipelineOptions((PipelineOptions)pipelineOptions);
        this.sideInputs = sideInputs;
        this.outputManager = outputManager;
        this.mainOutputTag = mainOutputTag;
        this.sideOutputTags = sideOutputTags;
        this.stepContext = stepContext;
        this.outputCoders = outputCoders;
        this.windowingStrategy = windowingStrategy;
    }

    public PushbackSideInputDoFnRunner<InputT, OutputT> createRunner(ReadyCheckingSideInputReader sideInputReader) {
        PipelineOptions options = this.serializedOptions.get();
        DoFnRunner underlying = DoFnRunners.simpleRunner((PipelineOptions)options, this.fn, (SideInputReader)sideInputReader, (DoFnRunners.OutputManager)this.outputManager, this.mainOutputTag, this.sideOutputTags, (StepContext)this.stepContext, null, this.outputCoders, this.windowingStrategy);
        return SimplePushbackSideInputDoFnRunner.create((DoFnRunner)underlying, this.sideInputs, (ReadyCheckingSideInputReader)sideInputReader);
    }
}

