/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.gearpump.translators;

import io.gearpump.streaming.dsl.api.functions.MapFunction;
import io.gearpump.streaming.dsl.javaapi.JavaStream;
import java.util.HashSet;
import org.apache.beam.runners.gearpump.translators.TransformTranslator;
import org.apache.beam.runners.gearpump.translators.TranslationContext;
import org.apache.beam.runners.gearpump.translators.io.UnboundedSourceWrapper;
import org.apache.beam.runners.gearpump.translators.io.ValuesSource;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Lists;

public class FlattenPCollectionsTranslator<T>
implements TransformTranslator<Flatten.PCollections<T>> {
    private static final long serialVersionUID = -5552148802472944759L;

    @Override
    public void translate(Flatten.PCollections<T> transform, TranslationContext context) {
        JavaStream merged = null;
        HashSet<PCollection> unique = new HashSet<PCollection>();
        for (PValue input : context.getInputs().values()) {
            PCollection collection = (PCollection)input;
            JavaStream inputStream = context.getInputStream((PValue)collection);
            if (null == merged) {
                merged = inputStream;
            } else {
                if (unique.contains(collection)) {
                    inputStream = inputStream.map(new DummyFunction(), "dummy");
                }
                merged = merged.merge(inputStream, 1, transform.getName());
            }
            unique.add(collection);
        }
        if (null == merged) {
            UnboundedSourceWrapper unboundedSourceWrapper = new UnboundedSourceWrapper(new ValuesSource(Lists.newArrayList((Object[])new String[]{"dummy"}), StringUtf8Coder.of()), context.getPipelineOptions());
            merged = context.getSourceStream(unboundedSourceWrapper);
        }
        context.setOutputStream(context.getOutput(), merged);
    }

    private static class DummyFunction<T>
    extends MapFunction<T, T> {
        private static final long serialVersionUID = 5454396869997290471L;

        private DummyFunction() {
        }

        public T map(T t) {
            return t;
        }
    }
}

