/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.examples.streaming;

import java.io.IOException;
import java.util.List;
import org.apache.beam.runners.flink.FlinkRunner;
import org.apache.beam.runners.flink.examples.streaming.WindowedWordCount;
import org.apache.beam.runners.flink.translation.wrappers.streaming.io.UnboundedSocketSource;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.Aggregator;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Filter;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Partition;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.Sum;
import org.apache.beam.sdk.transforms.Top;
import org.apache.beam.sdk.transforms.windowing.AfterWatermark;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.joda.time.Duration;

public class AutoComplete {
    public static void main(String[] args) throws IOException {
        Options options = (Options)PipelineOptionsFactory.fromArgs((String[])args).withValidation().as(Options.class);
        options.setStreaming(true);
        options.setCheckpointingInterval(1000L);
        options.setNumberOfExecutionRetries(5);
        options.setExecutionRetryDelay(3000L);
        options.setRunner(FlinkRunner.class);
        FixedWindows windowFn = FixedWindows.of((Duration)Duration.standardSeconds((long)options.getWindowSize()));
        Pipeline p = Pipeline.create((PipelineOptions)options);
        PCollection toWrite = (PCollection)((PCollection)((PCollection)((PCollection)p.apply("WordStream", (PTransform)Read.from((UnboundedSource)new UnboundedSocketSource("localhost", 9999, '\n', 3L)))).apply((PTransform)ParDo.of((DoFn)new ExtractWordsFn()))).apply((PTransform)Window.into((WindowFn)windowFn).triggering((Trigger)AfterWatermark.pastEndOfWindow()).withAllowedLateness(Duration.ZERO).discardingFiredPanes())).apply((PTransform)ComputeTopCompletions.top(10, options.getRecursive()));
        ((PCollection)toWrite.apply("FormatForPerTaskFile", (PTransform)ParDo.of((DoFn)new FormatForPerTaskLocalFile()))).apply((PTransform)TextIO.Write.to((String)"./outputAutoComplete.txt"));
        p.run();
    }

    private static interface Options
    extends WindowedWordCount.StreamingWordCountOptions {
        @Description(value="Whether to use the recursive algorithm")
        @Default.Boolean(value=true)
        public Boolean getRecursive();

        public void setRecursive(Boolean var1);
    }

    static class FormatForPerTaskLocalFile
    extends DoFn<KV<String, List<CompletionCandidate>>, String> {
        private static final long serialVersionUID = 0L;

        FormatForPerTaskLocalFile() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c, BoundedWindow window) {
            StringBuilder str = new StringBuilder();
            KV elem = (KV)c.element();
            str.append((String)elem.getKey() + " @ " + window + " -> ");
            for (CompletionCandidate cand : (List)elem.getValue()) {
                str.append(cand.toString() + " ");
            }
            System.out.println(str.toString());
            c.output((Object)str.toString());
        }
    }

    static class ExtractWordsFn
    extends DoFn<String, String> {
        private final Aggregator<Long, Long> emptyLines = this.createAggregator("emptyLines", (Combine.CombineFn)new Sum.SumLongFn());

        ExtractWordsFn() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            String[] words;
            if (((String)c.element()).trim().isEmpty()) {
                this.emptyLines.addValue((Object)1L);
            }
            for (String word : words = ((String)c.element()).split("[^a-zA-Z']+")) {
                if (word.isEmpty()) continue;
                c.output((Object)word);
            }
        }
    }

    @DefaultCoder(value=AvroCoder.class)
    static class CompletionCandidate
    implements Comparable<CompletionCandidate> {
        private long count;
        private String value;

        public CompletionCandidate(String value, long count) {
            this.value = value;
            this.count = count;
        }

        public String getValue() {
            return this.value;
        }

        public CompletionCandidate() {
        }

        @Override
        public int compareTo(CompletionCandidate o) {
            if (this.count < o.count) {
                return -1;
            }
            if (this.count == o.count) {
                return this.value.compareTo(o.value);
            }
            return 1;
        }

        public boolean equals(Object other) {
            if (other instanceof CompletionCandidate) {
                CompletionCandidate that = (CompletionCandidate)other;
                return this.count == that.count && this.value.equals(that.value);
            }
            return false;
        }

        public int hashCode() {
            return Long.valueOf(this.count).hashCode() ^ this.value.hashCode();
        }

        public String toString() {
            return "CompletionCandidate[" + this.value + ", " + this.count + "]";
        }
    }

    private static class AllPrefixes
    extends DoFn<CompletionCandidate, KV<String, CompletionCandidate>> {
        private static final long serialVersionUID = 0L;
        private final int minPrefix;
        private final int maxPrefix;

        public AllPrefixes(int minPrefix) {
            this(minPrefix, Integer.MAX_VALUE);
        }

        public AllPrefixes(int minPrefix, int maxPrefix) {
            this.minPrefix = minPrefix;
            this.maxPrefix = maxPrefix;
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            String word = ((CompletionCandidate)c.element()).value;
            for (int i = this.minPrefix; i <= Math.min(word.length(), this.maxPrefix); ++i) {
                KV kv = KV.of((Object)word.substring(0, i), (Object)c.element());
                c.output((Object)kv);
            }
        }
    }

    private static class ComputeTopRecursive
    extends PTransform<PCollection<CompletionCandidate>, PCollectionList<KV<String, List<CompletionCandidate>>>> {
        private static final long serialVersionUID = 0L;
        private final int candidatesPerPrefix;
        private final int minPrefix;

        public ComputeTopRecursive(int candidatesPerPrefix, int minPrefix) {
            this.candidatesPerPrefix = candidatesPerPrefix;
            this.minPrefix = minPrefix;
        }

        public PCollectionList<KV<String, List<CompletionCandidate>>> apply(PCollection<CompletionCandidate> input) {
            if (this.minPrefix > 10) {
                return (PCollectionList)((PCollection)input.apply((PTransform)new ComputeTopFlat(this.candidatesPerPrefix, this.minPrefix))).apply((PTransform)Partition.of((int)2, (Partition.PartitionFn)new KeySizePartitionFn()));
            }
            PCollectionList larger = (PCollectionList)input.apply((PTransform)new ComputeTopRecursive(this.candidatesPerPrefix, this.minPrefix + 1));
            PCollection small = (PCollection)((PCollection)((PCollection)PCollectionList.of((PCollection)((PCollection)larger.get(1).apply((PTransform)ParDo.of((DoFn)new FlattenTops())))).and((PCollection)input.apply((PTransform)Filter.by((SerializableFunction)new SerializableFunction<CompletionCandidate, Boolean>(){
                private static final long serialVersionUID = 0L;

                public Boolean apply(CompletionCandidate c) {
                    return c.getValue().length() == ComputeTopRecursive.this.minPrefix;
                }
            }))).apply("FlattenSmall", (PTransform)Flatten.pCollections())).apply((PTransform)ParDo.of((DoFn)new AllPrefixes(this.minPrefix, this.minPrefix)))).apply((PTransform)Top.largestPerKey((int)this.candidatesPerPrefix));
            PCollection flattenLarger = (PCollection)larger.apply("FlattenLarge", (PTransform)Flatten.pCollections());
            return PCollectionList.of((PCollection)flattenLarger).and(small);
        }

        private static class FlattenTops
        extends DoFn<KV<String, List<CompletionCandidate>>, CompletionCandidate> {
            private static final long serialVersionUID = 0L;

            private FlattenTops() {
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                for (CompletionCandidate cc : (List)((KV)c.element()).getValue()) {
                    c.output((Object)cc);
                }
            }
        }

        private class KeySizePartitionFn
        implements Partition.PartitionFn<KV<String, List<CompletionCandidate>>> {
            private static final long serialVersionUID = 0L;

            private KeySizePartitionFn() {
            }

            public int partitionFor(KV<String, List<CompletionCandidate>> elem, int numPartitions) {
                return ((String)elem.getKey()).length() > ComputeTopRecursive.this.minPrefix ? 0 : 1;
            }
        }
    }

    private static class ComputeTopFlat
    extends PTransform<PCollection<CompletionCandidate>, PCollection<KV<String, List<CompletionCandidate>>>> {
        private static final long serialVersionUID = 0L;
        private final int candidatesPerPrefix;
        private final int minPrefix;

        public ComputeTopFlat(int candidatesPerPrefix, int minPrefix) {
            this.candidatesPerPrefix = candidatesPerPrefix;
            this.minPrefix = minPrefix;
        }

        public PCollection<KV<String, List<CompletionCandidate>>> apply(PCollection<CompletionCandidate> input) {
            return (PCollection)((PCollection)input.apply((PTransform)ParDo.of((DoFn)new AllPrefixes(this.minPrefix)))).apply((PTransform)Top.largestPerKey((int)this.candidatesPerPrefix).withHotKeyFanout((SerializableFunction)new HotKeyFanout()));
        }

        private static class HotKeyFanout
        implements SerializableFunction<String, Integer> {
            private static final long serialVersionUID = 0L;

            private HotKeyFanout() {
            }

            public Integer apply(String input) {
                return (int)Math.pow(4.0, 5 - input.length());
            }
        }
    }

    public static class ComputeTopCompletions
    extends PTransform<PCollection<String>, PCollection<KV<String, List<CompletionCandidate>>>> {
        private static final long serialVersionUID = 0L;
        private final int candidatesPerPrefix;
        private final boolean recursive;

        protected ComputeTopCompletions(int candidatesPerPrefix, boolean recursive) {
            this.candidatesPerPrefix = candidatesPerPrefix;
            this.recursive = recursive;
        }

        public static ComputeTopCompletions top(int candidatesPerPrefix, boolean recursive) {
            return new ComputeTopCompletions(candidatesPerPrefix, recursive);
        }

        public PCollection<KV<String, List<CompletionCandidate>>> apply(PCollection<String> input) {
            PCollection candidates = (PCollection)((PCollection)input.apply((PTransform)new Count.PerElement())).apply("CreateCompletionCandidates", (PTransform)ParDo.of((DoFn)new DoFn<KV<String, Long>, CompletionCandidate>(){
                private static final long serialVersionUID = 0L;

                @DoFn.ProcessElement
                public void processElement(DoFn.ProcessContext c) {
                    CompletionCandidate cand = new CompletionCandidate((String)((KV)c.element()).getKey(), (Long)((KV)c.element()).getValue());
                    c.output((Object)cand);
                }
            }));
            if (this.recursive) {
                return (PCollection)((PCollectionList)candidates.apply((PTransform)new ComputeTopRecursive(this.candidatesPerPrefix, 1))).apply((PTransform)Flatten.pCollections());
            }
            return (PCollection)candidates.apply((PTransform)new ComputeTopFlat(this.candidatesPerPrefix, 1));
        }
    }
}

