/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.triggers;

import org.apache.beam.runners.core.triggers.AfterAllStateMachine;
import org.apache.beam.runners.core.triggers.AfterDelayFromFirstElementStateMachine;
import org.apache.beam.runners.core.triggers.AfterEachStateMachine;
import org.apache.beam.runners.core.triggers.AfterFirstStateMachine;
import org.apache.beam.runners.core.triggers.AfterPaneStateMachine;
import org.apache.beam.runners.core.triggers.AfterWatermarkStateMachine;
import org.apache.beam.runners.core.triggers.DefaultTriggerStateMachine;
import org.apache.beam.runners.core.triggers.NeverStateMachine;
import org.apache.beam.runners.core.triggers.OrFinallyStateMachine;
import org.apache.beam.runners.core.triggers.RepeatedlyStateMachine;
import org.apache.beam.runners.core.triggers.TriggerStateMachine;
import org.apache.beam.runners.core.triggers.TriggerStateMachines;
import org.apache.beam.sdk.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.sdk.transforms.windowing.AfterAll;
import org.apache.beam.sdk.transforms.windowing.AfterDelayFromFirstElement;
import org.apache.beam.sdk.transforms.windowing.AfterEach;
import org.apache.beam.sdk.transforms.windowing.AfterFirst;
import org.apache.beam.sdk.transforms.windowing.AfterPane;
import org.apache.beam.sdk.transforms.windowing.AfterProcessingTime;
import org.apache.beam.sdk.transforms.windowing.AfterWatermark;
import org.apache.beam.sdk.transforms.windowing.DefaultTrigger;
import org.apache.beam.sdk.transforms.windowing.Never;
import org.apache.beam.sdk.transforms.windowing.OrFinallyTrigger;
import org.apache.beam.sdk.transforms.windowing.Repeatedly;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.util.TimeDomain;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TriggerStateMachinesTest {
    private static final int ELEM_COUNT = 472;
    private static final Duration DELAY = Duration.standardSeconds((long)95673L);
    private final Trigger.OnceTrigger subtrigger1 = AfterPane.elementCountAtLeast((int)472);
    private final Trigger.OnceTrigger subtrigger2 = AfterProcessingTime.pastFirstElementInPane().plusDelayOf(DELAY);
    private final TriggerStateMachine.OnceTriggerStateMachine submachine1 = TriggerStateMachines.stateMachineForOnceTrigger((Trigger.OnceTrigger)this.subtrigger1);
    private final TriggerStateMachine.OnceTriggerStateMachine submachine2 = TriggerStateMachines.stateMachineForOnceTrigger((Trigger.OnceTrigger)this.subtrigger2);

    @Test
    public void testStateMachineForAfterPane() {
        int count = 37;
        AfterPane trigger = AfterPane.elementCountAtLeast((int)count);
        AfterPaneStateMachine machine = (AfterPaneStateMachine)TriggerStateMachines.stateMachineForOnceTrigger((Trigger.OnceTrigger)trigger);
        Assert.assertThat((Object)machine.getElementCount(), (Matcher)Matchers.equalTo((Object)trigger.getElementCount()));
    }

    @Test
    public void testStateMachineForAfterProcessingTime() {
        Duration minutes = Duration.standardMinutes((long)94L);
        Duration hours = Duration.standardHours((long)13L);
        AfterDelayFromFirstElement trigger = AfterProcessingTime.pastFirstElementInPane().plusDelayOf(minutes).alignedTo(hours);
        AfterDelayFromFirstElementStateMachine machine = (AfterDelayFromFirstElementStateMachine)TriggerStateMachines.stateMachineForOnceTrigger((Trigger.OnceTrigger)trigger);
        Assert.assertThat((Object)machine.getTimeDomain(), (Matcher)Matchers.equalTo((Object)TimeDomain.PROCESSING_TIME));
        Assert.assertThat((Object)machine.getTimestampMappers(), (Matcher)Matchers.equalTo((Object)trigger.getTimestampMappers()));
    }

    @Test
    public void testStateMachineForAfterWatermark() {
        AfterWatermark.FromEndOfWindow trigger = AfterWatermark.pastEndOfWindow();
        AfterWatermarkStateMachine.FromEndOfWindow machine = (AfterWatermarkStateMachine.FromEndOfWindow)TriggerStateMachines.stateMachineForOnceTrigger((Trigger.OnceTrigger)trigger);
    }

    @Test
    public void testDefaultTriggerTranslation() {
        DefaultTrigger trigger = DefaultTrigger.of();
        DefaultTriggerStateMachine machine = (DefaultTriggerStateMachine)Preconditions.checkNotNull((Object)TriggerStateMachines.stateMachineForTrigger((Trigger)trigger));
    }

    @Test
    public void testNeverTranslation() {
        Never.NeverTrigger trigger = Never.ever();
        NeverStateMachine machine = (NeverStateMachine)Preconditions.checkNotNull((Object)TriggerStateMachines.stateMachineForTrigger((Trigger)trigger));
    }

    @Test
    public void testAfterEachTranslation() {
        AfterEach trigger = AfterEach.inOrder((Trigger[])new Trigger[]{this.subtrigger1, this.subtrigger2});
        AfterEachStateMachine machine = (AfterEachStateMachine)TriggerStateMachines.stateMachineForTrigger((Trigger)trigger);
        Assert.assertThat((Object)machine, (Matcher)Matchers.equalTo((Object)AfterEachStateMachine.inOrder((TriggerStateMachine[])new TriggerStateMachine[]{this.submachine1, this.submachine2})));
    }

    @Test
    public void testAfterFirstTranslation() {
        AfterFirst trigger = AfterFirst.of((Trigger.OnceTrigger[])new Trigger.OnceTrigger[]{this.subtrigger1, this.subtrigger2});
        AfterFirstStateMachine machine = (AfterFirstStateMachine)TriggerStateMachines.stateMachineForTrigger((Trigger)trigger);
        Assert.assertThat((Object)machine, (Matcher)Matchers.equalTo((Object)AfterFirstStateMachine.of((TriggerStateMachine.OnceTriggerStateMachine[])new TriggerStateMachine.OnceTriggerStateMachine[]{this.submachine1, this.submachine2})));
    }

    @Test
    public void testAfterAllTranslation() {
        AfterAll trigger = AfterAll.of((Trigger.OnceTrigger[])new Trigger.OnceTrigger[]{this.subtrigger1, this.subtrigger2});
        AfterAllStateMachine machine = (AfterAllStateMachine)TriggerStateMachines.stateMachineForTrigger((Trigger)trigger);
        Assert.assertThat((Object)machine, (Matcher)Matchers.equalTo((Object)AfterAllStateMachine.of((TriggerStateMachine.OnceTriggerStateMachine[])new TriggerStateMachine.OnceTriggerStateMachine[]{this.submachine1, this.submachine2})));
    }

    @Test
    public void testAfterWatermarkEarlyTranslation() {
        AfterWatermark.AfterWatermarkEarlyAndLate trigger = AfterWatermark.pastEndOfWindow().withEarlyFirings(this.subtrigger1);
        AfterWatermarkStateMachine.AfterWatermarkEarlyAndLate machine = (AfterWatermarkStateMachine.AfterWatermarkEarlyAndLate)TriggerStateMachines.stateMachineForTrigger((Trigger)trigger);
        Assert.assertThat((Object)machine, (Matcher)Matchers.equalTo((Object)AfterWatermarkStateMachine.pastEndOfWindow().withEarlyFirings(this.submachine1)));
    }

    @Test
    public void testAfterWatermarkEarlyLateTranslation() {
        AfterWatermark.AfterWatermarkEarlyAndLate trigger = AfterWatermark.pastEndOfWindow().withEarlyFirings(this.subtrigger1).withLateFirings(this.subtrigger2);
        AfterWatermarkStateMachine.AfterWatermarkEarlyAndLate machine = (AfterWatermarkStateMachine.AfterWatermarkEarlyAndLate)TriggerStateMachines.stateMachineForTrigger((Trigger)trigger);
        Assert.assertThat((Object)machine, (Matcher)Matchers.equalTo((Object)AfterWatermarkStateMachine.pastEndOfWindow().withEarlyFirings(this.submachine1).withLateFirings(this.submachine2)));
    }

    @Test
    public void testOrFinallyTranslation() {
        OrFinallyTrigger trigger = this.subtrigger1.orFinally(this.subtrigger2);
        OrFinallyStateMachine machine = (OrFinallyStateMachine)TriggerStateMachines.stateMachineForTrigger((Trigger)trigger);
        Assert.assertThat((Object)machine, (Matcher)Matchers.equalTo((Object)this.submachine1.orFinally(this.submachine2)));
    }

    @Test
    public void testRepeatedlyTranslation() {
        Repeatedly trigger = Repeatedly.forever((Trigger)this.subtrigger1);
        RepeatedlyStateMachine machine = (RepeatedlyStateMachine)TriggerStateMachines.stateMachineForTrigger((Trigger)trigger);
        Assert.assertThat((Object)machine, (Matcher)Matchers.equalTo((Object)RepeatedlyStateMachine.forever((TriggerStateMachine)this.submachine1)));
    }
}

