/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.triggers;

import org.apache.beam.runners.core.triggers.ReshuffleTriggerStateMachine;
import org.apache.beam.runners.core.triggers.TriggerStateMachine;
import org.apache.beam.runners.core.triggers.TriggerStateMachineTester;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ReshuffleTriggerStateMachineTest {
    public static <W extends BoundedWindow> ReshuffleTriggerStateMachine forTest() {
        return new ReshuffleTriggerStateMachine();
    }

    @Test
    public void testShouldFire() throws Exception {
        TriggerStateMachineTester.SimpleTriggerStateMachineTester<IntervalWindow> tester = TriggerStateMachineTester.forTrigger((TriggerStateMachine)new ReshuffleTriggerStateMachine(), FixedWindows.of((Duration)Duration.millis((long)100L)));
        IntervalWindow arbitraryWindow = new IntervalWindow(new Instant(300L), new Instant(400L));
        Assert.assertTrue((boolean)tester.shouldFire(arbitraryWindow));
    }

    @Test
    public void testOnTimer() throws Exception {
        TriggerStateMachineTester.SimpleTriggerStateMachineTester<IntervalWindow> tester = TriggerStateMachineTester.forTrigger((TriggerStateMachine)new ReshuffleTriggerStateMachine(), FixedWindows.of((Duration)Duration.millis((long)100L)));
        IntervalWindow arbitraryWindow = new IntervalWindow(new Instant(100L), new Instant(200L));
        tester.fireIfShouldFire(arbitraryWindow);
        Assert.assertFalse((boolean)tester.isMarkedFinished(arbitraryWindow));
    }

    @Test
    public void testToString() {
        ReshuffleTriggerStateMachine trigger = new ReshuffleTriggerStateMachine();
        Assert.assertEquals((Object)"ReshuffleTriggerStateMachine()", (Object)trigger.toString());
    }
}

