/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.triggers;

import org.apache.beam.runners.core.triggers.AfterFirstStateMachine;
import org.apache.beam.runners.core.triggers.AfterPaneStateMachine;
import org.apache.beam.runners.core.triggers.AfterProcessingTimeStateMachine;
import org.apache.beam.runners.core.triggers.RepeatedlyStateMachine;
import org.apache.beam.runners.core.triggers.StubTriggerStateMachine;
import org.apache.beam.runners.core.triggers.TriggerStateMachine;
import org.apache.beam.runners.core.triggers.TriggerStateMachineTester;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.Sessions;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class RepeatedlyStateMachineTest {
    @Mock
    private TriggerStateMachine mockTrigger;
    private TriggerStateMachineTester.SimpleTriggerStateMachineTester<IntervalWindow> tester;

    private static TriggerStateMachine.TriggerContext anyTriggerContext() {
        return (TriggerStateMachine.TriggerContext)Mockito.any();
    }

    public void setUp(WindowFn<Object, IntervalWindow> windowFn) throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.tester = TriggerStateMachineTester.forTrigger((TriggerStateMachine)RepeatedlyStateMachine.forever((TriggerStateMachine)this.mockTrigger), windowFn);
    }

    @Test
    public void testOnElement() throws Exception {
        this.setUp((WindowFn<Object, IntervalWindow>)FixedWindows.of((Duration)Duration.millis((long)10L)));
        this.tester.injectElements(37);
        ((TriggerStateMachine)Mockito.verify((Object)this.mockTrigger)).onElement((TriggerStateMachine.OnElementContext)Mockito.any());
    }

    @Test
    public void testShouldFire() throws Exception {
        this.setUp((WindowFn<Object, IntervalWindow>)FixedWindows.of((Duration)Duration.millis((long)10L)));
        Mockito.when((Object)this.mockTrigger.shouldFire(RepeatedlyStateMachineTest.anyTriggerContext())).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.tester.shouldFire(new IntervalWindow(new Instant(0L), new Instant(10L))));
        Mockito.when((Object)this.mockTrigger.shouldFire((TriggerStateMachine.TriggerContext)Mockito.any())).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.tester.shouldFire(new IntervalWindow(new Instant(0L), new Instant(10L))));
    }

    @Test
    public void testShouldFireAfterMerge() throws Exception {
        this.tester = TriggerStateMachineTester.forTrigger((TriggerStateMachine)RepeatedlyStateMachine.forever((TriggerStateMachine)AfterPaneStateMachine.elementCountAtLeast((int)2)), Sessions.withGapDuration((Duration)Duration.millis((long)10L)));
        this.tester.injectElements(1);
        IntervalWindow firstWindow = new IntervalWindow(new Instant(1L), new Instant(11L));
        Assert.assertFalse((boolean)this.tester.shouldFire(firstWindow));
        this.tester.injectElements(5);
        IntervalWindow secondWindow = new IntervalWindow(new Instant(5L), new Instant(15L));
        Assert.assertFalse((boolean)this.tester.shouldFire(secondWindow));
        this.tester.mergeWindows();
        IntervalWindow mergedWindow = new IntervalWindow(new Instant(1L), new Instant(15L));
        Assert.assertTrue((boolean)this.tester.shouldFire(mergedWindow));
    }

    @Test
    public void testRepeatedlyAfterFirstElementCount() throws Exception {
        TriggerStateMachineTester.SimpleTriggerStateMachineTester<GlobalWindow> tester = TriggerStateMachineTester.forTrigger((TriggerStateMachine)RepeatedlyStateMachine.forever((TriggerStateMachine)AfterFirstStateMachine.of((TriggerStateMachine.OnceTriggerStateMachine[])new TriggerStateMachine.OnceTriggerStateMachine[]{AfterProcessingTimeStateMachine.pastFirstElementInPane().plusDelayOf(Duration.standardMinutes((long)15L)), AfterPaneStateMachine.elementCountAtLeast((int)5)})), new GlobalWindows());
        GlobalWindow window = GlobalWindow.INSTANCE;
        tester.injectElements(1);
        Assert.assertFalse((boolean)tester.shouldFire(window));
        tester.injectElements(2, 3, 4, 5);
        Assert.assertTrue((boolean)tester.shouldFire(window));
        tester.fireIfShouldFire(window);
        Assert.assertFalse((boolean)tester.shouldFire(window));
    }

    @Test
    public void testRepeatedlyAfterFirstProcessingTime() throws Exception {
        TriggerStateMachineTester.SimpleTriggerStateMachineTester<GlobalWindow> tester = TriggerStateMachineTester.forTrigger((TriggerStateMachine)RepeatedlyStateMachine.forever((TriggerStateMachine)AfterFirstStateMachine.of((TriggerStateMachine.OnceTriggerStateMachine[])new TriggerStateMachine.OnceTriggerStateMachine[]{AfterProcessingTimeStateMachine.pastFirstElementInPane().plusDelayOf(Duration.standardMinutes((long)15L)), AfterPaneStateMachine.elementCountAtLeast((int)5)})), new GlobalWindows());
        GlobalWindow window = GlobalWindow.INSTANCE;
        tester.injectElements(1);
        Assert.assertFalse((boolean)tester.shouldFire(window));
        tester.advanceProcessingTime(new Instant(0L).plus((ReadableDuration)Duration.standardMinutes((long)15L)));
        Assert.assertTrue((boolean)tester.shouldFire(window));
        tester.fireIfShouldFire(window);
        Assert.assertFalse((boolean)tester.shouldFire(window));
    }

    @Test
    public void testRepeatedlyElementCount() throws Exception {
        TriggerStateMachineTester.SimpleTriggerStateMachineTester<GlobalWindow> tester = TriggerStateMachineTester.forTrigger((TriggerStateMachine)RepeatedlyStateMachine.forever((TriggerStateMachine)AfterPaneStateMachine.elementCountAtLeast((int)5)), new GlobalWindows());
        GlobalWindow window = GlobalWindow.INSTANCE;
        tester.injectElements(1);
        Assert.assertFalse((boolean)tester.shouldFire(window));
        tester.injectElements(2, 3, 4, 5);
        Assert.assertTrue((boolean)tester.shouldFire(window));
        tester.fireIfShouldFire(window);
        Assert.assertFalse((boolean)tester.shouldFire(window));
    }

    @Test
    public void testRepeatedlyProcessingTime() throws Exception {
        TriggerStateMachineTester.SimpleTriggerStateMachineTester<GlobalWindow> tester = TriggerStateMachineTester.forTrigger((TriggerStateMachine)RepeatedlyStateMachine.forever((TriggerStateMachine)AfterProcessingTimeStateMachine.pastFirstElementInPane().plusDelayOf(Duration.standardMinutes((long)15L))), new GlobalWindows());
        GlobalWindow window = GlobalWindow.INSTANCE;
        tester.injectElements(1);
        Assert.assertFalse((boolean)tester.shouldFire(window));
        tester.advanceProcessingTime(new Instant(0L).plus((ReadableDuration)Duration.standardMinutes((long)15L)));
        Assert.assertTrue((boolean)tester.shouldFire(window));
        tester.fireIfShouldFire(window);
        Assert.assertFalse((boolean)tester.shouldFire(window));
    }

    @Test
    public void testToString() {
        RepeatedlyStateMachine trigger = RepeatedlyStateMachine.forever((TriggerStateMachine)new StubTriggerStateMachine(){

            public String toString() {
                return "innerTrigger";
            }
        });
        Assert.assertEquals((Object)"Repeatedly.forever(innerTrigger)", (Object)trigger.toString());
    }
}

