/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.triggers;

import org.apache.beam.runners.core.triggers.AfterEachStateMachine;
import org.apache.beam.runners.core.triggers.AfterPaneStateMachine;
import org.apache.beam.runners.core.triggers.AfterWatermarkStateMachine;
import org.apache.beam.runners.core.triggers.OrFinallyStateMachine;
import org.apache.beam.runners.core.triggers.RepeatedlyStateMachine;
import org.apache.beam.runners.core.triggers.StubTriggerStateMachine;
import org.apache.beam.runners.core.triggers.TriggerStateMachine;
import org.apache.beam.runners.core.triggers.TriggerStateMachineTester;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.Sessions;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class OrFinallyStateMachineTest {
    private TriggerStateMachineTester.SimpleTriggerStateMachineTester<IntervalWindow> tester;

    @Test
    public void testActualFiresAndFinishes() throws Exception {
        this.tester = TriggerStateMachineTester.forTrigger((TriggerStateMachine)new OrFinallyStateMachine((TriggerStateMachine)AfterPaneStateMachine.elementCountAtLeast((int)2), (TriggerStateMachine.OnceTriggerStateMachine)AfterPaneStateMachine.elementCountAtLeast((int)100)), FixedWindows.of((Duration)Duration.millis((long)100L)));
        IntervalWindow window = new IntervalWindow(new Instant(0L), new Instant(100L));
        this.tester.injectElements(1);
        Assert.assertFalse((boolean)this.tester.shouldFire(window));
        Assert.assertFalse((boolean)this.tester.isMarkedFinished(window));
        this.tester.injectElements(2);
        Assert.assertTrue((boolean)this.tester.shouldFire(window));
        this.tester.fireIfShouldFire(window);
        Assert.assertTrue((boolean)this.tester.isMarkedFinished(window));
    }

    @Test
    public void testActualFiresOnly() throws Exception {
        this.tester = TriggerStateMachineTester.forTrigger((TriggerStateMachine)new OrFinallyStateMachine((TriggerStateMachine)RepeatedlyStateMachine.forever((TriggerStateMachine)AfterPaneStateMachine.elementCountAtLeast((int)2)), (TriggerStateMachine.OnceTriggerStateMachine)AfterPaneStateMachine.elementCountAtLeast((int)100)), FixedWindows.of((Duration)Duration.millis((long)100L)));
        IntervalWindow window = new IntervalWindow(new Instant(0L), new Instant(100L));
        this.tester.injectElements(1);
        Assert.assertFalse((boolean)this.tester.shouldFire(window));
        Assert.assertFalse((boolean)this.tester.isMarkedFinished(window));
        this.tester.injectElements(2);
        Assert.assertTrue((boolean)this.tester.shouldFire(window));
        this.tester.fireIfShouldFire(window);
        Assert.assertFalse((boolean)this.tester.isMarkedFinished(window));
        this.tester.injectElements(3, 4);
        Assert.assertTrue((boolean)this.tester.shouldFire(window));
        this.tester.fireIfShouldFire(window);
        Assert.assertFalse((boolean)this.tester.isMarkedFinished(window));
    }

    @Test
    public void testShouldFireAfterMerge() throws Exception {
        this.tester = TriggerStateMachineTester.forTrigger(AfterEachStateMachine.inOrder((TriggerStateMachine[])new TriggerStateMachine[]{AfterPaneStateMachine.elementCountAtLeast((int)5).orFinally((TriggerStateMachine.OnceTriggerStateMachine)AfterWatermarkStateMachine.pastEndOfWindow()), RepeatedlyStateMachine.forever((TriggerStateMachine)AfterPaneStateMachine.elementCountAtLeast((int)1))}), Sessions.withGapDuration((Duration)Duration.millis((long)10L)));
        this.tester.injectElements(1);
        IntervalWindow firstWindow = new IntervalWindow(new Instant(1L), new Instant(11L));
        Assert.assertFalse((boolean)this.tester.shouldFire(firstWindow));
        this.tester.advanceInputWatermark(new Instant(11L));
        Assert.assertTrue((boolean)this.tester.shouldFire(firstWindow));
        this.tester.fireIfShouldFire(firstWindow);
        this.tester.injectElements(5);
        IntervalWindow secondWindow = new IntervalWindow(new Instant(5L), new Instant(15L));
        Assert.assertFalse((boolean)this.tester.shouldFire(secondWindow));
        this.tester.mergeWindows();
        IntervalWindow mergedWindow = new IntervalWindow(new Instant(1L), new Instant(15L));
        Assert.assertFalse((boolean)this.tester.shouldFire(mergedWindow));
        this.tester.injectElements(1, 2, 3, 4, 5);
        this.tester.mergeWindows();
        Assert.assertTrue((boolean)this.tester.shouldFire(mergedWindow));
    }

    @Test
    public void testActualFiresButUntilFinishes() throws Exception {
        this.tester = TriggerStateMachineTester.forTrigger((TriggerStateMachine)new OrFinallyStateMachine((TriggerStateMachine)RepeatedlyStateMachine.forever((TriggerStateMachine)AfterPaneStateMachine.elementCountAtLeast((int)2)), (TriggerStateMachine.OnceTriggerStateMachine)AfterPaneStateMachine.elementCountAtLeast((int)3)), FixedWindows.of((Duration)Duration.millis((long)10L)));
        IntervalWindow window = new IntervalWindow(new Instant(0L), new Instant(10L));
        this.tester.injectElements(1);
        Assert.assertFalse((boolean)this.tester.shouldFire(window));
        Assert.assertFalse((boolean)this.tester.isMarkedFinished(window));
        this.tester.injectElements(2);
        Assert.assertTrue((boolean)this.tester.shouldFire(window));
        this.tester.fireIfShouldFire(window);
        Assert.assertFalse((boolean)this.tester.isMarkedFinished(window));
        this.tester.injectElements(3);
        Assert.assertTrue((boolean)this.tester.shouldFire(window));
        this.tester.fireIfShouldFire(window);
        Assert.assertTrue((boolean)this.tester.isMarkedFinished(window));
    }

    @Test
    public void testToString() {
        TriggerStateMachine trigger = StubTriggerStateMachine.named("t1").orFinally(StubTriggerStateMachine.named("t2"));
        Assert.assertEquals((Object)"t1.orFinally(t2)", (Object)trigger.toString());
    }
}

