/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.triggers;

import org.apache.beam.runners.core.triggers.NeverStateMachine;
import org.apache.beam.runners.core.triggers.TriggerStateMachine;
import org.apache.beam.runners.core.triggers.TriggerStateMachineTester;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.values.TimestampedValue;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class NeverStateMachineTest {
    private TriggerStateMachineTester.SimpleTriggerStateMachineTester<IntervalWindow> triggerTester;

    @Before
    public void setup() throws Exception {
        this.triggerTester = TriggerStateMachineTester.forTrigger((TriggerStateMachine)NeverStateMachine.ever(), FixedWindows.of((Duration)Duration.standardMinutes((long)5L)));
    }

    @Test
    public void falseAfterEndOfWindow() throws Exception {
        this.triggerTester.injectElements(TimestampedValue.of((Object)1, (Instant)new Instant(1L)));
        IntervalWindow window = new IntervalWindow(new Instant(0L), new Instant(0L).plus((ReadableDuration)Duration.standardMinutes((long)5L)));
        Assert.assertThat((Object)this.triggerTester.shouldFire(window), (Matcher)Matchers.is((Object)false));
        this.triggerTester.advanceInputWatermark(BoundedWindow.TIMESTAMP_MAX_VALUE);
        Assert.assertThat((Object)this.triggerTester.shouldFire(window), (Matcher)Matchers.is((Object)false));
    }
}

