/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.triggers;

import org.apache.beam.runners.core.triggers.AfterAllStateMachine;
import org.apache.beam.runners.core.triggers.AfterFirstStateMachine;
import org.apache.beam.runners.core.triggers.AfterPaneStateMachine;
import org.apache.beam.runners.core.triggers.AfterProcessingTimeStateMachine;
import org.apache.beam.runners.core.triggers.AfterWatermarkStateMachine;
import org.apache.beam.runners.core.triggers.ExecutableTriggerStateMachine;
import org.apache.beam.runners.core.triggers.FinishedTriggers;
import org.apache.beam.runners.core.triggers.TriggerStateMachine;
import org.junit.Assert;

public class FinishedTriggersProperties {
    public static void verifyGetAfterSet(FinishedTriggers finishedSet, ExecutableTriggerStateMachine trigger) {
        Assert.assertFalse((boolean)finishedSet.isFinished(trigger));
        finishedSet.setFinished(trigger, true);
        Assert.assertTrue((boolean)finishedSet.isFinished(trigger));
    }

    public static void verifyGetAfterSet(FinishedTriggers finishedSet) {
        ExecutableTriggerStateMachine trigger = ExecutableTriggerStateMachine.create((TriggerStateMachine)AfterAllStateMachine.of((TriggerStateMachine.OnceTriggerStateMachine[])new TriggerStateMachine.OnceTriggerStateMachine[]{AfterFirstStateMachine.of((TriggerStateMachine.OnceTriggerStateMachine[])new TriggerStateMachine.OnceTriggerStateMachine[]{AfterPaneStateMachine.elementCountAtLeast((int)3), AfterWatermarkStateMachine.pastEndOfWindow()}), AfterAllStateMachine.of((TriggerStateMachine.OnceTriggerStateMachine[])new TriggerStateMachine.OnceTriggerStateMachine[]{AfterPaneStateMachine.elementCountAtLeast((int)10), AfterProcessingTimeStateMachine.pastFirstElementInPane()})}));
        FinishedTriggersProperties.verifyGetAfterSet(finishedSet, trigger);
        FinishedTriggersProperties.verifyGetAfterSet(finishedSet, (ExecutableTriggerStateMachine)((ExecutableTriggerStateMachine)trigger.subTriggers().get(0)).subTriggers().get(1));
        FinishedTriggersProperties.verifyGetAfterSet(finishedSet, (ExecutableTriggerStateMachine)trigger.subTriggers().get(0));
        FinishedTriggersProperties.verifyGetAfterSet(finishedSet, (ExecutableTriggerStateMachine)trigger.subTriggers().get(1));
        FinishedTriggersProperties.verifyGetAfterSet(finishedSet, (ExecutableTriggerStateMachine)((ExecutableTriggerStateMachine)trigger.subTriggers().get(1)).subTriggers().get(1));
        FinishedTriggersProperties.verifyGetAfterSet(finishedSet, (ExecutableTriggerStateMachine)((ExecutableTriggerStateMachine)trigger.subTriggers().get(1)).subTriggers().get(0));
    }

    public static void verifyClearRecursively(FinishedTriggers finishedSet) {
        ExecutableTriggerStateMachine trigger = ExecutableTriggerStateMachine.create((TriggerStateMachine)AfterAllStateMachine.of((TriggerStateMachine.OnceTriggerStateMachine[])new TriggerStateMachine.OnceTriggerStateMachine[]{AfterFirstStateMachine.of((TriggerStateMachine.OnceTriggerStateMachine[])new TriggerStateMachine.OnceTriggerStateMachine[]{AfterPaneStateMachine.elementCountAtLeast((int)3), AfterWatermarkStateMachine.pastEndOfWindow()}), AfterAllStateMachine.of((TriggerStateMachine.OnceTriggerStateMachine[])new TriggerStateMachine.OnceTriggerStateMachine[]{AfterPaneStateMachine.elementCountAtLeast((int)10), AfterProcessingTimeStateMachine.pastFirstElementInPane()})}));
        FinishedTriggersProperties.setFinishedRecursively(finishedSet, trigger);
        Assert.assertTrue((boolean)finishedSet.isFinished(trigger));
        Assert.assertTrue((boolean)finishedSet.isFinished((ExecutableTriggerStateMachine)trigger.subTriggers().get(0)));
        Assert.assertTrue((boolean)finishedSet.isFinished((ExecutableTriggerStateMachine)((ExecutableTriggerStateMachine)trigger.subTriggers().get(0)).subTriggers().get(0)));
        Assert.assertTrue((boolean)finishedSet.isFinished((ExecutableTriggerStateMachine)((ExecutableTriggerStateMachine)trigger.subTriggers().get(0)).subTriggers().get(1)));
        finishedSet.clearRecursively((ExecutableTriggerStateMachine)trigger.subTriggers().get(1));
        Assert.assertTrue((boolean)finishedSet.isFinished(trigger));
        FinishedTriggersProperties.verifyFinishedRecursively(finishedSet, (ExecutableTriggerStateMachine)trigger.subTriggers().get(0));
        FinishedTriggersProperties.verifyUnfinishedRecursively(finishedSet, (ExecutableTriggerStateMachine)trigger.subTriggers().get(1));
    }

    private static void setFinishedRecursively(FinishedTriggers finishedSet, ExecutableTriggerStateMachine trigger) {
        finishedSet.setFinished(trigger, true);
        for (ExecutableTriggerStateMachine subTrigger : trigger.subTriggers()) {
            FinishedTriggersProperties.setFinishedRecursively(finishedSet, subTrigger);
        }
    }

    private static void verifyFinishedRecursively(FinishedTriggers finishedSet, ExecutableTriggerStateMachine trigger) {
        Assert.assertTrue((boolean)finishedSet.isFinished(trigger));
        for (ExecutableTriggerStateMachine subTrigger : trigger.subTriggers()) {
            FinishedTriggersProperties.verifyFinishedRecursively(finishedSet, subTrigger);
        }
    }

    private static void verifyUnfinishedRecursively(FinishedTriggers finishedSet, ExecutableTriggerStateMachine trigger) {
        Assert.assertFalse((boolean)finishedSet.isFinished(trigger));
        for (ExecutableTriggerStateMachine subTrigger : trigger.subTriggers()) {
            FinishedTriggersProperties.verifyUnfinishedRecursively(finishedSet, subTrigger);
        }
    }
}

