/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.triggers;

import java.util.Arrays;
import org.apache.beam.runners.core.triggers.ExecutableTriggerStateMachine;
import org.apache.beam.runners.core.triggers.TriggerStateMachine;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ExecutableTriggerStateMachineTest {
    @Test
    public void testIndexAssignmentLeaf() throws Exception {
        StubStateMachine t1 = new StubStateMachine(new TriggerStateMachine[0]);
        ExecutableTriggerStateMachine executable = ExecutableTriggerStateMachine.create((TriggerStateMachine)t1);
        Assert.assertEquals((long)0L, (long)executable.getTriggerIndex());
    }

    @Test
    public void testIndexAssignmentOneLevel() throws Exception {
        StubStateMachine t1 = new StubStateMachine(new TriggerStateMachine[0]);
        StubStateMachine t2 = new StubStateMachine(new TriggerStateMachine[0]);
        StubStateMachine t = new StubStateMachine(t1, t2);
        ExecutableTriggerStateMachine executable = ExecutableTriggerStateMachine.create((TriggerStateMachine)t);
        Assert.assertEquals((long)0L, (long)executable.getTriggerIndex());
        Assert.assertEquals((long)1L, (long)((ExecutableTriggerStateMachine)executable.subTriggers().get(0)).getTriggerIndex());
        Assert.assertSame((Object)((Object)t1), (Object)((ExecutableTriggerStateMachine)executable.subTriggers().get(0)).getSpec());
        Assert.assertEquals((long)2L, (long)((ExecutableTriggerStateMachine)executable.subTriggers().get(1)).getTriggerIndex());
        Assert.assertSame((Object)((Object)t2), (Object)((ExecutableTriggerStateMachine)executable.subTriggers().get(1)).getSpec());
    }

    @Test
    public void testIndexAssignmentTwoLevel() throws Exception {
        StubStateMachine t11 = new StubStateMachine(new TriggerStateMachine[0]);
        StubStateMachine t12 = new StubStateMachine(new TriggerStateMachine[0]);
        StubStateMachine t13 = new StubStateMachine(new TriggerStateMachine[0]);
        StubStateMachine t14 = new StubStateMachine(new TriggerStateMachine[0]);
        StubStateMachine t21 = new StubStateMachine(new TriggerStateMachine[0]);
        StubStateMachine t22 = new StubStateMachine(new TriggerStateMachine[0]);
        StubStateMachine t1 = new StubStateMachine(t11, t12, t13, t14);
        StubStateMachine t2 = new StubStateMachine(t21, t22);
        StubStateMachine t = new StubStateMachine(t1, t2);
        ExecutableTriggerStateMachine executable = ExecutableTriggerStateMachine.create((TriggerStateMachine)t);
        Assert.assertEquals((long)0L, (long)executable.getTriggerIndex());
        Assert.assertEquals((long)1L, (long)((ExecutableTriggerStateMachine)executable.subTriggers().get(0)).getTriggerIndex());
        Assert.assertEquals((long)6L, (long)((ExecutableTriggerStateMachine)executable.subTriggers().get(0)).getFirstIndexAfterSubtree());
        Assert.assertEquals((long)6L, (long)((ExecutableTriggerStateMachine)executable.subTriggers().get(1)).getTriggerIndex());
        Assert.assertSame((Object)((Object)t1), (Object)executable.getSubTriggerContaining(1).getSpec());
        Assert.assertSame((Object)((Object)t2), (Object)executable.getSubTriggerContaining(6).getSpec());
        Assert.assertSame((Object)((Object)t1), (Object)executable.getSubTriggerContaining(2).getSpec());
        Assert.assertSame((Object)((Object)t1), (Object)executable.getSubTriggerContaining(3).getSpec());
        Assert.assertSame((Object)((Object)t1), (Object)executable.getSubTriggerContaining(5).getSpec());
        Assert.assertSame((Object)((Object)t2), (Object)executable.getSubTriggerContaining(7).getSpec());
    }

    private static class StubStateMachine
    extends TriggerStateMachine {
        @SafeVarargs
        protected StubStateMachine(TriggerStateMachine ... subTriggers) {
            super(Arrays.asList(subTriggers));
        }

        public void onElement(TriggerStateMachine.OnElementContext c) throws Exception {
        }

        public void onMerge(TriggerStateMachine.OnMergeContext c) throws Exception {
        }

        public void clear(TriggerStateMachine.TriggerContext c) throws Exception {
        }

        public boolean shouldFire(TriggerStateMachine.TriggerContext c) {
            return false;
        }

        public void onFire(TriggerStateMachine.TriggerContext c) {
        }
    }
}

