/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.triggers;

import org.apache.beam.runners.core.triggers.DefaultTriggerStateMachine;
import org.apache.beam.runners.core.triggers.TriggerStateMachine;
import org.apache.beam.runners.core.triggers.TriggerStateMachineTester;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.Sessions;
import org.apache.beam.sdk.transforms.windowing.SlidingWindows;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DefaultTriggerStateMachineTest {
    TriggerStateMachineTester.SimpleTriggerStateMachineTester<IntervalWindow> tester;

    @Test
    public void testDefaultTriggerFixedWindows() throws Exception {
        this.tester = TriggerStateMachineTester.forTrigger((TriggerStateMachine)DefaultTriggerStateMachine.of(), FixedWindows.of((Duration)Duration.millis((long)100L)));
        this.tester.injectElements(1, 101);
        IntervalWindow firstWindow = new IntervalWindow(new Instant(0L), new Instant(100L));
        IntervalWindow secondWindow = new IntervalWindow(new Instant(100L), new Instant(200L));
        this.tester.advanceInputWatermark(new Instant(99L));
        Assert.assertFalse((boolean)this.tester.shouldFire(firstWindow));
        Assert.assertFalse((boolean)this.tester.shouldFire(secondWindow));
        this.tester.advanceInputWatermark(new Instant(100L));
        Assert.assertTrue((boolean)this.tester.shouldFire(firstWindow));
        Assert.assertFalse((boolean)this.tester.shouldFire(secondWindow));
        this.tester.fireIfShouldFire(firstWindow);
        Assert.assertTrue((boolean)this.tester.shouldFire(firstWindow));
        Assert.assertFalse((boolean)this.tester.shouldFire(secondWindow));
        this.tester.advanceInputWatermark(new Instant(200L));
        Assert.assertTrue((boolean)this.tester.shouldFire(firstWindow));
        Assert.assertTrue((boolean)this.tester.shouldFire(secondWindow));
        Assert.assertFalse((boolean)this.tester.isMarkedFinished(firstWindow));
        Assert.assertFalse((boolean)this.tester.isMarkedFinished(secondWindow));
    }

    @Test
    public void testDefaultTriggerSlidingWindows() throws Exception {
        this.tester = TriggerStateMachineTester.forTrigger((TriggerStateMachine)DefaultTriggerStateMachine.of(), SlidingWindows.of((Duration)Duration.millis((long)100L)).every(Duration.millis((long)50L)));
        this.tester.injectElements(1, 50);
        IntervalWindow firstWindow = new IntervalWindow(new Instant(-50L), new Instant(50L));
        IntervalWindow secondWindow = new IntervalWindow(new Instant(0L), new Instant(100L));
        IntervalWindow thirdWindow = new IntervalWindow(new Instant(50L), new Instant(150L));
        Assert.assertFalse((boolean)this.tester.shouldFire(firstWindow));
        Assert.assertFalse((boolean)this.tester.shouldFire(secondWindow));
        Assert.assertFalse((boolean)this.tester.shouldFire(thirdWindow));
        this.tester.advanceInputWatermark(new Instant(50L));
        Assert.assertTrue((boolean)this.tester.shouldFire(firstWindow));
        Assert.assertFalse((boolean)this.tester.shouldFire(secondWindow));
        Assert.assertFalse((boolean)this.tester.shouldFire(thirdWindow));
        this.tester.fireIfShouldFire(firstWindow);
        Assert.assertTrue((boolean)this.tester.shouldFire(firstWindow));
        Assert.assertFalse((boolean)this.tester.shouldFire(secondWindow));
        Assert.assertFalse((boolean)this.tester.shouldFire(thirdWindow));
        this.tester.advanceInputWatermark(new Instant(99L));
        Assert.assertTrue((boolean)this.tester.shouldFire(firstWindow));
        Assert.assertFalse((boolean)this.tester.shouldFire(secondWindow));
        Assert.assertFalse((boolean)this.tester.shouldFire(thirdWindow));
        this.tester.advanceInputWatermark(new Instant(100L));
        Assert.assertTrue((boolean)this.tester.shouldFire(firstWindow));
        Assert.assertTrue((boolean)this.tester.shouldFire(secondWindow));
        Assert.assertFalse((boolean)this.tester.shouldFire(thirdWindow));
        this.tester.fireIfShouldFire(firstWindow);
        Assert.assertFalse((boolean)this.tester.isMarkedFinished(firstWindow));
        Assert.assertFalse((boolean)this.tester.isMarkedFinished(secondWindow));
        Assert.assertFalse((boolean)this.tester.isMarkedFinished(thirdWindow));
    }

    @Test
    public void testDefaultTriggerSessions() throws Exception {
        this.tester = TriggerStateMachineTester.forTrigger((TriggerStateMachine)DefaultTriggerStateMachine.of(), Sessions.withGapDuration((Duration)Duration.millis((long)100L)));
        this.tester.injectElements(1, 50);
        this.tester.mergeWindows();
        IntervalWindow firstWindow = new IntervalWindow(new Instant(1L), new Instant(101L));
        IntervalWindow secondWindow = new IntervalWindow(new Instant(50L), new Instant(150L));
        IntervalWindow mergedWindow = new IntervalWindow(new Instant(1L), new Instant(150L));
        this.tester.advanceInputWatermark(new Instant(100L));
        Assert.assertFalse((boolean)this.tester.shouldFire(firstWindow));
        Assert.assertFalse((boolean)this.tester.shouldFire(secondWindow));
        Assert.assertFalse((boolean)this.tester.shouldFire(mergedWindow));
        this.tester.advanceInputWatermark(new Instant(149L));
        Assert.assertTrue((boolean)this.tester.shouldFire(firstWindow));
        Assert.assertFalse((boolean)this.tester.shouldFire(secondWindow));
        Assert.assertFalse((boolean)this.tester.shouldFire(mergedWindow));
        this.tester.advanceInputWatermark(new Instant(150L));
        Assert.assertTrue((boolean)this.tester.shouldFire(firstWindow));
        Assert.assertTrue((boolean)this.tester.shouldFire(secondWindow));
        Assert.assertTrue((boolean)this.tester.shouldFire(mergedWindow));
        this.tester.fireIfShouldFire(mergedWindow);
        Assert.assertTrue((boolean)this.tester.shouldFire(mergedWindow));
        Assert.assertFalse((boolean)this.tester.isMarkedFinished(mergedWindow));
    }
}

