/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.triggers;

import org.apache.beam.runners.core.triggers.AfterEachStateMachine;
import org.apache.beam.runners.core.triggers.AfterPaneStateMachine;
import org.apache.beam.runners.core.triggers.AfterWatermarkStateMachine;
import org.apache.beam.runners.core.triggers.NeverStateMachine;
import org.apache.beam.runners.core.triggers.RepeatedlyStateMachine;
import org.apache.beam.runners.core.triggers.StubTriggerStateMachine;
import org.apache.beam.runners.core.triggers.TriggerStateMachine;
import org.apache.beam.runners.core.triggers.TriggerStateMachineTester;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.Sessions;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class AfterWatermarkStateMachineTest {
    @Mock
    private TriggerStateMachine.OnceTriggerStateMachine mockEarly;
    @Mock
    private TriggerStateMachine.OnceTriggerStateMachine mockLate;
    private TriggerStateMachineTester.SimpleTriggerStateMachineTester<IntervalWindow> tester;

    private static TriggerStateMachine.TriggerContext anyTriggerContext() {
        return (TriggerStateMachine.TriggerContext)Mockito.any();
    }

    private static TriggerStateMachine.OnElementContext anyElementContext() {
        return (TriggerStateMachine.OnElementContext)Mockito.any();
    }

    private void injectElements(int ... elements) throws Exception {
        for (int element : elements) {
            ((TriggerStateMachine.OnceTriggerStateMachine)Mockito.doNothing().when((Object)this.mockEarly)).onElement(AfterWatermarkStateMachineTest.anyElementContext());
            ((TriggerStateMachine.OnceTriggerStateMachine)Mockito.doNothing().when((Object)this.mockLate)).onElement(AfterWatermarkStateMachineTest.anyElementContext());
            this.tester.injectElements(element);
        }
    }

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
    }

    public void testRunningAsTrigger(TriggerStateMachine.OnceTriggerStateMachine mockTrigger, IntervalWindow window) throws Exception {
        Mockito.when((Object)mockTrigger.shouldFire(AfterWatermarkStateMachineTest.anyTriggerContext())).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.tester.shouldFire(window));
        Mockito.when((Object)mockTrigger.shouldFire(AfterWatermarkStateMachineTest.anyTriggerContext())).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.tester.shouldFire(window));
        this.tester.fireIfShouldFire(window);
        Assert.assertFalse((boolean)this.tester.isMarkedFinished(window));
    }

    @Test
    public void testEarlyAndAtWatermark() throws Exception {
        this.tester = TriggerStateMachineTester.forTrigger((TriggerStateMachine)AfterWatermarkStateMachine.pastEndOfWindow().withEarlyFirings(this.mockEarly), FixedWindows.of((Duration)Duration.millis((long)100L)));
        this.injectElements(1);
        IntervalWindow window = new IntervalWindow(new Instant(0L), new Instant(100L));
        this.testRunningAsTrigger(this.mockEarly, window);
        Mockito.when((Object)this.mockEarly.shouldFire(AfterWatermarkStateMachineTest.anyTriggerContext())).thenReturn((Object)false);
        this.tester.advanceInputWatermark(new Instant(100L));
        Assert.assertTrue((boolean)this.tester.shouldFire(window));
        this.tester.fireIfShouldFire(window);
        Assert.assertTrue((boolean)this.tester.isMarkedFinished(window));
    }

    @Test
    public void testAtWatermarkAndLate() throws Exception {
        this.tester = TriggerStateMachineTester.forTrigger((TriggerStateMachine)AfterWatermarkStateMachine.pastEndOfWindow().withLateFirings(this.mockLate), FixedWindows.of((Duration)Duration.millis((long)100L)));
        this.injectElements(1);
        IntervalWindow window = new IntervalWindow(new Instant(0L), new Instant(100L));
        Mockito.when((Object)this.mockEarly.shouldFire(AfterWatermarkStateMachineTest.anyTriggerContext())).thenReturn((Object)true);
        Assert.assertFalse((boolean)this.tester.shouldFire(window));
        this.tester.fireIfShouldFire(window);
        Assert.assertFalse((boolean)this.tester.isMarkedFinished(window));
        Mockito.when((Object)this.mockEarly.shouldFire(AfterWatermarkStateMachineTest.anyTriggerContext())).thenReturn((Object)false);
        this.tester.advanceInputWatermark(new Instant(100L));
        Assert.assertTrue((boolean)this.tester.shouldFire(window));
        this.tester.fireIfShouldFire(window);
        Assert.assertFalse((boolean)this.tester.isMarkedFinished(window));
        this.testRunningAsTrigger(this.mockLate, window);
    }

    @Test
    public void testEarlyAndAtWatermarkAndLate() throws Exception {
        this.tester = TriggerStateMachineTester.forTrigger((TriggerStateMachine)AfterWatermarkStateMachine.pastEndOfWindow().withEarlyFirings(this.mockEarly).withLateFirings(this.mockLate), FixedWindows.of((Duration)Duration.millis((long)100L)));
        this.injectElements(1);
        IntervalWindow window = new IntervalWindow(new Instant(0L), new Instant(100L));
        this.testRunningAsTrigger(this.mockEarly, window);
        Mockito.when((Object)this.mockEarly.shouldFire(AfterWatermarkStateMachineTest.anyTriggerContext())).thenReturn((Object)false);
        this.tester.advanceInputWatermark(new Instant(100L));
        Assert.assertTrue((boolean)this.tester.shouldFire(window));
        this.tester.fireIfShouldFire(window);
        Assert.assertFalse((boolean)this.tester.isMarkedFinished(window));
        this.testRunningAsTrigger(this.mockLate, window);
    }

    @Test
    public void testOnMergeAlreadyFinished() throws Exception {
        this.tester = TriggerStateMachineTester.forTrigger(AfterEachStateMachine.inOrder((TriggerStateMachine[])new TriggerStateMachine[]{AfterWatermarkStateMachine.pastEndOfWindow(), RepeatedlyStateMachine.forever((TriggerStateMachine)AfterPaneStateMachine.elementCountAtLeast((int)1))}), Sessions.withGapDuration((Duration)Duration.millis((long)10L)));
        this.tester.injectElements(1);
        this.tester.injectElements(5);
        IntervalWindow firstWindow = new IntervalWindow(new Instant(1L), new Instant(11L));
        IntervalWindow secondWindow = new IntervalWindow(new Instant(5L), new Instant(15L));
        IntervalWindow mergedWindow = new IntervalWindow(new Instant(1L), new Instant(15L));
        this.tester.advanceInputWatermark(new Instant(15L));
        Assert.assertTrue((boolean)this.tester.shouldFire(firstWindow));
        Assert.assertTrue((boolean)this.tester.shouldFire(secondWindow));
        this.tester.fireIfShouldFire(firstWindow);
        this.tester.fireIfShouldFire(secondWindow);
        Assert.assertFalse((boolean)this.tester.shouldFire(firstWindow));
        Assert.assertFalse((boolean)this.tester.shouldFire(secondWindow));
        this.tester.injectElements(1);
        this.tester.injectElements(5);
        Assert.assertTrue((boolean)this.tester.shouldFire(firstWindow));
        Assert.assertTrue((boolean)this.tester.shouldFire(secondWindow));
        this.tester.fireIfShouldFire(firstWindow);
        this.tester.fireIfShouldFire(secondWindow);
        this.tester.mergeWindows();
        Assert.assertFalse((boolean)this.tester.shouldFire(mergedWindow));
        this.tester.injectElements(1);
        Assert.assertTrue((boolean)this.tester.shouldFire(mergedWindow));
    }

    @Test
    public void testOnMergeRewinds() throws Exception {
        this.tester = TriggerStateMachineTester.forTrigger(AfterEachStateMachine.inOrder((TriggerStateMachine[])new TriggerStateMachine[]{AfterWatermarkStateMachine.pastEndOfWindow(), RepeatedlyStateMachine.forever((TriggerStateMachine)AfterPaneStateMachine.elementCountAtLeast((int)1))}), Sessions.withGapDuration((Duration)Duration.millis((long)10L)));
        this.tester.injectElements(1);
        this.tester.injectElements(5);
        IntervalWindow firstWindow = new IntervalWindow(new Instant(1L), new Instant(11L));
        IntervalWindow secondWindow = new IntervalWindow(new Instant(5L), new Instant(15L));
        IntervalWindow mergedWindow = new IntervalWindow(new Instant(1L), new Instant(15L));
        this.tester.advanceInputWatermark(new Instant(11L));
        Assert.assertTrue((boolean)this.tester.shouldFire(firstWindow));
        Assert.assertFalse((boolean)this.tester.shouldFire(secondWindow));
        this.tester.fireIfShouldFire(firstWindow);
        Assert.assertFalse((boolean)this.tester.shouldFire(firstWindow));
        this.tester.injectElements(1);
        Assert.assertTrue((boolean)this.tester.shouldFire(firstWindow));
        this.tester.fireIfShouldFire(firstWindow);
        this.tester.mergeWindows();
        Assert.assertFalse((boolean)this.tester.shouldFire(mergedWindow));
        this.tester.injectElements(1);
        Assert.assertFalse((boolean)this.tester.shouldFire(mergedWindow));
        this.tester.advanceInputWatermark(new Instant(15L));
        Assert.assertTrue((boolean)this.tester.shouldFire(mergedWindow));
    }

    @Test
    public void testEarlyAndLateOnMergeAlreadyFinished() throws Exception {
        this.tester = TriggerStateMachineTester.forTrigger((TriggerStateMachine)AfterWatermarkStateMachine.pastEndOfWindow().withEarlyFirings((TriggerStateMachine.OnceTriggerStateMachine)AfterPaneStateMachine.elementCountAtLeast((int)100)).withLateFirings((TriggerStateMachine.OnceTriggerStateMachine)AfterPaneStateMachine.elementCountAtLeast((int)1)), Sessions.withGapDuration((Duration)Duration.millis((long)10L)));
        this.tester.injectElements(1);
        this.tester.injectElements(5);
        IntervalWindow firstWindow = new IntervalWindow(new Instant(1L), new Instant(11L));
        IntervalWindow secondWindow = new IntervalWindow(new Instant(5L), new Instant(15L));
        IntervalWindow mergedWindow = new IntervalWindow(new Instant(1L), new Instant(15L));
        this.tester.advanceInputWatermark(new Instant(15L));
        Assert.assertTrue((boolean)this.tester.shouldFire(firstWindow));
        Assert.assertTrue((boolean)this.tester.shouldFire(secondWindow));
        this.tester.fireIfShouldFire(firstWindow);
        this.tester.fireIfShouldFire(secondWindow);
        Assert.assertFalse((boolean)this.tester.shouldFire(firstWindow));
        Assert.assertFalse((boolean)this.tester.shouldFire(secondWindow));
        this.tester.injectElements(1);
        this.tester.injectElements(5);
        Assert.assertTrue((boolean)this.tester.shouldFire(firstWindow));
        Assert.assertTrue((boolean)this.tester.shouldFire(secondWindow));
        this.tester.fireIfShouldFire(firstWindow);
        this.tester.fireIfShouldFire(secondWindow);
        this.tester.mergeWindows();
        Assert.assertFalse((boolean)this.tester.shouldFire(mergedWindow));
        this.tester.injectElements(1);
        Assert.assertTrue((boolean)this.tester.shouldFire(mergedWindow));
    }

    @Test
    public void testEarlyAndLateOnMergeRewinds() throws Exception {
        this.tester = TriggerStateMachineTester.forTrigger((TriggerStateMachine)AfterWatermarkStateMachine.pastEndOfWindow().withEarlyFirings((TriggerStateMachine.OnceTriggerStateMachine)AfterPaneStateMachine.elementCountAtLeast((int)100)).withLateFirings((TriggerStateMachine.OnceTriggerStateMachine)AfterPaneStateMachine.elementCountAtLeast((int)1)), Sessions.withGapDuration((Duration)Duration.millis((long)10L)));
        this.tester.injectElements(1);
        this.tester.injectElements(5);
        IntervalWindow firstWindow = new IntervalWindow(new Instant(1L), new Instant(11L));
        IntervalWindow secondWindow = new IntervalWindow(new Instant(5L), new Instant(15L));
        IntervalWindow mergedWindow = new IntervalWindow(new Instant(1L), new Instant(15L));
        this.tester.advanceInputWatermark(new Instant(11L));
        Assert.assertTrue((boolean)this.tester.shouldFire(firstWindow));
        Assert.assertFalse((boolean)this.tester.shouldFire(secondWindow));
        this.tester.fireIfShouldFire(firstWindow);
        Assert.assertFalse((boolean)this.tester.shouldFire(firstWindow));
        this.tester.injectElements(1);
        Assert.assertTrue((boolean)this.tester.shouldFire(firstWindow));
        this.tester.fireIfShouldFire(firstWindow);
        this.tester.mergeWindows();
        Assert.assertFalse((boolean)this.tester.shouldFire(mergedWindow));
        this.tester.injectElements(1);
        Assert.assertFalse((boolean)this.tester.shouldFire(mergedWindow));
        this.tester.advanceInputWatermark(new Instant(15L));
        Assert.assertTrue((boolean)this.tester.shouldFire(mergedWindow));
    }

    @Test
    public void testFromEndOfWindowToString() {
        AfterWatermarkStateMachine.FromEndOfWindow trigger = AfterWatermarkStateMachine.pastEndOfWindow();
        Assert.assertEquals((Object)"AfterWatermark.pastEndOfWindow()", (Object)trigger.toString());
    }

    @Test
    public void testEarlyFiringsToString() {
        AfterWatermarkStateMachine.AfterWatermarkEarlyAndLate trigger = AfterWatermarkStateMachine.pastEndOfWindow().withEarlyFirings((TriggerStateMachine.OnceTriggerStateMachine)StubTriggerStateMachine.named("t1"));
        Assert.assertEquals((Object)"AfterWatermark.pastEndOfWindow().withEarlyFirings(t1)", (Object)trigger.toString());
    }

    @Test
    public void testLateFiringsToString() {
        AfterWatermarkStateMachine.AfterWatermarkEarlyAndLate trigger = AfterWatermarkStateMachine.pastEndOfWindow().withLateFirings((TriggerStateMachine.OnceTriggerStateMachine)StubTriggerStateMachine.named("t1"));
        Assert.assertEquals((Object)"AfterWatermark.pastEndOfWindow().withLateFirings(t1)", (Object)trigger.toString());
    }

    @Test
    public void testEarlyAndLateFiringsToString() {
        AfterWatermarkStateMachine.AfterWatermarkEarlyAndLate trigger = AfterWatermarkStateMachine.pastEndOfWindow().withEarlyFirings((TriggerStateMachine.OnceTriggerStateMachine)StubTriggerStateMachine.named("t1")).withLateFirings((TriggerStateMachine.OnceTriggerStateMachine)StubTriggerStateMachine.named("t2"));
        Assert.assertEquals((Object)"AfterWatermark.pastEndOfWindow().withEarlyFirings(t1).withLateFirings(t2)", (Object)trigger.toString());
    }

    @Test
    public void testToStringExcludesNeverTrigger() {
        AfterWatermarkStateMachine.AfterWatermarkEarlyAndLate trigger = AfterWatermarkStateMachine.pastEndOfWindow().withEarlyFirings((TriggerStateMachine.OnceTriggerStateMachine)NeverStateMachine.ever()).withLateFirings((TriggerStateMachine.OnceTriggerStateMachine)NeverStateMachine.ever());
        Assert.assertEquals((Object)"AfterWatermark.pastEndOfWindow()", (Object)trigger.toString());
    }
}

