/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.triggers;

import org.apache.beam.runners.core.triggers.AfterProcessingTimeStateMachine;
import org.apache.beam.runners.core.triggers.AfterSynchronizedProcessingTimeStateMachine;
import org.apache.beam.runners.core.triggers.TriggerStateMachine;
import org.apache.beam.runners.core.triggers.TriggerStateMachineTester;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.Sessions;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class AfterSynchronizedProcessingTimeStateMachineTest {
    private TriggerStateMachine underTest = new AfterSynchronizedProcessingTimeStateMachine();

    @Test
    public void testAfterProcessingTimeWithFixedWindows() throws Exception {
        Duration windowDuration = Duration.millis((long)10L);
        TriggerStateMachineTester.SimpleTriggerStateMachineTester<IntervalWindow> tester = TriggerStateMachineTester.forTrigger((TriggerStateMachine)AfterProcessingTimeStateMachine.pastFirstElementInPane().plusDelayOf(Duration.millis((long)5L)), FixedWindows.of((Duration)windowDuration));
        tester.advanceProcessingTime(new Instant(10L));
        tester.injectElements(1);
        IntervalWindow firstWindow = new IntervalWindow(new Instant(0L), new Instant(10L));
        tester.advanceProcessingTime(new Instant(12L));
        Assert.assertFalse((boolean)tester.shouldFire(firstWindow));
        tester.injectElements(11, 12, 13);
        IntervalWindow secondWindow = new IntervalWindow(new Instant(10L), new Instant(20L));
        Assert.assertFalse((boolean)tester.shouldFire(secondWindow));
        tester.advanceProcessingTime(new Instant(14L));
        Assert.assertFalse((boolean)tester.shouldFire(firstWindow));
        Assert.assertFalse((boolean)tester.shouldFire(secondWindow));
        tester.injectElements(2, 3);
        tester.advanceProcessingTime(new Instant(16L));
        Assert.assertTrue((boolean)tester.shouldFire(firstWindow));
        Assert.assertFalse((boolean)tester.shouldFire(secondWindow));
        tester.fireIfShouldFire(firstWindow);
        Assert.assertTrue((boolean)tester.isMarkedFinished(firstWindow));
        tester.advanceProcessingTime(new Instant(18L));
        Assert.assertTrue((boolean)tester.shouldFire(secondWindow));
        tester.fireIfShouldFire(secondWindow);
        Assert.assertTrue((boolean)tester.isMarkedFinished(secondWindow));
    }

    @Test
    public void testAfterProcessingTimeWithMergingWindow() throws Exception {
        Duration windowDuration = Duration.millis((long)10L);
        TriggerStateMachineTester.SimpleTriggerStateMachineTester<IntervalWindow> tester = TriggerStateMachineTester.forTrigger((TriggerStateMachine)AfterProcessingTimeStateMachine.pastFirstElementInPane().plusDelayOf(Duration.millis((long)5L)), Sessions.withGapDuration((Duration)windowDuration));
        tester.advanceProcessingTime(new Instant(10L));
        tester.injectElements(1);
        IntervalWindow firstWindow = new IntervalWindow(new Instant(1L), new Instant(11L));
        Assert.assertFalse((boolean)tester.shouldFire(firstWindow));
        tester.advanceProcessingTime(new Instant(12L));
        tester.injectElements(3);
        IntervalWindow secondWindow = new IntervalWindow(new Instant(3L), new Instant(13L));
        Assert.assertFalse((boolean)tester.shouldFire(secondWindow));
        tester.mergeWindows();
        IntervalWindow mergedWindow = new IntervalWindow(new Instant(1L), new Instant(13L));
        tester.advanceProcessingTime(new Instant(16L));
        Assert.assertTrue((boolean)tester.shouldFire(mergedWindow));
    }
}

