/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.triggers;

import org.apache.beam.runners.core.triggers.AfterDelayFromFirstElementStateMachine;
import org.apache.beam.runners.core.triggers.AfterProcessingTimeStateMachine;
import org.apache.beam.runners.core.triggers.AfterWatermarkStateMachine;
import org.apache.beam.runners.core.triggers.TriggerStateMachine;
import org.apache.beam.runners.core.triggers.TriggerStateMachineTester;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.Sessions;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class AfterProcessingTimeStateMachineTest {
    @Test
    public void testAfterProcessingTimeFixedWindows() throws Exception {
        Duration windowDuration = Duration.millis((long)10L);
        TriggerStateMachineTester.SimpleTriggerStateMachineTester<IntervalWindow> tester = TriggerStateMachineTester.forTrigger((TriggerStateMachine)AfterProcessingTimeStateMachine.pastFirstElementInPane().plusDelayOf(Duration.millis((long)5L)), FixedWindows.of((Duration)windowDuration));
        tester.advanceProcessingTime(new Instant(10L));
        tester.injectElements(1);
        IntervalWindow firstWindow = new IntervalWindow(new Instant(0L), new Instant(10L));
        tester.advanceProcessingTime(new Instant(12L));
        Assert.assertFalse((boolean)tester.shouldFire(firstWindow));
        tester.injectElements(11, 12, 13);
        IntervalWindow secondWindow = new IntervalWindow(new Instant(10L), new Instant(20L));
        Assert.assertFalse((boolean)tester.shouldFire(secondWindow));
        tester.advanceProcessingTime(new Instant(14L));
        Assert.assertFalse((boolean)tester.shouldFire(firstWindow));
        Assert.assertFalse((boolean)tester.shouldFire(secondWindow));
        tester.injectElements(2, 3);
        tester.advanceProcessingTime(new Instant(16L));
        Assert.assertTrue((boolean)tester.shouldFire(firstWindow));
        Assert.assertFalse((boolean)tester.shouldFire(secondWindow));
        tester.fireIfShouldFire(firstWindow);
        Assert.assertTrue((boolean)tester.isMarkedFinished(firstWindow));
        tester.advanceProcessingTime(new Instant(18L));
        Assert.assertTrue((boolean)tester.shouldFire(secondWindow));
        tester.fireIfShouldFire(secondWindow);
        Assert.assertTrue((boolean)tester.isMarkedFinished(secondWindow));
    }

    @Test
    public void testClear() throws Exception {
        TriggerStateMachineTester.SimpleTriggerStateMachineTester<IntervalWindow> tester = TriggerStateMachineTester.forTrigger((TriggerStateMachine)AfterProcessingTimeStateMachine.pastFirstElementInPane().plusDelayOf(Duration.millis((long)5L)), FixedWindows.of((Duration)Duration.millis((long)10L)));
        tester.injectElements(1, 2, 3);
        IntervalWindow window = new IntervalWindow(new Instant(0L), new Instant(10L));
        tester.clearState(window);
        tester.assertCleared(window);
    }

    @Test
    public void testAfterProcessingTimeWithMergingWindow() throws Exception {
        TriggerStateMachineTester.SimpleTriggerStateMachineTester<IntervalWindow> tester = TriggerStateMachineTester.forTrigger((TriggerStateMachine)AfterProcessingTimeStateMachine.pastFirstElementInPane().plusDelayOf(Duration.millis((long)5L)), Sessions.withGapDuration((Duration)Duration.millis((long)10L)));
        tester.advanceProcessingTime(new Instant(10L));
        tester.injectElements(1);
        IntervalWindow firstWindow = new IntervalWindow(new Instant(1L), new Instant(11L));
        Assert.assertFalse((boolean)tester.shouldFire(firstWindow));
        tester.advanceProcessingTime(new Instant(12L));
        tester.injectElements(3);
        IntervalWindow secondWindow = new IntervalWindow(new Instant(3L), new Instant(13L));
        Assert.assertFalse((boolean)tester.shouldFire(secondWindow));
        tester.mergeWindows();
        IntervalWindow mergedWindow = new IntervalWindow(new Instant(1L), new Instant(13L));
        tester.advanceProcessingTime(new Instant(16L));
        Assert.assertTrue((boolean)tester.shouldFire(mergedWindow));
    }

    @Test
    public void testCompatibilityIdentical() throws Exception {
        AfterDelayFromFirstElementStateMachine t1 = AfterProcessingTimeStateMachine.pastFirstElementInPane().plusDelayOf(Duration.standardMinutes((long)1L));
        AfterDelayFromFirstElementStateMachine t2 = AfterProcessingTimeStateMachine.pastFirstElementInPane().plusDelayOf(Duration.standardMinutes((long)1L));
        Assert.assertTrue((boolean)t1.isCompatible((TriggerStateMachine)t2));
    }

    @Test
    public void testToString() {
        AfterProcessingTimeStateMachine trigger = AfterProcessingTimeStateMachine.pastFirstElementInPane();
        Assert.assertEquals((Object)"AfterProcessingTime.pastFirstElementInPane()", (Object)trigger.toString());
    }

    @Test
    public void testWithDelayToString() {
        AfterDelayFromFirstElementStateMachine trigger = AfterProcessingTimeStateMachine.pastFirstElementInPane().plusDelayOf(Duration.standardMinutes((long)5L));
        Assert.assertEquals((Object)"AfterProcessingTime.pastFirstElementInPane().plusDelayOf(5 minutes)", (Object)trigger.toString());
    }

    @Test
    public void testBuiltUpToString() {
        AfterWatermarkStateMachine.AfterWatermarkEarlyAndLate trigger = AfterWatermarkStateMachine.pastEndOfWindow().withLateFirings((TriggerStateMachine.OnceTriggerStateMachine)AfterProcessingTimeStateMachine.pastFirstElementInPane().plusDelayOf(Duration.standardMinutes((long)10L)));
        String expected = "AfterWatermark.pastEndOfWindow().withLateFirings(AfterProcessingTime.pastFirstElementInPane().plusDelayOf(10 minutes))";
        Assert.assertEquals((Object)expected, (Object)trigger.toString());
    }
}

