/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.triggers;

import org.apache.beam.runners.core.triggers.AfterPaneStateMachine;
import org.apache.beam.runners.core.triggers.TriggerStateMachine;
import org.apache.beam.runners.core.triggers.TriggerStateMachineTester;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.Sessions;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class AfterPaneStateMachineTest {
    TriggerStateMachineTester.SimpleTriggerStateMachineTester<IntervalWindow> tester;

    @Test
    public void testAfterPaneElementCountFixedWindows() throws Exception {
        this.tester = TriggerStateMachineTester.forTrigger((TriggerStateMachine)AfterPaneStateMachine.elementCountAtLeast((int)2), FixedWindows.of((Duration)Duration.millis((long)10L)));
        this.tester.injectElements(1);
        IntervalWindow window = new IntervalWindow(new Instant(0L), new Instant(10L));
        Assert.assertFalse((boolean)this.tester.shouldFire(window));
        this.tester.injectElements(2);
        this.tester.injectElements(11);
        Assert.assertTrue((boolean)this.tester.shouldFire(window));
        this.tester.fireIfShouldFire(window);
        Assert.assertTrue((boolean)this.tester.isMarkedFinished(window));
        Assert.assertFalse((boolean)this.tester.isMarkedFinished(new IntervalWindow(new Instant(10L), new Instant(20L))));
    }

    @Test
    public void testClear() throws Exception {
        TriggerStateMachineTester.SimpleTriggerStateMachineTester<IntervalWindow> tester = TriggerStateMachineTester.forTrigger((TriggerStateMachine)AfterPaneStateMachine.elementCountAtLeast((int)2), FixedWindows.of((Duration)Duration.millis((long)10L)));
        tester.injectElements(1, 2, 3);
        IntervalWindow window = new IntervalWindow(new Instant(0L), new Instant(10L));
        tester.clearState(window);
        tester.assertCleared(window);
    }

    @Test
    public void testAfterPaneElementCountSessions() throws Exception {
        this.tester = TriggerStateMachineTester.forTrigger((TriggerStateMachine)AfterPaneStateMachine.elementCountAtLeast((int)2), Sessions.withGapDuration((Duration)Duration.millis((long)10L)));
        this.tester.injectElements(1, 2);
        Assert.assertFalse((boolean)this.tester.shouldFire(new IntervalWindow(new Instant(1L), new Instant(11L))));
        Assert.assertFalse((boolean)this.tester.shouldFire(new IntervalWindow(new Instant(2L), new Instant(12L))));
        this.tester.mergeWindows();
        IntervalWindow mergedWindow = new IntervalWindow(new Instant(1L), new Instant(12L));
        Assert.assertTrue((boolean)this.tester.shouldFire(mergedWindow));
        this.tester.fireIfShouldFire(mergedWindow);
        Assert.assertTrue((boolean)this.tester.isMarkedFinished(mergedWindow));
        this.tester.injectElements(7, 9);
        this.tester.mergeWindows();
        IntervalWindow newMergedWindow = new IntervalWindow(new Instant(7L), new Instant(19L));
        Assert.assertTrue((boolean)this.tester.shouldFire(newMergedWindow));
        this.tester.fireIfShouldFire(newMergedWindow);
        Assert.assertTrue((boolean)this.tester.isMarkedFinished(newMergedWindow));
    }

    @Test
    public void testToString() {
        AfterPaneStateMachine trigger = AfterPaneStateMachine.elementCountAtLeast((int)5);
        Assert.assertEquals((Object)"AfterPane.elementCountAtLeast(5)", (Object)trigger.toString());
    }
}

