/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.triggers;

import org.apache.beam.runners.core.triggers.AfterEachStateMachine;
import org.apache.beam.runners.core.triggers.AfterFirstStateMachine;
import org.apache.beam.runners.core.triggers.AfterPaneStateMachine;
import org.apache.beam.runners.core.triggers.AfterWatermarkStateMachine;
import org.apache.beam.runners.core.triggers.RepeatedlyStateMachine;
import org.apache.beam.runners.core.triggers.TriggerStateMachine;
import org.apache.beam.runners.core.triggers.TriggerStateMachineTester;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.Sessions;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class AfterFirstStateMachineTest {
    @Mock
    private TriggerStateMachine.OnceTriggerStateMachine mockTrigger1;
    @Mock
    private TriggerStateMachine.OnceTriggerStateMachine mockTrigger2;
    private TriggerStateMachineTester.SimpleTriggerStateMachineTester<IntervalWindow> tester;

    private static TriggerStateMachine.TriggerContext anyTriggerContext() {
        return (TriggerStateMachine.TriggerContext)Mockito.any();
    }

    @Before
    public void initMocks() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testNeitherShouldFireFixedWindows() throws Exception {
        this.tester = TriggerStateMachineTester.forTrigger((TriggerStateMachine)AfterFirstStateMachine.of((TriggerStateMachine.OnceTriggerStateMachine[])new TriggerStateMachine.OnceTriggerStateMachine[]{this.mockTrigger1, this.mockTrigger2}), FixedWindows.of((Duration)Duration.millis((long)10L)));
        this.tester.injectElements(1);
        IntervalWindow window = new IntervalWindow(new Instant(0L), new Instant(10L));
        Mockito.when((Object)this.mockTrigger1.shouldFire(AfterFirstStateMachineTest.anyTriggerContext())).thenReturn((Object)false);
        Mockito.when((Object)this.mockTrigger2.shouldFire(AfterFirstStateMachineTest.anyTriggerContext())).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.tester.shouldFire(window));
        Assert.assertFalse((boolean)this.tester.isMarkedFinished(window));
    }

    @Test
    public void testOnlyT1ShouldFireFixedWindows() throws Exception {
        this.tester = TriggerStateMachineTester.forTrigger((TriggerStateMachine)AfterFirstStateMachine.of((TriggerStateMachine.OnceTriggerStateMachine[])new TriggerStateMachine.OnceTriggerStateMachine[]{this.mockTrigger1, this.mockTrigger2}), FixedWindows.of((Duration)Duration.millis((long)10L)));
        this.tester.injectElements(1);
        IntervalWindow window = new IntervalWindow(new Instant(1L), new Instant(11L));
        Mockito.when((Object)this.mockTrigger1.shouldFire(AfterFirstStateMachineTest.anyTriggerContext())).thenReturn((Object)true);
        Mockito.when((Object)this.mockTrigger2.shouldFire(AfterFirstStateMachineTest.anyTriggerContext())).thenReturn((Object)false);
        Assert.assertTrue((boolean)this.tester.shouldFire(window));
        this.tester.fireIfShouldFire(window);
        Assert.assertTrue((boolean)this.tester.isMarkedFinished(window));
    }

    @Test
    public void testOnlyT2ShouldFireFixedWindows() throws Exception {
        this.tester = TriggerStateMachineTester.forTrigger((TriggerStateMachine)AfterFirstStateMachine.of((TriggerStateMachine.OnceTriggerStateMachine[])new TriggerStateMachine.OnceTriggerStateMachine[]{this.mockTrigger1, this.mockTrigger2}), FixedWindows.of((Duration)Duration.millis((long)10L)));
        this.tester.injectElements(1);
        IntervalWindow window = new IntervalWindow(new Instant(1L), new Instant(11L));
        Mockito.when((Object)this.mockTrigger1.shouldFire(AfterFirstStateMachineTest.anyTriggerContext())).thenReturn((Object)false);
        Mockito.when((Object)this.mockTrigger2.shouldFire(AfterFirstStateMachineTest.anyTriggerContext())).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.tester.shouldFire(window));
        this.tester.fireIfShouldFire(window);
        Assert.assertTrue((boolean)this.tester.isMarkedFinished(window));
    }

    @Test
    public void testBothShouldFireFixedWindows() throws Exception {
        this.tester = TriggerStateMachineTester.forTrigger((TriggerStateMachine)AfterFirstStateMachine.of((TriggerStateMachine.OnceTriggerStateMachine[])new TriggerStateMachine.OnceTriggerStateMachine[]{this.mockTrigger1, this.mockTrigger2}), FixedWindows.of((Duration)Duration.millis((long)10L)));
        this.tester.injectElements(1);
        IntervalWindow window = new IntervalWindow(new Instant(1L), new Instant(11L));
        Mockito.when((Object)this.mockTrigger1.shouldFire(AfterFirstStateMachineTest.anyTriggerContext())).thenReturn((Object)true);
        Mockito.when((Object)this.mockTrigger2.shouldFire(AfterFirstStateMachineTest.anyTriggerContext())).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.tester.shouldFire(window));
        this.tester.fireIfShouldFire(window);
        Assert.assertTrue((boolean)this.tester.isMarkedFinished(window));
    }

    @Test
    public void testShouldFireAfterMerge() throws Exception {
        this.tester = TriggerStateMachineTester.forTrigger(AfterEachStateMachine.inOrder((TriggerStateMachine[])new TriggerStateMachine[]{AfterFirstStateMachine.of((TriggerStateMachine.OnceTriggerStateMachine[])new TriggerStateMachine.OnceTriggerStateMachine[]{AfterPaneStateMachine.elementCountAtLeast((int)5), AfterWatermarkStateMachine.pastEndOfWindow()}), RepeatedlyStateMachine.forever((TriggerStateMachine)AfterPaneStateMachine.elementCountAtLeast((int)1))}), Sessions.withGapDuration((Duration)Duration.millis((long)10L)));
        this.tester.injectElements(1);
        IntervalWindow firstWindow = new IntervalWindow(new Instant(1L), new Instant(11L));
        Assert.assertFalse((boolean)this.tester.shouldFire(firstWindow));
        this.tester.advanceInputWatermark(new Instant(11L));
        Assert.assertTrue((boolean)this.tester.shouldFire(firstWindow));
        this.tester.fireIfShouldFire(firstWindow);
        this.tester.injectElements(5);
        IntervalWindow secondWindow = new IntervalWindow(new Instant(5L), new Instant(15L));
        Assert.assertFalse((boolean)this.tester.shouldFire(secondWindow));
        this.tester.mergeWindows();
        IntervalWindow mergedWindow = new IntervalWindow(new Instant(1L), new Instant(15L));
        Assert.assertFalse((boolean)this.tester.shouldFire(mergedWindow));
        this.tester.injectElements(1, 2, 3, 4, 5);
        this.tester.mergeWindows();
        Assert.assertTrue((boolean)this.tester.shouldFire(mergedWindow));
    }
}

