/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.triggers;

import org.apache.beam.runners.core.triggers.AfterEachStateMachine;
import org.apache.beam.runners.core.triggers.AfterPaneStateMachine;
import org.apache.beam.runners.core.triggers.AfterWatermarkStateMachine;
import org.apache.beam.runners.core.triggers.RepeatedlyStateMachine;
import org.apache.beam.runners.core.triggers.StubTriggerStateMachine;
import org.apache.beam.runners.core.triggers.TriggerStateMachine;
import org.apache.beam.runners.core.triggers.TriggerStateMachineTester;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class AfterEachStateMachineTest {
    private TriggerStateMachineTester.SimpleTriggerStateMachineTester<IntervalWindow> tester;

    @Before
    public void initMocks() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testAfterEachInSequence() throws Exception {
        this.tester = TriggerStateMachineTester.forTrigger(AfterEachStateMachine.inOrder((TriggerStateMachine[])new TriggerStateMachine[]{RepeatedlyStateMachine.forever((TriggerStateMachine)AfterPaneStateMachine.elementCountAtLeast((int)2)).orFinally((TriggerStateMachine.OnceTriggerStateMachine)AfterPaneStateMachine.elementCountAtLeast((int)3)), RepeatedlyStateMachine.forever((TriggerStateMachine)AfterPaneStateMachine.elementCountAtLeast((int)5)).orFinally((TriggerStateMachine.OnceTriggerStateMachine)AfterWatermarkStateMachine.pastEndOfWindow())}), FixedWindows.of((Duration)Duration.millis((long)10L)));
        IntervalWindow window = new IntervalWindow(new Instant(0L), new Instant(10L));
        this.tester.injectElements(1);
        Assert.assertFalse((boolean)this.tester.shouldFire(window));
        this.tester.injectElements(2);
        Assert.assertTrue((boolean)this.tester.shouldFire(window));
        this.tester.fireIfShouldFire(window);
        Assert.assertFalse((boolean)this.tester.isMarkedFinished(window));
        this.tester.injectElements(1, 2, 3);
        Assert.assertTrue((boolean)this.tester.shouldFire(window));
        this.tester.fireIfShouldFire(window);
        Assert.assertFalse((boolean)this.tester.isMarkedFinished(window));
        Assert.assertFalse((boolean)this.tester.shouldFire(window));
        this.tester.injectElements(1, 2, 3, 4);
        Assert.assertFalse((boolean)this.tester.shouldFire(window));
        this.tester.injectElements(5);
        Assert.assertTrue((boolean)this.tester.shouldFire(window));
        this.tester.fireIfShouldFire(window);
        Assert.assertFalse((boolean)this.tester.isMarkedFinished(window));
        this.tester.advanceInputWatermark(new Instant(10L));
        Assert.assertTrue((boolean)this.tester.shouldFire(window));
        this.tester.fireIfShouldFire(window);
        Assert.assertTrue((boolean)this.tester.isMarkedFinished(window));
    }

    @Test
    public void testToString() {
        TriggerStateMachine trigger = AfterEachStateMachine.inOrder((TriggerStateMachine[])new TriggerStateMachine[]{StubTriggerStateMachine.named("t1"), StubTriggerStateMachine.named("t2"), StubTriggerStateMachine.named("t3")});
        Assert.assertEquals((Object)"AfterEach.inOrder(t1, t2, t3)", (Object)trigger.toString());
    }
}

