/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.triggers;

import org.apache.beam.runners.core.triggers.AfterAllStateMachine;
import org.apache.beam.runners.core.triggers.AfterEachStateMachine;
import org.apache.beam.runners.core.triggers.AfterPaneStateMachine;
import org.apache.beam.runners.core.triggers.AfterWatermarkStateMachine;
import org.apache.beam.runners.core.triggers.RepeatedlyStateMachine;
import org.apache.beam.runners.core.triggers.StubTriggerStateMachine;
import org.apache.beam.runners.core.triggers.TriggerStateMachine;
import org.apache.beam.runners.core.triggers.TriggerStateMachineTester;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.Sessions;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class AfterAllStateMachineTest {
    private TriggerStateMachineTester.SimpleTriggerStateMachineTester<IntervalWindow> tester;

    @Test
    public void testT1FiresFirst() throws Exception {
        this.tester = TriggerStateMachineTester.forTrigger((TriggerStateMachine)AfterAllStateMachine.of((TriggerStateMachine.OnceTriggerStateMachine[])new TriggerStateMachine.OnceTriggerStateMachine[]{AfterPaneStateMachine.elementCountAtLeast((int)1), AfterPaneStateMachine.elementCountAtLeast((int)2)}), FixedWindows.of((Duration)Duration.millis((long)100L)));
        IntervalWindow window = new IntervalWindow(new Instant(0L), new Instant(100L));
        this.tester.injectElements(1);
        Assert.assertFalse((boolean)this.tester.shouldFire(window));
        this.tester.injectElements(2);
        Assert.assertTrue((boolean)this.tester.shouldFire(window));
        this.tester.fireIfShouldFire(window);
        Assert.assertTrue((boolean)this.tester.isMarkedFinished(window));
    }

    @Test
    public void testT2FiresFirst() throws Exception {
        this.tester = TriggerStateMachineTester.forTrigger((TriggerStateMachine)AfterAllStateMachine.of((TriggerStateMachine.OnceTriggerStateMachine[])new TriggerStateMachine.OnceTriggerStateMachine[]{AfterPaneStateMachine.elementCountAtLeast((int)2), AfterPaneStateMachine.elementCountAtLeast((int)1)}), FixedWindows.of((Duration)Duration.millis((long)100L)));
        IntervalWindow window = new IntervalWindow(new Instant(0L), new Instant(100L));
        this.tester.injectElements(1);
        Assert.assertFalse((boolean)this.tester.shouldFire(window));
        this.tester.injectElements(2);
        Assert.assertTrue((boolean)this.tester.shouldFire(window));
        this.tester.fireIfShouldFire(window);
        Assert.assertTrue((boolean)this.tester.isMarkedFinished(window));
    }

    @Test
    public void testOnMergeRewinds() throws Exception {
        this.tester = TriggerStateMachineTester.forTrigger(AfterEachStateMachine.inOrder((TriggerStateMachine[])new TriggerStateMachine[]{AfterAllStateMachine.of((TriggerStateMachine.OnceTriggerStateMachine[])new TriggerStateMachine.OnceTriggerStateMachine[]{AfterWatermarkStateMachine.pastEndOfWindow(), AfterPaneStateMachine.elementCountAtLeast((int)1)}), RepeatedlyStateMachine.forever((TriggerStateMachine)AfterPaneStateMachine.elementCountAtLeast((int)1))}), Sessions.withGapDuration((Duration)Duration.millis((long)10L)));
        this.tester.injectElements(1);
        IntervalWindow firstWindow = new IntervalWindow(new Instant(1L), new Instant(11L));
        this.tester.injectElements(5);
        IntervalWindow secondWindow = new IntervalWindow(new Instant(5L), new Instant(15L));
        this.tester.advanceInputWatermark(new Instant(11L));
        Assert.assertTrue((boolean)this.tester.shouldFire(firstWindow));
        Assert.assertFalse((boolean)this.tester.shouldFire(secondWindow));
        this.tester.fireIfShouldFire(firstWindow);
        this.tester.mergeWindows();
        IntervalWindow mergedWindow = new IntervalWindow(new Instant(1L), new Instant(15L));
        Assert.assertFalse((boolean)this.tester.isMarkedFinished(mergedWindow));
        this.tester.injectElements(3);
        this.tester.mergeWindows();
        Assert.assertFalse((boolean)this.tester.shouldFire(mergedWindow));
        this.tester.advanceInputWatermark(new Instant(15L));
        Assert.assertTrue((boolean)this.tester.shouldFire(mergedWindow));
        this.tester.fireIfShouldFire(mergedWindow);
        this.tester.injectElements(2);
        this.tester.mergeWindows();
        Assert.assertTrue((boolean)this.tester.shouldFire(mergedWindow));
        this.tester.fireIfShouldFire(mergedWindow);
        this.tester.injectElements(2);
        this.tester.mergeWindows();
        Assert.assertTrue((boolean)this.tester.shouldFire(mergedWindow));
        this.tester.fireIfShouldFire(mergedWindow);
    }

    @Test
    public void testToString() {
        TriggerStateMachine.OnceTriggerStateMachine trigger = AfterAllStateMachine.of((TriggerStateMachine.OnceTriggerStateMachine[])new TriggerStateMachine.OnceTriggerStateMachine[]{StubTriggerStateMachine.named("t1"), StubTriggerStateMachine.named("t2")});
        Assert.assertEquals((Object)"AfterAll.of(t1, t2)", (Object)trigger.toString());
    }
}

