/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core;

import java.util.Arrays;
import java.util.List;
import org.apache.beam.runners.core.DoFnRunner;
import org.apache.beam.runners.core.SimpleOldDoFnRunner;
import org.apache.beam.sdk.transforms.OldDoFn;
import org.apache.beam.sdk.util.BaseExecutionContext;
import org.apache.beam.sdk.util.ExecutionContext;
import org.apache.beam.sdk.util.SystemDoFnInternal;
import org.apache.beam.sdk.util.UserCodeException;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.TupleTag;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class SimpleOldDoFnRunnerTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testExceptionsWrappedAsUserCodeException() {
        ThrowingDoFn fn = new ThrowingDoFn();
        DoFnRunner<String, String> runner = this.createRunner(fn);
        this.thrown.expect(UserCodeException.class);
        this.thrown.expectCause(Matchers.is((Object)fn.exceptionToThrow));
        runner.processElement(WindowedValue.valueInGlobalWindow((Object)"anyValue"));
    }

    @Test
    public void testSystemDoFnInternalExceptionsNotWrapped() {
        ThrowingSystemDoFn fn = new ThrowingSystemDoFn();
        DoFnRunner<String, String> runner = this.createRunner(fn);
        this.thrown.expect(Matchers.is((Object)fn.exceptionToThrow));
        runner.processElement(WindowedValue.valueInGlobalWindow((Object)"anyValue"));
    }

    private DoFnRunner<String, String> createRunner(OldDoFn<String, String> fn) {
        List<TupleTag> sideOutputTags = Arrays.asList(new TupleTag[0]);
        BaseExecutionContext.StepContext context = (BaseExecutionContext.StepContext)Mockito.mock(BaseExecutionContext.StepContext.class);
        return new SimpleOldDoFnRunner(null, fn, null, null, null, sideOutputTags, (ExecutionContext.StepContext)context, null, null);
    }

    @SystemDoFnInternal
    static class ThrowingSystemDoFn
    extends ThrowingDoFn {
        ThrowingSystemDoFn() {
        }
    }

    static class ThrowingDoFn
    extends OldDoFn<String, String> {
        final Exception exceptionToThrow = new UnsupportedOperationException("Expected exception");

        ThrowingDoFn() {
        }

        public void processElement(OldDoFn.ProcessContext c) throws Exception {
            throw this.exceptionToThrow;
        }
    }
}

