/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core;

import java.util.Collection;
import org.apache.beam.runners.core.SideInputHandler;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.repackaged.com.google.common.collect.ImmutableList;
import org.apache.beam.sdk.testing.PCollectionViewTesting;
import org.apache.beam.sdk.transforms.ViewFn;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.util.WindowingStrategy;
import org.apache.beam.sdk.util.state.InMemoryStateInternals;
import org.apache.beam.sdk.util.state.StateInternals;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SideInputHandlerTest {
    private static final long WINDOW_MSECS_1 = 100L;
    private static final long WINDOW_MSECS_2 = 500L;
    private WindowingStrategy<Object, IntervalWindow> windowingStrategy1 = WindowingStrategy.of((WindowFn)FixedWindows.of((Duration)new Duration(100L)));
    private PCollectionView<Iterable<String>> view1 = PCollectionViewTesting.testingView((TupleTag)new TupleTag<Iterable<WindowedValue<String>>>(){}, (ViewFn)new PCollectionViewTesting.IdentityViewFn(), (Coder)StringUtf8Coder.of(), this.windowingStrategy1);
    private WindowingStrategy<Object, IntervalWindow> windowingStrategy2 = WindowingStrategy.of((WindowFn)FixedWindows.of((Duration)new Duration(500L)));
    private PCollectionView<Iterable<String>> view2 = PCollectionViewTesting.testingView((TupleTag)new TupleTag<Iterable<WindowedValue<String>>>(){}, (ViewFn)new PCollectionViewTesting.IdentityViewFn(), (Coder)StringUtf8Coder.of(), this.windowingStrategy2);

    @Test
    public void testIsEmpty() {
        SideInputHandler sideInputHandler = new SideInputHandler((Collection)ImmutableList.of(this.view1), (StateInternals)InMemoryStateInternals.forKey(null));
        Assert.assertFalse((boolean)sideInputHandler.isEmpty());
        SideInputHandler emptySideInputHandler = new SideInputHandler((Collection)ImmutableList.of(), (StateInternals)InMemoryStateInternals.forKey(null));
        Assert.assertTrue((boolean)emptySideInputHandler.isEmpty());
    }

    @Test
    public void testContains() {
        SideInputHandler sideInputHandler = new SideInputHandler((Collection)ImmutableList.of(this.view1), (StateInternals)InMemoryStateInternals.forKey(null));
        Assert.assertTrue((boolean)sideInputHandler.contains(this.view1));
        Assert.assertFalse((boolean)sideInputHandler.contains(this.view2));
    }

    @Test
    public void testIsReady() {
        SideInputHandler sideInputHandler = new SideInputHandler((Collection)ImmutableList.of(this.view1, this.view2), (StateInternals)InMemoryStateInternals.forKey(null));
        IntervalWindow firstWindow = new IntervalWindow(new Instant(0L), new Instant(100L));
        IntervalWindow secondWindow = new IntervalWindow(new Instant(0L), new Instant(500L));
        Assert.assertFalse((boolean)sideInputHandler.isReady(this.view1, (BoundedWindow)firstWindow));
        sideInputHandler.addSideInputValue(this.view1, this.valuesInWindow((Iterable<?>)ImmutableList.of((Object)"Hello"), new Instant(0L), (BoundedWindow)firstWindow));
        Assert.assertTrue((boolean)sideInputHandler.isReady(this.view1, (BoundedWindow)firstWindow));
        Assert.assertFalse((boolean)sideInputHandler.isReady(this.view1, (BoundedWindow)secondWindow));
    }

    @Test
    public void testNewInputReplacesPreviousInput() {
        SideInputHandler sideInputHandler = new SideInputHandler((Collection)ImmutableList.of(this.view1), (StateInternals)InMemoryStateInternals.forKey(null));
        IntervalWindow window = new IntervalWindow(new Instant(0L), new Instant(100L));
        sideInputHandler.addSideInputValue(this.view1, this.valuesInWindow((Iterable<?>)ImmutableList.of((Object)"Hello"), new Instant(0L), (BoundedWindow)window));
        Assert.assertThat((Object)sideInputHandler.get(this.view1, (BoundedWindow)window), (Matcher)Matchers.contains((Object[])new String[]{"Hello"}));
        sideInputHandler.addSideInputValue(this.view1, this.valuesInWindow((Iterable<?>)ImmutableList.of((Object)"Ciao", (Object)"Buongiorno"), new Instant(0L), (BoundedWindow)window));
        Assert.assertThat((Object)sideInputHandler.get(this.view1, (BoundedWindow)window), (Matcher)Matchers.contains((Object[])new String[]{"Ciao", "Buongiorno"}));
    }

    @Test
    public void testMultipleWindows() {
        SideInputHandler sideInputHandler = new SideInputHandler((Collection)ImmutableList.of(this.view1), (StateInternals)InMemoryStateInternals.forKey(null));
        IntervalWindow firstWindow = new IntervalWindow(new Instant(0L), new Instant(100L));
        IntervalWindow secondWindow = new IntervalWindow(new Instant(1000L), new Instant(1500L));
        sideInputHandler.addSideInputValue(this.view1, this.valuesInWindow((Iterable<?>)ImmutableList.of((Object)"Hello"), new Instant(0L), (BoundedWindow)firstWindow));
        Assert.assertThat((Object)sideInputHandler.get(this.view1, (BoundedWindow)firstWindow), (Matcher)Matchers.contains((Object[])new String[]{"Hello"}));
        sideInputHandler.addSideInputValue(this.view1, this.valuesInWindow((Iterable<?>)ImmutableList.of((Object)"Arrivederci"), new Instant(0L), (BoundedWindow)secondWindow));
        Assert.assertThat((Object)sideInputHandler.get(this.view1, (BoundedWindow)secondWindow), (Matcher)Matchers.contains((Object[])new String[]{"Arrivederci"}));
        Assert.assertThat((Object)sideInputHandler.get(this.view1, (BoundedWindow)firstWindow), (Matcher)Matchers.contains((Object[])new String[]{"Hello"}));
    }

    @Test
    public void testMultipleSideInputs() {
        SideInputHandler sideInputHandler = new SideInputHandler((Collection)ImmutableList.of(this.view1, this.view2), (StateInternals)InMemoryStateInternals.forKey(null));
        IntervalWindow firstWindow = new IntervalWindow(new Instant(0L), new Instant(100L));
        sideInputHandler.addSideInputValue(this.view1, this.valuesInWindow((Iterable<?>)ImmutableList.of((Object)"Hello"), new Instant(0L), (BoundedWindow)firstWindow));
        Assert.assertThat((Object)sideInputHandler.get(this.view1, (BoundedWindow)firstWindow), (Matcher)Matchers.contains((Object[])new String[]{"Hello"}));
        Assert.assertFalse((boolean)sideInputHandler.isReady(this.view2, (BoundedWindow)firstWindow));
        sideInputHandler.addSideInputValue(this.view2, this.valuesInWindow((Iterable<?>)ImmutableList.of((Object)"Salut"), new Instant(0L), (BoundedWindow)firstWindow));
        Assert.assertTrue((boolean)sideInputHandler.isReady(this.view2, (BoundedWindow)firstWindow));
        Assert.assertThat((Object)sideInputHandler.get(this.view2, (BoundedWindow)firstWindow), (Matcher)Matchers.contains((Object[])new String[]{"Salut"}));
        Assert.assertThat((Object)sideInputHandler.get(this.view1, (BoundedWindow)firstWindow), (Matcher)Matchers.contains((Object[])new String[]{"Hello"}));
    }

    private WindowedValue<Iterable<?>> valuesInWindow(Iterable<?> values, Instant timestamp, BoundedWindow window) {
        return WindowedValue.of(values, (Instant)timestamp, (BoundedWindow)window, (PaneInfo)PaneInfo.NO_FIRING);
    }
}

