/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.beam.runners.core.DoFnRunner;
import org.apache.beam.runners.core.PushbackSideInputDoFnRunner;
import org.apache.beam.sdk.repackaged.com.google.common.collect.ImmutableList;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.Sum;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.IdentitySideInputWindowFn;
import org.apache.beam.sdk.util.ReadyCheckingSideInputReader;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.AdditionalMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class PushbackSideInputDoFnRunnerTest {
    @Mock
    private ReadyCheckingSideInputReader reader;
    private TestDoFnRunner<Integer, Integer> underlying;
    private PCollectionView<Integer> singletonView;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        TestPipeline p = TestPipeline.create();
        PCollection created = (PCollection)p.apply((PTransform)Create.of((Object[])new Integer[]{1, 2, 3}));
        this.singletonView = (PCollectionView)((PCollection)created.apply((PTransform)Window.into((WindowFn)new IdentitySideInputWindowFn()))).apply((PTransform)Sum.integersGlobally().asSingletonView());
        this.underlying = new TestDoFnRunner();
    }

    private PushbackSideInputDoFnRunner<Integer, Integer> createRunner(ImmutableList<PCollectionView<?>> views) {
        PushbackSideInputDoFnRunner runner = PushbackSideInputDoFnRunner.create(this.underlying, views, (ReadyCheckingSideInputReader)this.reader);
        runner.startBundle();
        return runner;
    }

    @Test
    public void startFinishBundleDelegates() {
        PushbackSideInputDoFnRunner<Integer, Integer> runner = this.createRunner(ImmutableList.of(this.singletonView));
        Assert.assertThat((Object)((TestDoFnRunner)this.underlying).started, (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((TestDoFnRunner)this.underlying).finished, (Matcher)Matchers.is((Object)false));
        runner.finishBundle();
        Assert.assertThat((Object)((TestDoFnRunner)this.underlying).finished, (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void processElementSideInputNotReady() {
        Mockito.when((Object)this.reader.isReady((PCollectionView)Mockito.eq(this.singletonView), (BoundedWindow)Mockito.any(BoundedWindow.class))).thenReturn((Object)false);
        PushbackSideInputDoFnRunner<Integer, Integer> runner = this.createRunner(ImmutableList.of(this.singletonView));
        WindowedValue oneWindow = WindowedValue.of((Object)2, (Instant)new Instant(-2L), (BoundedWindow)new IntervalWindow(new Instant(-500L), new Instant(0L)), (PaneInfo)PaneInfo.ON_TIME_AND_ONLY_FIRING);
        Iterable oneWindowPushback = runner.processElementInReadyWindows(oneWindow);
        Assert.assertThat((Object)oneWindowPushback, (Matcher)Matchers.containsInAnyOrder((Object[])new WindowedValue[]{oneWindow}));
        Assert.assertThat(this.underlying.inputElems, (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void processElementSideInputNotReadyMultipleWindows() {
        Mockito.when((Object)this.reader.isReady((PCollectionView)Mockito.eq(this.singletonView), (BoundedWindow)Mockito.any(BoundedWindow.class))).thenReturn((Object)false);
        PushbackSideInputDoFnRunner<Integer, Integer> runner = this.createRunner(ImmutableList.of(this.singletonView));
        WindowedValue multiWindow = WindowedValue.of((Object)2, (Instant)new Instant(-2L), (Collection)ImmutableList.of((Object)new IntervalWindow(new Instant(-500L), new Instant(0L)), (Object)new IntervalWindow(BoundedWindow.TIMESTAMP_MIN_VALUE, new Instant(250L)), (Object)GlobalWindow.INSTANCE), (PaneInfo)PaneInfo.ON_TIME_AND_ONLY_FIRING);
        Iterable multiWindowPushback = runner.processElementInReadyWindows(multiWindow);
        Assert.assertThat((Object)multiWindowPushback, (Matcher)Matchers.equalTo((Object)multiWindow.explodeWindows()));
        Assert.assertThat(this.underlying.inputElems, (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void processElementSideInputNotReadySomeWindows() {
        Mockito.when((Object)this.reader.isReady((PCollectionView)Mockito.eq(this.singletonView), (BoundedWindow)Mockito.eq((Object)GlobalWindow.INSTANCE))).thenReturn((Object)false);
        Mockito.when((Object)this.reader.isReady((PCollectionView)Mockito.eq(this.singletonView), (BoundedWindow)AdditionalMatchers.not((Object)Mockito.eq((Object)GlobalWindow.INSTANCE)))).thenReturn((Object)true);
        PushbackSideInputDoFnRunner<Integer, Integer> runner = this.createRunner(ImmutableList.of(this.singletonView));
        IntervalWindow littleWindow = new IntervalWindow(new Instant(-500L), new Instant(0L));
        IntervalWindow bigWindow = new IntervalWindow(BoundedWindow.TIMESTAMP_MIN_VALUE, new Instant(250L));
        WindowedValue multiWindow = WindowedValue.of((Object)2, (Instant)new Instant(-2L), (Collection)ImmutableList.of((Object)littleWindow, (Object)bigWindow, (Object)GlobalWindow.INSTANCE), (PaneInfo)PaneInfo.NO_FIRING);
        Iterable multiWindowPushback = runner.processElementInReadyWindows(multiWindow);
        Assert.assertThat((Object)multiWindowPushback, (Matcher)Matchers.containsInAnyOrder((Object[])new WindowedValue[]{WindowedValue.timestampedValueInGlobalWindow((Object)2, (Instant)new Instant(-2L))}));
        Assert.assertThat(this.underlying.inputElems, (Matcher)Matchers.containsInAnyOrder((Object[])new WindowedValue[]{WindowedValue.of((Object)2, (Instant)new Instant(-2L), (BoundedWindow)littleWindow, (PaneInfo)PaneInfo.NO_FIRING), WindowedValue.of((Object)2, (Instant)new Instant(-2L), (BoundedWindow)bigWindow, (PaneInfo)PaneInfo.NO_FIRING)}));
    }

    @Test
    public void processElementSideInputReadyAllWindows() {
        Mockito.when((Object)this.reader.isReady((PCollectionView)Mockito.eq(this.singletonView), (BoundedWindow)Mockito.any(BoundedWindow.class))).thenReturn((Object)true);
        ImmutableList views = ImmutableList.of(this.singletonView);
        PushbackSideInputDoFnRunner<Integer, Integer> runner = this.createRunner(views);
        WindowedValue multiWindow = WindowedValue.of((Object)2, (Instant)new Instant(-2L), (Collection)ImmutableList.of((Object)new IntervalWindow(new Instant(-500L), new Instant(0L)), (Object)new IntervalWindow(BoundedWindow.TIMESTAMP_MIN_VALUE, new Instant(250L)), (Object)GlobalWindow.INSTANCE), (PaneInfo)PaneInfo.ON_TIME_AND_ONLY_FIRING);
        Iterable multiWindowPushback = runner.processElementInReadyWindows(multiWindow);
        Assert.assertThat((Object)multiWindowPushback, (Matcher)Matchers.emptyIterable());
        Assert.assertThat(this.underlying.inputElems, (Matcher)Matchers.containsInAnyOrder((Object[])ImmutableList.copyOf((Iterable)multiWindow.explodeWindows()).toArray()));
    }

    @Test
    public void processElementNoSideInputs() {
        PushbackSideInputDoFnRunner<Integer, Integer> runner = this.createRunner(ImmutableList.of());
        WindowedValue multiWindow = WindowedValue.of((Object)2, (Instant)new Instant(-2L), (Collection)ImmutableList.of((Object)new IntervalWindow(new Instant(-500L), new Instant(0L)), (Object)new IntervalWindow(BoundedWindow.TIMESTAMP_MIN_VALUE, new Instant(250L)), (Object)GlobalWindow.INSTANCE), (PaneInfo)PaneInfo.ON_TIME_AND_ONLY_FIRING);
        Iterable multiWindowPushback = runner.processElementInReadyWindows(multiWindow);
        Assert.assertThat((Object)multiWindowPushback, (Matcher)Matchers.emptyIterable());
        Assert.assertThat(this.underlying.inputElems, (Matcher)Matchers.containsInAnyOrder((Object[])new WindowedValue[]{multiWindow}));
    }

    private static class TestDoFnRunner<InputT, OutputT>
    implements DoFnRunner<InputT, OutputT> {
        List<WindowedValue<InputT>> inputElems;
        private boolean started = false;
        private boolean finished = false;

        private TestDoFnRunner() {
        }

        public void startBundle() {
            this.started = true;
            this.inputElems = new ArrayList<WindowedValue<InputT>>();
        }

        public void processElement(WindowedValue<InputT> elem) {
            this.inputElems.add(elem);
        }

        public void finishBundle() {
            this.finished = true;
        }
    }
}

