/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.beam.runners.core.ElementAndRestriction;
import org.apache.beam.runners.core.ElementAndRestrictionCoder;
import org.apache.beam.sdk.coders.BigEndianLongCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.testing.CoderProperties;
import org.apache.beam.sdk.util.CoderUtils;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ElementAndRestrictionCoderTest<K, V> {
    private static final List<AnyCoderAndData> TEST_DATA = Arrays.asList(ElementAndRestrictionCoderTest.coderAndData(VarIntCoder.of(), Arrays.asList(-1, 0, 1, 13, Integer.MAX_VALUE, Integer.MIN_VALUE)), ElementAndRestrictionCoderTest.coderAndData(BigEndianLongCoder.of(), Arrays.asList(-1L, 0L, 1L, 13L, Long.MAX_VALUE, Long.MIN_VALUE)), ElementAndRestrictionCoderTest.coderAndData(StringUtf8Coder.of(), Arrays.asList("", "hello", "goodbye", "1")), ElementAndRestrictionCoderTest.coderAndData(ElementAndRestrictionCoder.of((Coder)StringUtf8Coder.of(), (Coder)VarIntCoder.of()), Arrays.asList(ElementAndRestriction.of((Object)"", (Object)-1), ElementAndRestriction.of((Object)"hello", (Object)0), ElementAndRestriction.of((Object)"goodbye", (Object)Integer.MAX_VALUE))), ElementAndRestrictionCoderTest.coderAndData(ListCoder.of((Coder)VarLongCoder.of()), Arrays.asList(Arrays.asList(1L, 2L, 3L), Collections.emptyList())));
    @Parameterized.Parameter(value=0)
    public Coder<K> keyCoder;
    @Parameterized.Parameter(value=1)
    public K key;
    @Parameterized.Parameter(value=2)
    public Coder<V> valueCoder;
    @Parameterized.Parameter(value=3)
    public V value;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    private static <T> AnyCoderAndData coderAndData(Coder<T> coder, List<T> data) {
        CoderAndData coderAndData = new CoderAndData();
        coderAndData.coder = coder;
        coderAndData.data = data;
        AnyCoderAndData res = new AnyCoderAndData();
        res.coderAndData = coderAndData;
        return res;
    }

    @Parameterized.Parameters(name="{index}: keyCoder={0} key={1} valueCoder={2} value={3}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        for (AnyCoderAndData keyCoderAndData : TEST_DATA) {
            Coder keyCoder = ((AnyCoderAndData)keyCoderAndData).coderAndData.coder;
            for (Object key : ((AnyCoderAndData)keyCoderAndData).coderAndData.data) {
                for (AnyCoderAndData valueCoderAndData : TEST_DATA) {
                    Coder valueCoder = ((AnyCoderAndData)valueCoderAndData).coderAndData.coder;
                    for (Object value : ((AnyCoderAndData)valueCoderAndData).coderAndData.data) {
                        parameters.add(new Object[]{keyCoder, key, valueCoder, value});
                    }
                }
            }
        }
        return parameters;
    }

    @Test
    public void testDecodeEncodeEqual() throws Exception {
        CoderProperties.coderDecodeEncodeEqual((Coder)ElementAndRestrictionCoder.of(this.keyCoder, this.valueCoder), (Object)ElementAndRestriction.of(this.key, this.value));
    }

    @Test
    public void encodeNullThrowsCoderException() throws Exception {
        this.thrown.expect(CoderException.class);
        this.thrown.expectMessage("cannot encode a null ElementAndRestriction");
        CoderUtils.encodeToBase64((Coder)ElementAndRestrictionCoder.of((Coder)StringUtf8Coder.of(), (Coder)VarIntCoder.of()), null);
    }

    private static class AnyCoderAndData {
        private CoderAndData<?> coderAndData;

        private AnyCoderAndData() {
        }
    }

    private static class CoderAndData<T> {
        Coder<T> coder;
        List<T> data;

        private CoderAndData() {
        }
    }
}

