/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.util.Iterator;
import java.util.List;
import org.apache.beam.sdk.WindowMatchers;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.sdk.repackaged.com.google.common.collect.Iterables;
import org.apache.beam.sdk.transforms.CombineWithContext;
import org.apache.beam.sdk.transforms.Sum;
import org.apache.beam.sdk.transforms.windowing.AfterEach;
import org.apache.beam.sdk.transforms.windowing.AfterFirst;
import org.apache.beam.sdk.transforms.windowing.AfterPane;
import org.apache.beam.sdk.transforms.windowing.AfterProcessingTime;
import org.apache.beam.sdk.transforms.windowing.AfterWatermark;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.Never;
import org.apache.beam.sdk.transforms.windowing.OutputTimeFns;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.transforms.windowing.Repeatedly;
import org.apache.beam.sdk.transforms.windowing.Sessions;
import org.apache.beam.sdk.transforms.windowing.SlidingWindows;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.ReduceFnTester;
import org.apache.beam.sdk.util.SideInputReader;
import org.apache.beam.sdk.util.TimeDomain;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.util.WindowingStrategy;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TimestampedValue;
import org.hamcrest.Matcher;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.OngoingStubbing;

@RunWith(value=JUnit4.class)
public class ReduceFnRunnerTest {
    @Mock
    private SideInputReader mockSideInputReader;
    private Trigger mockTrigger;
    private PCollectionView<Integer> mockView;
    private IntervalWindow firstWindow;

    private static Trigger.TriggerContext anyTriggerContext() {
        return (Trigger.TriggerContext)Mockito.any();
    }

    private static Trigger.OnElementContext anyElementContext() {
        return (Trigger.OnElementContext)Mockito.any();
    }

    @Before
    public void setUp() {
        PCollectionView mockViewUnchecked;
        MockitoAnnotations.initMocks((Object)this);
        this.mockTrigger = (Trigger)Mockito.mock(Trigger.class, (MockSettings)Mockito.withSettings().serializable());
        this.mockView = mockViewUnchecked = (PCollectionView)Mockito.mock(PCollectionView.class, (MockSettings)Mockito.withSettings().serializable());
        this.firstWindow = new IntervalWindow(new Instant(0L), new Instant(10L));
    }

    private void injectElement(ReduceFnTester<Integer, ?, IntervalWindow> tester, int element) throws Exception {
        ((Trigger)Mockito.doNothing().when((Object)this.mockTrigger)).onElement(ReduceFnRunnerTest.anyElementContext());
        tester.injectElements(TimestampedValue.of((Object)element, (Instant)new Instant((long)element)));
    }

    private void triggerShouldFinish(Trigger mockTrigger) throws Exception {
        ((Trigger)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Exception {
                Trigger.TriggerContext context = (Trigger.TriggerContext)invocation.getArguments()[0];
                context.trigger().setFinished(true);
                return null;
            }
        }).when((Object)mockTrigger)).onFire(ReduceFnRunnerTest.anyTriggerContext());
    }

    @Test
    public void testOnElementBufferingDiscarding() throws Exception {
        ReduceFnTester tester = ReduceFnTester.nonCombining(FixedWindows.of((Duration)Duration.millis((long)10L)), this.mockTrigger, WindowingStrategy.AccumulationMode.DISCARDING_FIRED_PANES, Duration.millis((long)100L), Window.ClosingBehavior.FIRE_IF_NON_EMPTY);
        this.injectElement(tester, 1);
        Mockito.when((Object)this.mockTrigger.shouldFire(ReduceFnRunnerTest.anyTriggerContext())).thenReturn((Object)true);
        this.injectElement(tester, 2);
        Assert.assertThat(tester.extractOutput(), (Matcher)org.hamcrest.Matchers.contains((Matcher)WindowMatchers.isSingleWindowedValue((Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])new Integer[]{1, 2}), (long)1L, (long)0L, (long)10L)));
        Mockito.when((Object)this.mockTrigger.shouldFire(ReduceFnRunnerTest.anyTriggerContext())).thenReturn((Object)true);
        this.triggerShouldFinish(this.mockTrigger);
        this.injectElement(tester, 3);
        Assert.assertThat(tester.extractOutput(), (Matcher)org.hamcrest.Matchers.contains((Matcher)WindowMatchers.isSingleWindowedValue((Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])new Integer[]{3}), (long)3L, (long)0L, (long)10L)));
        Assert.assertTrue((boolean)tester.isMarkedFinished(this.firstWindow));
        tester.assertHasOnlyGlobalAndFinishedSetsFor((BoundedWindow[])new IntervalWindow[]{this.firstWindow});
        this.injectElement(tester, 4);
        Assert.assertEquals((long)1L, (long)tester.getElementsDroppedDueToClosedWindow());
    }

    @Test
    public void testOnElementBufferingAccumulating() throws Exception {
        ReduceFnTester tester = ReduceFnTester.nonCombining(FixedWindows.of((Duration)Duration.millis((long)10L)), this.mockTrigger, WindowingStrategy.AccumulationMode.ACCUMULATING_FIRED_PANES, Duration.millis((long)100L), Window.ClosingBehavior.FIRE_IF_NON_EMPTY);
        this.injectElement(tester, 1);
        Mockito.when((Object)this.mockTrigger.shouldFire(ReduceFnRunnerTest.anyTriggerContext())).thenReturn((Object)true);
        this.injectElement(tester, 2);
        Mockito.when((Object)this.mockTrigger.shouldFire(ReduceFnRunnerTest.anyTriggerContext())).thenReturn((Object)true);
        this.triggerShouldFinish(this.mockTrigger);
        this.injectElement(tester, 3);
        this.injectElement(tester, 4);
        Assert.assertThat(tester.extractOutput(), (Matcher)org.hamcrest.Matchers.contains((Matcher[])new Matcher[]{WindowMatchers.isSingleWindowedValue((Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])new Integer[]{1, 2}), (long)1L, (long)0L, (long)10L), WindowMatchers.isSingleWindowedValue((Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])new Integer[]{1, 2, 3}), (long)3L, (long)0L, (long)10L)}));
        Assert.assertTrue((boolean)tester.isMarkedFinished(this.firstWindow));
        tester.assertHasOnlyGlobalAndFinishedSetsFor((BoundedWindow[])new IntervalWindow[]{this.firstWindow});
    }

    @Test
    public void testOnElementCombiningDiscarding() throws Exception {
        ReduceFnTester tester = ReduceFnTester.combining(FixedWindows.of((Duration)Duration.millis((long)10L)), this.mockTrigger, WindowingStrategy.AccumulationMode.DISCARDING_FIRED_PANES, new Sum.SumIntegerFn().asKeyedFn(), VarIntCoder.of(), Duration.millis((long)100L));
        this.injectElement(tester, 2);
        Mockito.when((Object)this.mockTrigger.shouldFire(ReduceFnRunnerTest.anyTriggerContext())).thenReturn((Object)true);
        this.injectElement(tester, 3);
        Mockito.when((Object)this.mockTrigger.shouldFire(ReduceFnRunnerTest.anyTriggerContext())).thenReturn((Object)true);
        this.triggerShouldFinish(this.mockTrigger);
        this.injectElement(tester, 4);
        this.injectElement(tester, 6);
        Assert.assertThat(tester.extractOutput(), (Matcher)org.hamcrest.Matchers.contains((Matcher[])new Matcher[]{WindowMatchers.isSingleWindowedValue((Matcher)org.hamcrest.Matchers.equalTo((Object)5), (long)2L, (long)0L, (long)10L), WindowMatchers.isSingleWindowedValue((Matcher)org.hamcrest.Matchers.equalTo((Object)4), (long)4L, (long)0L, (long)10L)}));
        Assert.assertTrue((boolean)tester.isMarkedFinished(this.firstWindow));
        tester.assertHasOnlyGlobalAndFinishedSetsFor((BoundedWindow[])new IntervalWindow[]{this.firstWindow});
    }

    @Test
    public void testFixedWindowEndOfTimeGarbageCollection() throws Exception {
        Duration allowedLateness = Duration.standardDays((long)365L);
        Duration windowSize = Duration.millis((long)10L);
        FixedWindows windowFn = FixedWindows.of((Duration)windowSize);
        final Instant elementTimestamp = GlobalWindow.INSTANCE.maxTimestamp().minus((ReadableDuration)allowedLateness).plus(1L);
        FixedWindows fixedWindows = windowFn;
        fixedWindows.getClass();
        IntervalWindow window = (IntervalWindow)Iterables.getOnlyElement((Iterable)windowFn.assignWindows(new WindowFn.AssignContext((WindowFn)fixedWindows){

            public Object element() {
                throw new UnsupportedOperationException();
            }

            public Instant timestamp() {
                return elementTimestamp;
            }

            public BoundedWindow window() {
                throw new UnsupportedOperationException();
            }
        }));
        Assert.assertTrue((boolean)window.maxTimestamp().isBefore((ReadableInstant)GlobalWindow.INSTANCE.maxTimestamp()));
        Assert.assertTrue((boolean)window.maxTimestamp().plus((ReadableDuration)allowedLateness).isAfter((ReadableInstant)GlobalWindow.INSTANCE.maxTimestamp()));
        ReduceFnTester tester = ReduceFnTester.combining(windowFn, (Trigger)AfterWatermark.pastEndOfWindow().withLateFirings(Never.ever()), WindowingStrategy.AccumulationMode.DISCARDING_FIRED_PANES, new Sum.SumIntegerFn().asKeyedFn(), VarIntCoder.of(), allowedLateness);
        tester.injectElements(TimestampedValue.of((Object)13, (Instant)elementTimestamp));
        tester.advanceInputWatermark(window.maxTimestamp());
        Assert.assertThat(tester.extractOutput(), (Matcher)org.hamcrest.Matchers.emptyIterable());
        tester.injectElements(TimestampedValue.of((Object)42, (Instant)elementTimestamp));
        tester.advanceInputWatermark(GlobalWindow.INSTANCE.maxTimestamp());
        Assert.assertThat(tester.extractOutput(), (Matcher)org.hamcrest.Matchers.contains((Matcher)WindowMatchers.isWindowedValue((Matcher)org.hamcrest.Matchers.equalTo((Object)55))));
    }

    @Test
    public void testOnElementCombiningAccumulating() throws Exception {
        ReduceFnTester tester = ReduceFnTester.combining(FixedWindows.of((Duration)Duration.millis((long)10L)), this.mockTrigger, WindowingStrategy.AccumulationMode.ACCUMULATING_FIRED_PANES, new Sum.SumIntegerFn().asKeyedFn(), VarIntCoder.of(), Duration.millis((long)100L));
        this.injectElement(tester, 1);
        Mockito.when((Object)this.mockTrigger.shouldFire(ReduceFnRunnerTest.anyTriggerContext())).thenReturn((Object)true);
        this.injectElement(tester, 2);
        Mockito.when((Object)this.mockTrigger.shouldFire(ReduceFnRunnerTest.anyTriggerContext())).thenReturn((Object)true);
        this.triggerShouldFinish(this.mockTrigger);
        this.injectElement(tester, 3);
        this.injectElement(tester, 4);
        Assert.assertThat(tester.extractOutput(), (Matcher)org.hamcrest.Matchers.contains((Matcher[])new Matcher[]{WindowMatchers.isSingleWindowedValue((Matcher)org.hamcrest.Matchers.equalTo((Object)3), (long)1L, (long)0L, (long)10L), WindowMatchers.isSingleWindowedValue((Matcher)org.hamcrest.Matchers.equalTo((Object)6), (long)3L, (long)0L, (long)10L)}));
        Assert.assertTrue((boolean)tester.isMarkedFinished(this.firstWindow));
        tester.assertHasOnlyGlobalAndFinishedSetsFor((BoundedWindow[])new IntervalWindow[]{this.firstWindow});
    }

    @Test
    public void testOnElementCombiningWithContext() throws Exception {
        Integer expectedValue = 5;
        WindowingStrategy windowingStrategy = WindowingStrategy.of((WindowFn)FixedWindows.of((Duration)Duration.millis((long)10L))).withTrigger(this.mockTrigger).withMode(WindowingStrategy.AccumulationMode.DISCARDING_FIRED_PANES).withOutputTimeFn(OutputTimeFns.outputAtEarliestInputTimestamp()).withAllowedLateness(Duration.millis((long)100L));
        TestOptions options = (TestOptions)PipelineOptionsFactory.as(TestOptions.class);
        options.setValue(5);
        Mockito.when((Object)this.mockSideInputReader.contains((PCollectionView)Matchers.any())).thenReturn((Object)true);
        Mockito.when((Object)this.mockSideInputReader.get((PCollectionView)Matchers.any(), (BoundedWindow)Matchers.any(BoundedWindow.class))).thenReturn((Object)5);
        OngoingStubbing suppressWarningsVar = Mockito.when((Object)this.mockView.getWindowingStrategyInternal()).thenReturn((Object)windowingStrategy);
        SumAndVerifyContextFn combineFn = new SumAndVerifyContextFn(this.mockView, expectedValue);
        ReduceFnTester tester = ReduceFnTester.combining(windowingStrategy, combineFn.asKeyedFn(), VarIntCoder.of(), options, this.mockSideInputReader);
        this.injectElement(tester, 2);
        Mockito.when((Object)this.mockTrigger.shouldFire(ReduceFnRunnerTest.anyTriggerContext())).thenReturn((Object)true);
        this.injectElement(tester, 3);
        Mockito.when((Object)this.mockTrigger.shouldFire(ReduceFnRunnerTest.anyTriggerContext())).thenReturn((Object)true);
        this.triggerShouldFinish(this.mockTrigger);
        this.injectElement(tester, 4);
        this.injectElement(tester, 6);
        Assert.assertThat(tester.extractOutput(), (Matcher)org.hamcrest.Matchers.contains((Matcher[])new Matcher[]{WindowMatchers.isSingleWindowedValue((Matcher)org.hamcrest.Matchers.equalTo((Object)5), (long)2L, (long)0L, (long)10L), WindowMatchers.isSingleWindowedValue((Matcher)org.hamcrest.Matchers.equalTo((Object)4), (long)4L, (long)0L, (long)10L)}));
        Assert.assertTrue((boolean)tester.isMarkedFinished(this.firstWindow));
        tester.assertHasOnlyGlobalAndFinishedSetsFor((BoundedWindow[])new IntervalWindow[]{this.firstWindow});
    }

    @Test
    public void testWatermarkHoldAndLateData() throws Exception {
        ReduceFnTester tester = ReduceFnTester.nonCombining(FixedWindows.of((Duration)Duration.millis((long)10L)), this.mockTrigger, WindowingStrategy.AccumulationMode.ACCUMULATING_FIRED_PANES, Duration.millis((long)10L), Window.ClosingBehavior.FIRE_IF_NON_EMPTY);
        Assert.assertEquals(null, (Object)tester.getWatermarkHold());
        Assert.assertEquals(null, (Object)tester.getOutputWatermark());
        this.injectElement(tester, 1);
        this.injectElement(tester, 3);
        Assert.assertEquals((Object)new Instant(1L), (Object)tester.getWatermarkHold());
        Mockito.when((Object)this.mockTrigger.shouldFire(ReduceFnRunnerTest.anyTriggerContext())).thenReturn((Object)true);
        this.injectElement(tester, 2);
        List<WindowedValue<Iterable<Integer>>> output = tester.extractOutput();
        Assert.assertThat(output, (Matcher)org.hamcrest.Matchers.contains((Matcher)WindowMatchers.isSingleWindowedValue((Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])new Integer[]{1, 2, 3}), (long)1L, (long)0L, (long)10L)));
        Assert.assertThat((Object)output.get(0).getPane(), (Matcher)org.hamcrest.Matchers.equalTo((Object)PaneInfo.createPane((boolean)true, (boolean)false, (PaneInfo.Timing)PaneInfo.Timing.EARLY, (long)0L, (long)-1L)));
        Assert.assertEquals((Object)new Instant(9L), (Object)tester.getWatermarkHold());
        Assert.assertEquals((long)0L, (long)tester.getElementsDroppedDueToClosedWindow());
        tester.advanceInputWatermark(new Instant(4L));
        Assert.assertEquals((Object)new Instant(4L), (Object)tester.getOutputWatermark());
        Mockito.when((Object)this.mockTrigger.shouldFire(ReduceFnRunnerTest.anyTriggerContext())).thenReturn((Object)false);
        tester.advanceInputWatermark(new Instant(4L));
        this.injectElement(tester, 2);
        this.injectElement(tester, 3);
        Assert.assertEquals((Object)new Instant(9L), (Object)tester.getWatermarkHold());
        this.injectElement(tester, 5);
        Assert.assertEquals((Object)new Instant(5L), (Object)tester.getWatermarkHold());
        Mockito.when((Object)this.mockTrigger.shouldFire(ReduceFnRunnerTest.anyTriggerContext())).thenReturn((Object)true);
        this.injectElement(tester, 4);
        output = tester.extractOutput();
        Assert.assertThat(output, (Matcher)org.hamcrest.Matchers.contains((Matcher)WindowMatchers.isSingleWindowedValue((Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])new Integer[]{1, 2, 3, 2, 3, 4, 5}), (long)4L, (long)0L, (long)10L)));
        Assert.assertThat((Object)output.get(0).getPane(), (Matcher)org.hamcrest.Matchers.equalTo((Object)PaneInfo.createPane((boolean)false, (boolean)false, (PaneInfo.Timing)PaneInfo.Timing.EARLY, (long)1L, (long)-1L)));
        Mockito.when((Object)this.mockTrigger.shouldFire(ReduceFnRunnerTest.anyTriggerContext())).thenReturn((Object)false);
        tester.advanceInputWatermark(new Instant(8L));
        this.injectElement(tester, 6);
        this.injectElement(tester, 5);
        Assert.assertEquals((Object)new Instant(9L), (Object)tester.getWatermarkHold());
        this.injectElement(tester, 4);
        Mockito.when((Object)this.mockTrigger.shouldFire(ReduceFnRunnerTest.anyTriggerContext())).thenReturn((Object)true);
        tester.advanceInputWatermark(new Instant(10L));
        output = tester.extractOutput();
        Assert.assertThat(output, (Matcher)org.hamcrest.Matchers.contains((Matcher)WindowMatchers.isSingleWindowedValue((Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])new Integer[]{1, 2, 3, 2, 3, 4, 5, 4, 5, 6}), (long)9L, (long)0L, (long)10L)));
        Assert.assertThat((Object)output.get(0).getPane(), (Matcher)org.hamcrest.Matchers.equalTo((Object)PaneInfo.createPane((boolean)false, (boolean)false, (PaneInfo.Timing)PaneInfo.Timing.ON_TIME, (long)2L, (long)0L)));
        Mockito.when((Object)this.mockTrigger.shouldFire(ReduceFnRunnerTest.anyTriggerContext())).thenReturn((Object)false);
        this.injectElement(tester, 8);
        Assert.assertEquals((long)0L, (long)tester.getElementsDroppedDueToClosedWindow());
        tester.advanceInputWatermark(new Instant(50L));
        output = tester.extractOutput();
        Assert.assertThat(output, (Matcher)org.hamcrest.Matchers.contains((Matcher)WindowMatchers.isSingleWindowedValue((Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])new Integer[]{1, 2, 3, 2, 3, 4, 5, 4, 5, 6, 8}), (long)9L, (long)0L, (long)10L)));
        Assert.assertThat((Object)output.get(0).getPane(), (Matcher)org.hamcrest.Matchers.equalTo((Object)PaneInfo.createPane((boolean)false, (boolean)true, (PaneInfo.Timing)PaneInfo.Timing.LATE, (long)3L, (long)1L)));
        Assert.assertEquals((Object)new Instant(50L), (Object)tester.getOutputWatermark());
        Assert.assertEquals(null, (Object)tester.getWatermarkHold());
        tester.fireTimer(new IntervalWindow(new Instant(0L), new Instant(10L)), new Instant(12L), TimeDomain.EVENT_TIME);
        Assert.assertFalse((boolean)tester.isMarkedFinished(this.firstWindow));
        tester.assertHasOnlyGlobalAndFinishedSetsFor((BoundedWindow[])new IntervalWindow[0]);
    }

    @Test
    public void dontSetHoldIfTooLateForEndOfWindowTimer() throws Exception {
        ReduceFnTester tester = ReduceFnTester.nonCombining(FixedWindows.of((Duration)Duration.millis((long)10L)), this.mockTrigger, WindowingStrategy.AccumulationMode.ACCUMULATING_FIRED_PANES, Duration.millis((long)10L), Window.ClosingBehavior.FIRE_ALWAYS);
        tester.setAutoAdvanceOutputWatermark(false);
        tester.advanceInputWatermark(new Instant(15L));
        tester.advanceOutputWatermark(new Instant(11L));
        this.injectElement(tester, 14);
        Assert.assertEquals((Object)new Instant(14L), (Object)tester.getWatermarkHold());
        Assert.assertEquals((Object)new Instant(19L), (Object)tester.getNextTimer(TimeDomain.EVENT_TIME));
        Mockito.when((Object)this.mockTrigger.shouldFire(ReduceFnRunnerTest.anyTriggerContext())).thenReturn((Object)true);
        tester.advanceInputWatermark(new Instant(20L));
        Mockito.when((Object)this.mockTrigger.shouldFire(ReduceFnRunnerTest.anyTriggerContext())).thenReturn((Object)false);
        Assert.assertEquals((Object)new Instant(29L), (Object)tester.getWatermarkHold());
        Assert.assertEquals((Object)new Instant(29L), (Object)tester.getNextTimer(TimeDomain.EVENT_TIME));
        this.injectElement(tester, 13);
        Assert.assertEquals((Object)new Instant(29L), (Object)tester.getWatermarkHold());
        Assert.assertEquals((Object)new Instant(29L), (Object)tester.getNextTimer(TimeDomain.EVENT_TIME));
        tester.advanceInputWatermark(new Instant(30L));
        Assert.assertFalse((boolean)tester.isMarkedFinished(new IntervalWindow(new Instant(10L), new Instant(20L))));
        tester.assertHasOnlyGlobalAndFinishedSetsFor((BoundedWindow[])new IntervalWindow[0]);
    }

    @Test
    public void testPaneInfoAllStates() throws Exception {
        ReduceFnTester tester = ReduceFnTester.nonCombining(FixedWindows.of((Duration)Duration.millis((long)10L)), this.mockTrigger, WindowingStrategy.AccumulationMode.DISCARDING_FIRED_PANES, Duration.millis((long)100L), Window.ClosingBehavior.FIRE_IF_NON_EMPTY);
        tester.advanceInputWatermark(new Instant(0L));
        Mockito.when((Object)this.mockTrigger.shouldFire(ReduceFnRunnerTest.anyTriggerContext())).thenReturn((Object)true);
        this.injectElement(tester, 1);
        Assert.assertThat(tester.extractOutput(), (Matcher)org.hamcrest.Matchers.contains((Matcher)WindowMatchers.valueWithPaneInfo((PaneInfo)PaneInfo.createPane((boolean)true, (boolean)false, (PaneInfo.Timing)PaneInfo.Timing.EARLY))));
        Mockito.when((Object)this.mockTrigger.shouldFire(ReduceFnRunnerTest.anyTriggerContext())).thenReturn((Object)true);
        this.injectElement(tester, 2);
        Assert.assertThat(tester.extractOutput(), (Matcher)org.hamcrest.Matchers.contains((Matcher)WindowMatchers.valueWithPaneInfo((PaneInfo)PaneInfo.createPane((boolean)false, (boolean)false, (PaneInfo.Timing)PaneInfo.Timing.EARLY, (long)1L, (long)-1L))));
        Mockito.when((Object)this.mockTrigger.shouldFire(ReduceFnRunnerTest.anyTriggerContext())).thenReturn((Object)false);
        tester.advanceInputWatermark(new Instant(15L));
        Mockito.when((Object)this.mockTrigger.shouldFire(ReduceFnRunnerTest.anyTriggerContext())).thenReturn((Object)true);
        this.injectElement(tester, 3);
        Assert.assertThat(tester.extractOutput(), (Matcher)org.hamcrest.Matchers.contains((Matcher)WindowMatchers.valueWithPaneInfo((PaneInfo)PaneInfo.createPane((boolean)false, (boolean)false, (PaneInfo.Timing)PaneInfo.Timing.ON_TIME, (long)2L, (long)0L))));
        Mockito.when((Object)this.mockTrigger.shouldFire(ReduceFnRunnerTest.anyTriggerContext())).thenReturn((Object)true);
        this.injectElement(tester, 4);
        Assert.assertThat(tester.extractOutput(), (Matcher)org.hamcrest.Matchers.contains((Matcher)WindowMatchers.valueWithPaneInfo((PaneInfo)PaneInfo.createPane((boolean)false, (boolean)false, (PaneInfo.Timing)PaneInfo.Timing.LATE, (long)3L, (long)1L))));
        Mockito.when((Object)this.mockTrigger.shouldFire(ReduceFnRunnerTest.anyTriggerContext())).thenReturn((Object)true);
        this.triggerShouldFinish(this.mockTrigger);
        this.injectElement(tester, 5);
        Assert.assertThat(tester.extractOutput(), (Matcher)org.hamcrest.Matchers.contains((Matcher)WindowMatchers.valueWithPaneInfo((PaneInfo)PaneInfo.createPane((boolean)false, (boolean)true, (PaneInfo.Timing)PaneInfo.Timing.LATE, (long)4L, (long)2L))));
    }

    @Test
    public void testPaneInfoAllStatesAfterWatermark() throws Exception {
        ReduceFnTester tester = ReduceFnTester.nonCombining(WindowingStrategy.of((WindowFn)FixedWindows.of((Duration)Duration.millis((long)10L))).withTrigger((Trigger)Repeatedly.forever((Trigger)AfterFirst.of((Trigger.OnceTrigger[])new Trigger.OnceTrigger[]{AfterPane.elementCountAtLeast((int)2), AfterWatermark.pastEndOfWindow()}))).withMode(WindowingStrategy.AccumulationMode.DISCARDING_FIRED_PANES).withAllowedLateness(Duration.millis((long)100L)).withOutputTimeFn(OutputTimeFns.outputAtEarliestInputTimestamp()).withClosingBehavior(Window.ClosingBehavior.FIRE_ALWAYS));
        tester.advanceInputWatermark(new Instant(0L));
        tester.injectElements(TimestampedValue.of((Object)1, (Instant)new Instant(1L)), TimestampedValue.of((Object)2, (Instant)new Instant(2L)));
        List<WindowedValue<Iterable<Integer>>> output = tester.extractOutput();
        Assert.assertThat(output, (Matcher)org.hamcrest.Matchers.contains((Matcher)WindowMatchers.valueWithPaneInfo((PaneInfo)PaneInfo.createPane((boolean)true, (boolean)false, (PaneInfo.Timing)PaneInfo.Timing.EARLY, (long)0L, (long)-1L))));
        Assert.assertThat(output, (Matcher)org.hamcrest.Matchers.contains((Matcher)WindowMatchers.isSingleWindowedValue((Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])new Integer[]{1, 2}), (long)1L, (long)0L, (long)10L)));
        tester.advanceInputWatermark(new Instant(50L));
        output = tester.extractOutput();
        Assert.assertThat(output, (Matcher)org.hamcrest.Matchers.contains((Matcher)WindowMatchers.valueWithPaneInfo((PaneInfo)PaneInfo.createPane((boolean)false, (boolean)false, (PaneInfo.Timing)PaneInfo.Timing.ON_TIME, (long)1L, (long)0L))));
        Assert.assertThat(output, (Matcher)org.hamcrest.Matchers.contains((Matcher)WindowMatchers.isSingleWindowedValue((Matcher)org.hamcrest.Matchers.emptyIterable(), (long)9L, (long)0L, (long)10L)));
        tester.advanceInputWatermark(new Instant(150L));
        output = tester.extractOutput();
        Assert.assertThat(output, (Matcher)org.hamcrest.Matchers.contains((Matcher)WindowMatchers.valueWithPaneInfo((PaneInfo)PaneInfo.createPane((boolean)false, (boolean)true, (PaneInfo.Timing)PaneInfo.Timing.LATE, (long)2L, (long)1L))));
        Assert.assertThat(output, (Matcher)org.hamcrest.Matchers.contains((Matcher)WindowMatchers.isSingleWindowedValue((Matcher)org.hamcrest.Matchers.emptyIterable(), (long)9L, (long)0L, (long)10L)));
    }

    @Test
    public void noEmptyPanesFinalIfNonEmpty() throws Exception {
        ReduceFnTester tester = ReduceFnTester.nonCombining(WindowingStrategy.of((WindowFn)FixedWindows.of((Duration)Duration.millis((long)10L))).withTrigger((Trigger)Repeatedly.forever((Trigger)AfterFirst.of((Trigger.OnceTrigger[])new Trigger.OnceTrigger[]{AfterPane.elementCountAtLeast((int)2), AfterWatermark.pastEndOfWindow()}))).withMode(WindowingStrategy.AccumulationMode.ACCUMULATING_FIRED_PANES).withAllowedLateness(Duration.millis((long)100L)).withOutputTimeFn(OutputTimeFns.outputAtEarliestInputTimestamp()).withClosingBehavior(Window.ClosingBehavior.FIRE_IF_NON_EMPTY));
        tester.advanceInputWatermark(new Instant(0L));
        tester.injectElements(TimestampedValue.of((Object)1, (Instant)new Instant(1L)), TimestampedValue.of((Object)2, (Instant)new Instant(2L)));
        tester.advanceInputWatermark(new Instant(20L));
        tester.advanceInputWatermark(new Instant(250L));
        List<WindowedValue<Iterable<Integer>>> output = tester.extractOutput();
        Assert.assertThat(output, (Matcher)org.hamcrest.Matchers.contains((Matcher[])new Matcher[]{WindowMatchers.isSingleWindowedValue((Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])new Integer[]{1, 2}), (long)1L, (long)0L, (long)10L), WindowMatchers.isSingleWindowedValue((Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])new Integer[]{1, 2}), (long)9L, (long)0L, (long)10L)}));
    }

    @Test
    public void noEmptyPanesFinalAlways() throws Exception {
        ReduceFnTester tester = ReduceFnTester.nonCombining(WindowingStrategy.of((WindowFn)FixedWindows.of((Duration)Duration.millis((long)10L))).withTrigger((Trigger)Repeatedly.forever((Trigger)AfterFirst.of((Trigger.OnceTrigger[])new Trigger.OnceTrigger[]{AfterPane.elementCountAtLeast((int)2), AfterWatermark.pastEndOfWindow()}))).withMode(WindowingStrategy.AccumulationMode.ACCUMULATING_FIRED_PANES).withAllowedLateness(Duration.millis((long)100L)).withOutputTimeFn(OutputTimeFns.outputAtEarliestInputTimestamp()).withClosingBehavior(Window.ClosingBehavior.FIRE_ALWAYS));
        tester.advanceInputWatermark(new Instant(0L));
        tester.injectElements(TimestampedValue.of((Object)1, (Instant)new Instant(1L)), TimestampedValue.of((Object)2, (Instant)new Instant(2L)));
        tester.advanceInputWatermark(new Instant(20L));
        tester.advanceInputWatermark(new Instant(250L));
        List<WindowedValue<Iterable<Integer>>> output = tester.extractOutput();
        Assert.assertThat(output, (Matcher)org.hamcrest.Matchers.contains((Matcher[])new Matcher[]{WindowMatchers.isSingleWindowedValue((Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])new Integer[]{1, 2}), (long)1L, (long)0L, (long)10L), WindowMatchers.isSingleWindowedValue((Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])new Integer[]{1, 2}), (long)9L, (long)0L, (long)10L), WindowMatchers.isSingleWindowedValue((Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])new Integer[]{1, 2}), (long)9L, (long)0L, (long)10L)}));
    }

    @Test
    public void testPaneInfoAllStatesAfterWatermarkAccumulating() throws Exception {
        ReduceFnTester tester = ReduceFnTester.nonCombining(WindowingStrategy.of((WindowFn)FixedWindows.of((Duration)Duration.millis((long)10L))).withTrigger((Trigger)Repeatedly.forever((Trigger)AfterFirst.of((Trigger.OnceTrigger[])new Trigger.OnceTrigger[]{AfterPane.elementCountAtLeast((int)2), AfterWatermark.pastEndOfWindow()}))).withMode(WindowingStrategy.AccumulationMode.ACCUMULATING_FIRED_PANES).withAllowedLateness(Duration.millis((long)100L)).withOutputTimeFn(OutputTimeFns.outputAtEarliestInputTimestamp()).withClosingBehavior(Window.ClosingBehavior.FIRE_ALWAYS));
        tester.advanceInputWatermark(new Instant(0L));
        tester.injectElements(TimestampedValue.of((Object)1, (Instant)new Instant(1L)), TimestampedValue.of((Object)2, (Instant)new Instant(2L)));
        List<WindowedValue<Iterable<Integer>>> output = tester.extractOutput();
        Assert.assertThat(output, (Matcher)org.hamcrest.Matchers.contains((Matcher)WindowMatchers.valueWithPaneInfo((PaneInfo)PaneInfo.createPane((boolean)true, (boolean)false, (PaneInfo.Timing)PaneInfo.Timing.EARLY, (long)0L, (long)-1L))));
        Assert.assertThat(output, (Matcher)org.hamcrest.Matchers.contains((Matcher)WindowMatchers.isSingleWindowedValue((Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])new Integer[]{1, 2}), (long)1L, (long)0L, (long)10L)));
        tester.advanceInputWatermark(new Instant(50L));
        output = tester.extractOutput();
        Assert.assertThat(output, (Matcher)org.hamcrest.Matchers.contains((Matcher)WindowMatchers.valueWithPaneInfo((PaneInfo)PaneInfo.createPane((boolean)false, (boolean)false, (PaneInfo.Timing)PaneInfo.Timing.ON_TIME, (long)1L, (long)0L))));
        Assert.assertThat(output, (Matcher)org.hamcrest.Matchers.contains((Matcher)WindowMatchers.isSingleWindowedValue((Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])new Integer[]{1, 2}), (long)9L, (long)0L, (long)10L)));
        tester.advanceInputWatermark(new Instant(150L));
        output = tester.extractOutput();
        Assert.assertThat(output, (Matcher)org.hamcrest.Matchers.contains((Matcher)WindowMatchers.valueWithPaneInfo((PaneInfo)PaneInfo.createPane((boolean)false, (boolean)true, (PaneInfo.Timing)PaneInfo.Timing.LATE, (long)2L, (long)1L))));
        Assert.assertThat(output, (Matcher)org.hamcrest.Matchers.contains((Matcher)WindowMatchers.isSingleWindowedValue((Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])new Integer[]{1, 2}), (long)9L, (long)0L, (long)10L)));
    }

    @Test
    public void testPaneInfoFinalAndOnTime() throws Exception {
        ReduceFnTester tester = ReduceFnTester.nonCombining(WindowingStrategy.of((WindowFn)FixedWindows.of((Duration)Duration.millis((long)10L))).withTrigger(Repeatedly.forever((Trigger)AfterPane.elementCountAtLeast((int)2)).orFinally((Trigger.OnceTrigger)AfterWatermark.pastEndOfWindow())).withMode(WindowingStrategy.AccumulationMode.DISCARDING_FIRED_PANES).withAllowedLateness(Duration.millis((long)100L)).withClosingBehavior(Window.ClosingBehavior.FIRE_ALWAYS));
        tester.advanceInputWatermark(new Instant(0L));
        tester.injectElements(TimestampedValue.of((Object)1, (Instant)new Instant(1L)), TimestampedValue.of((Object)2, (Instant)new Instant(2L)));
        Assert.assertThat(tester.extractOutput(), (Matcher)org.hamcrest.Matchers.contains((Matcher)WindowMatchers.valueWithPaneInfo((PaneInfo)PaneInfo.createPane((boolean)true, (boolean)false, (PaneInfo.Timing)PaneInfo.Timing.EARLY, (long)0L, (long)-1L))));
        tester.advanceInputWatermark(new Instant(150L));
        Assert.assertThat(tester.extractOutput(), (Matcher)org.hamcrest.Matchers.contains((Matcher)WindowMatchers.valueWithPaneInfo((PaneInfo)PaneInfo.createPane((boolean)false, (boolean)true, (PaneInfo.Timing)PaneInfo.Timing.ON_TIME, (long)1L, (long)0L))));
    }

    @Test
    public void testPaneInfoSkipToFinish() throws Exception {
        ReduceFnTester tester = ReduceFnTester.nonCombining(FixedWindows.of((Duration)Duration.millis((long)10L)), this.mockTrigger, WindowingStrategy.AccumulationMode.DISCARDING_FIRED_PANES, Duration.millis((long)100L), Window.ClosingBehavior.FIRE_IF_NON_EMPTY);
        tester.advanceInputWatermark(new Instant(0L));
        Mockito.when((Object)this.mockTrigger.shouldFire(ReduceFnRunnerTest.anyTriggerContext())).thenReturn((Object)true);
        this.triggerShouldFinish(this.mockTrigger);
        this.injectElement(tester, 1);
        Assert.assertThat(tester.extractOutput(), (Matcher)org.hamcrest.Matchers.contains((Matcher)WindowMatchers.valueWithPaneInfo((PaneInfo)PaneInfo.createPane((boolean)true, (boolean)true, (PaneInfo.Timing)PaneInfo.Timing.EARLY))));
    }

    @Test
    public void testPaneInfoSkipToNonSpeculativeAndFinish() throws Exception {
        ReduceFnTester tester = ReduceFnTester.nonCombining(FixedWindows.of((Duration)Duration.millis((long)10L)), this.mockTrigger, WindowingStrategy.AccumulationMode.DISCARDING_FIRED_PANES, Duration.millis((long)100L), Window.ClosingBehavior.FIRE_IF_NON_EMPTY);
        tester.advanceInputWatermark(new Instant(15L));
        Mockito.when((Object)this.mockTrigger.shouldFire(ReduceFnRunnerTest.anyTriggerContext())).thenReturn((Object)true);
        this.triggerShouldFinish(this.mockTrigger);
        this.injectElement(tester, 1);
        Assert.assertThat(tester.extractOutput(), (Matcher)org.hamcrest.Matchers.contains((Matcher)WindowMatchers.valueWithPaneInfo((PaneInfo)PaneInfo.createPane((boolean)true, (boolean)true, (PaneInfo.Timing)PaneInfo.Timing.LATE))));
    }

    @Test
    public void testMergeBeforeFinalizing() throws Exception {
        ReduceFnTester tester = ReduceFnTester.nonCombining(Sessions.withGapDuration((Duration)Duration.millis((long)10L)), this.mockTrigger, WindowingStrategy.AccumulationMode.DISCARDING_FIRED_PANES, Duration.millis((long)0L), Window.ClosingBehavior.FIRE_IF_NON_EMPTY);
        tester.injectElements(TimestampedValue.of((Object)1, (Instant)new Instant(1L)), TimestampedValue.of((Object)10, (Instant)new Instant(10L)));
        tester.advanceInputWatermark(new Instant(100L));
        List<WindowedValue<Iterable<Integer>>> output = tester.extractOutput();
        Assert.assertThat((Object)output.size(), (Matcher)org.hamcrest.Matchers.equalTo((Object)1));
        Assert.assertThat(output.get(0), (Matcher)WindowMatchers.isSingleWindowedValue((Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])new Integer[]{1, 10}), (long)1L, (long)1L, (long)20L));
        Assert.assertThat((Object)output.get(0).getPane(), (Matcher)org.hamcrest.Matchers.equalTo((Object)PaneInfo.createPane((boolean)true, (boolean)true, (PaneInfo.Timing)PaneInfo.Timing.ON_TIME, (long)0L, (long)0L)));
    }

    @Test
    public void testMergingWithCloseBeforeGC() throws Exception {
        ReduceFnTester tester = ReduceFnTester.nonCombining(Sessions.withGapDuration((Duration)Duration.millis((long)10L)), this.mockTrigger, WindowingStrategy.AccumulationMode.DISCARDING_FIRED_PANES, Duration.millis((long)50L), Window.ClosingBehavior.FIRE_IF_NON_EMPTY);
        tester.injectElements(TimestampedValue.of((Object)1, (Instant)new Instant(1L)), TimestampedValue.of((Object)10, (Instant)new Instant(10L)));
        Mockito.when((Object)this.mockTrigger.shouldFire(ReduceFnRunnerTest.anyTriggerContext())).thenReturn((Object)true);
        this.triggerShouldFinish(this.mockTrigger);
        tester.advanceInputWatermark(new Instant(30L));
        tester.advanceInputWatermark(new Instant(100L));
        List<WindowedValue<Iterable<Integer>>> output = tester.extractOutput();
        Assert.assertThat((Object)output.size(), (Matcher)org.hamcrest.Matchers.equalTo((Object)1));
        Assert.assertThat(output.get(0), (Matcher)WindowMatchers.isSingleWindowedValue((Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])new Integer[]{1, 10}), (long)1L, (long)1L, (long)20L));
        Assert.assertThat((Object)output.get(0).getPane(), (Matcher)org.hamcrest.Matchers.equalTo((Object)PaneInfo.createPane((boolean)true, (boolean)true, (PaneInfo.Timing)PaneInfo.Timing.ON_TIME, (long)0L, (long)0L)));
    }

    @Test
    public void testMergingWithCloseTrigger() throws Exception {
        ReduceFnTester<Integer, Iterable<Integer>, IntervalWindow> tester = ReduceFnTester.nonCombining(Sessions.withGapDuration((Duration)Duration.millis((long)10L)), this.mockTrigger, WindowingStrategy.AccumulationMode.DISCARDING_FIRED_PANES, Duration.millis((long)50L), Window.ClosingBehavior.FIRE_IF_NON_EMPTY);
        tester.injectElements(TimestampedValue.of((Object)1, (Instant)new Instant(1L)), TimestampedValue.of((Object)2, (Instant)new Instant(2L)));
        Mockito.when((Object)this.mockTrigger.shouldFire(ReduceFnRunnerTest.anyTriggerContext())).thenReturn((Object)true);
        this.triggerShouldFinish(this.mockTrigger);
        tester.advanceInputWatermark(new Instant(13L));
        Assert.assertTrue((boolean)tester.isMarkedFinished(new IntervalWindow(new Instant(1L), new Instant(12L))));
        Mockito.when((Object)this.mockTrigger.shouldFire(ReduceFnRunnerTest.anyTriggerContext())).thenReturn((Object)false);
        tester.injectElements(TimestampedValue.of((Object)1, (Instant)new Instant(1L)), TimestampedValue.of((Object)2, (Instant)new Instant(2L)));
        Assert.assertTrue((boolean)tester.isMarkedFinished(new IntervalWindow(new Instant(1L), new Instant(12L))));
    }

    @Test
    public void testMergingWithReusedWindow() throws Exception {
        ReduceFnTester tester = ReduceFnTester.nonCombining(Sessions.withGapDuration((Duration)Duration.millis((long)10L)), this.mockTrigger, WindowingStrategy.AccumulationMode.DISCARDING_FIRED_PANES, Duration.millis((long)50L), Window.ClosingBehavior.FIRE_IF_NON_EMPTY);
        tester.injectElements(TimestampedValue.of((Object)1, (Instant)new Instant(1L)));
        Mockito.when((Object)this.mockTrigger.shouldFire(ReduceFnRunnerTest.anyTriggerContext())).thenReturn((Object)true);
        this.triggerShouldFinish(this.mockTrigger);
        tester.advanceInputWatermark(new Instant(15L));
        tester.injectElements(TimestampedValue.of((Object)1, (Instant)new Instant(1L)));
        Assert.assertTrue((boolean)tester.hasNoActiveWindows());
        tester.advanceInputWatermark(new Instant(100L));
        List<WindowedValue<Iterable<Integer>>> output = tester.extractOutput();
        Assert.assertThat((Object)output.size(), (Matcher)org.hamcrest.Matchers.equalTo((Object)1));
        Assert.assertThat(output.get(0), (Matcher)WindowMatchers.isSingleWindowedValue((Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])new Integer[]{1}), (long)1L, (long)1L, (long)11L));
        Assert.assertThat((Object)output.get(0).getPane(), (Matcher)org.hamcrest.Matchers.equalTo((Object)PaneInfo.createPane((boolean)true, (boolean)true, (PaneInfo.Timing)PaneInfo.Timing.ON_TIME, (long)0L, (long)0L)));
    }

    @Test
    public void testMergingWithClosedRepresentative() throws Exception {
        ReduceFnTester tester = ReduceFnTester.nonCombining(Sessions.withGapDuration((Duration)Duration.millis((long)10L)), this.mockTrigger, WindowingStrategy.AccumulationMode.DISCARDING_FIRED_PANES, Duration.millis((long)50L), Window.ClosingBehavior.FIRE_IF_NON_EMPTY);
        Mockito.when((Object)this.mockTrigger.shouldFire(ReduceFnRunnerTest.anyTriggerContext())).thenReturn((Object)true);
        this.triggerShouldFinish(this.mockTrigger);
        tester.injectElements(TimestampedValue.of((Object)1, (Instant)new Instant(1L)), TimestampedValue.of((Object)8, (Instant)new Instant(8L)));
        tester.injectElements(TimestampedValue.of((Object)1, (Instant)new Instant(1L)), TimestampedValue.of((Object)2, (Instant)new Instant(2L)), TimestampedValue.of((Object)8, (Instant)new Instant(8L)));
        tester.advanceInputWatermark(new Instant(100L));
        List<WindowedValue<Iterable<Integer>>> output = tester.extractOutput();
        Assert.assertThat((Object)output.size(), (Matcher)org.hamcrest.Matchers.equalTo((Object)1));
        Assert.assertThat(output.get(0), (Matcher)WindowMatchers.isSingleWindowedValue((Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])new Integer[]{1, 8}), (long)1L, (long)1L, (long)18L));
        Assert.assertThat((Object)output.get(0).getPane(), (Matcher)org.hamcrest.Matchers.equalTo((Object)PaneInfo.createPane((boolean)true, (boolean)true, (PaneInfo.Timing)PaneInfo.Timing.EARLY, (long)0L, (long)0L)));
    }

    @Test
    public void testMergingWithClosedDoesNotPoison() throws Exception {
        ReduceFnTester tester = ReduceFnTester.nonCombining(Sessions.withGapDuration((Duration)Duration.millis((long)10L)), this.mockTrigger, WindowingStrategy.AccumulationMode.DISCARDING_FIRED_PANES, Duration.millis((long)50L), Window.ClosingBehavior.FIRE_IF_NON_EMPTY);
        Mockito.when((Object)this.mockTrigger.shouldFire(ReduceFnRunnerTest.anyTriggerContext())).thenReturn((Object)true);
        this.triggerShouldFinish(this.mockTrigger);
        tester.injectElements(TimestampedValue.of((Object)2, (Instant)new Instant(2L)));
        Mockito.when((Object)this.mockTrigger.shouldFire(ReduceFnRunnerTest.anyTriggerContext())).thenReturn((Object)false);
        tester.injectElements(TimestampedValue.of((Object)1, (Instant)new Instant(1L)), TimestampedValue.of((Object)2, (Instant)new Instant(2L)), TimestampedValue.of((Object)3, (Instant)new Instant(3L)));
        tester.advanceInputWatermark(new Instant(100L));
        List<WindowedValue<Iterable<Integer>>> output = tester.extractOutput();
        Assert.assertThat((Object)output.size(), (Matcher)org.hamcrest.Matchers.equalTo((Object)2));
        Assert.assertThat(output.get(0), (Matcher)WindowMatchers.isSingleWindowedValue((Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])new Integer[]{2}), (long)2L, (long)2L, (long)12L));
        Assert.assertThat((Object)output.get(0).getPane(), (Matcher)org.hamcrest.Matchers.equalTo((Object)PaneInfo.createPane((boolean)true, (boolean)true, (PaneInfo.Timing)PaneInfo.Timing.EARLY, (long)0L, (long)0L)));
        Assert.assertThat(output.get(1), (Matcher)WindowMatchers.isSingleWindowedValue((Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])new Integer[]{1, 2, 3}), (long)1L, (long)1L, (long)13L));
        Assert.assertThat((Object)output.get(1).getPane(), (Matcher)org.hamcrest.Matchers.equalTo((Object)PaneInfo.createPane((boolean)true, (boolean)true, (PaneInfo.Timing)PaneInfo.Timing.ON_TIME, (long)0L, (long)0L)));
    }

    @Test
    public void testDropDataMultipleWindowsFinishedTrigger() throws Exception {
        ReduceFnTester tester = ReduceFnTester.combining(WindowingStrategy.of((WindowFn)SlidingWindows.of((Duration)Duration.millis((long)100L)).every(Duration.millis((long)30L))).withTrigger((Trigger)AfterWatermark.pastEndOfWindow()).withAllowedLateness(Duration.millis((long)1000L)), new Sum.SumIntegerFn().asKeyedFn(), VarIntCoder.of());
        tester.injectElements(TimestampedValue.of((Object)10, (Instant)new Instant(23L)), TimestampedValue.of((Object)12, (Instant)new Instant(40L)));
        Assert.assertEquals((long)0L, (long)tester.getElementsDroppedDueToClosedWindow());
        tester.advanceInputWatermark(new Instant(70L));
        tester.injectElements(TimestampedValue.of((Object)14, (Instant)new Instant(60L)));
        Assert.assertEquals((long)1L, (long)tester.getElementsDroppedDueToClosedWindow());
        tester.advanceInputWatermark(new Instant(130L));
        tester.injectElements(TimestampedValue.of((Object)16, (Instant)new Instant(40L)));
        Assert.assertEquals((long)4L, (long)tester.getElementsDroppedDueToClosedWindow());
    }

    @Test
    public void testIdempotentEmptyPanesDiscarding() throws Exception {
        ReduceFnTester tester = ReduceFnTester.nonCombining(FixedWindows.of((Duration)Duration.millis((long)10L)), this.mockTrigger, WindowingStrategy.AccumulationMode.DISCARDING_FIRED_PANES, Duration.millis((long)100L), Window.ClosingBehavior.FIRE_IF_NON_EMPTY);
        this.injectElement(tester, 1);
        this.injectElement(tester, 2);
        tester.advanceInputWatermark(new Instant(12L));
        Mockito.when((Object)this.mockTrigger.shouldFire(ReduceFnRunnerTest.anyTriggerContext())).thenReturn((Object)true);
        tester.fireTimer(this.firstWindow, new Instant(9L), TimeDomain.EVENT_TIME);
        Mockito.when((Object)this.mockTrigger.shouldFire(ReduceFnRunnerTest.anyTriggerContext())).thenReturn((Object)true);
        tester.fireTimer(this.firstWindow, new Instant(9L), TimeDomain.EVENT_TIME);
        Mockito.when((Object)this.mockTrigger.shouldFire(ReduceFnRunnerTest.anyTriggerContext())).thenReturn((Object)true);
        this.triggerShouldFinish(this.mockTrigger);
        this.injectElement(tester, 3);
        List<WindowedValue<Iterable<Integer>>> output = tester.extractOutput();
        Assert.assertThat((Object)output.size(), (Matcher)org.hamcrest.Matchers.equalTo((Object)2));
        Assert.assertThat(output.get(0), (Matcher)WindowMatchers.isSingleWindowedValue((Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])new Integer[]{1, 2}), (long)1L, (long)0L, (long)10L));
        Assert.assertThat((Object)output.get(1).getValue(), (Matcher)org.hamcrest.Matchers.contains((Object[])new Integer[]{3}));
        Assert.assertThat((Object)output.get(1).getPane(), (Matcher)org.hamcrest.Matchers.equalTo((Object)PaneInfo.createPane((boolean)false, (boolean)true, (PaneInfo.Timing)PaneInfo.Timing.LATE, (long)1L, (long)1L)));
        Assert.assertTrue((boolean)tester.isMarkedFinished(this.firstWindow));
        tester.assertHasOnlyGlobalAndFinishedSetsFor((BoundedWindow[])new IntervalWindow[]{this.firstWindow});
        Assert.assertEquals((long)0L, (long)tester.getElementsDroppedDueToClosedWindow());
    }

    @Test
    public void testIdempotentEmptyPanesAccumulating() throws Exception {
        ReduceFnTester tester = ReduceFnTester.nonCombining(FixedWindows.of((Duration)Duration.millis((long)10L)), this.mockTrigger, WindowingStrategy.AccumulationMode.ACCUMULATING_FIRED_PANES, Duration.millis((long)100L), Window.ClosingBehavior.FIRE_IF_NON_EMPTY);
        this.injectElement(tester, 1);
        this.injectElement(tester, 2);
        tester.advanceInputWatermark(new Instant(12L));
        Mockito.when((Object)this.mockTrigger.shouldFire(ReduceFnRunnerTest.anyTriggerContext())).thenReturn((Object)true);
        tester.fireTimer(this.firstWindow, new Instant(9L), TimeDomain.EVENT_TIME);
        List<WindowedValue<Iterable<Integer>>> output = tester.extractOutput();
        Assert.assertThat((Object)output.size(), (Matcher)org.hamcrest.Matchers.equalTo((Object)1));
        Assert.assertThat(output.get(0), (Matcher)WindowMatchers.isSingleWindowedValue((Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])new Integer[]{1, 2}), (long)1L, (long)0L, (long)10L));
        Assert.assertThat((Object)output.get(0).getPane(), (Matcher)org.hamcrest.Matchers.equalTo((Object)PaneInfo.createPane((boolean)true, (boolean)false, (PaneInfo.Timing)PaneInfo.Timing.ON_TIME, (long)0L, (long)0L)));
        Mockito.when((Object)this.mockTrigger.shouldFire(ReduceFnRunnerTest.anyTriggerContext())).thenReturn((Object)true);
        tester.fireTimer(this.firstWindow, new Instant(9L), TimeDomain.EVENT_TIME);
        Assert.assertThat((Object)tester.extractOutput().size(), (Matcher)org.hamcrest.Matchers.equalTo((Object)0));
        Mockito.when((Object)this.mockTrigger.shouldFire(ReduceFnRunnerTest.anyTriggerContext())).thenReturn((Object)true);
        this.triggerShouldFinish(this.mockTrigger);
        this.injectElement(tester, 3);
        output = tester.extractOutput();
        Assert.assertThat((Object)output.size(), (Matcher)org.hamcrest.Matchers.equalTo((Object)1));
        Assert.assertThat((Object)output.get(0).getValue(), (Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])new Integer[]{1, 2, 3}));
        Assert.assertThat((Object)output.get(0).getPane(), (Matcher)org.hamcrest.Matchers.equalTo((Object)PaneInfo.createPane((boolean)false, (boolean)true, (PaneInfo.Timing)PaneInfo.Timing.LATE, (long)1L, (long)1L)));
        Assert.assertTrue((boolean)tester.isMarkedFinished(this.firstWindow));
        tester.assertHasOnlyGlobalAndFinishedSetsFor((BoundedWindow[])new IntervalWindow[]{this.firstWindow});
        Assert.assertEquals((long)0L, (long)tester.getElementsDroppedDueToClosedWindow());
    }

    @Test
    public void testEmptyOnTimeFromOrFinally() throws Exception {
        ReduceFnTester tester = ReduceFnTester.combining(FixedWindows.of((Duration)Duration.millis((long)10L)), AfterEach.inOrder((Trigger[])new Trigger[]{Repeatedly.forever((Trigger)AfterProcessingTime.pastFirstElementInPane().plusDelayOf(new Duration(5L))).orFinally((Trigger.OnceTrigger)AfterWatermark.pastEndOfWindow()), Repeatedly.forever((Trigger)AfterProcessingTime.pastFirstElementInPane().plusDelayOf(new Duration(25L)))}), WindowingStrategy.AccumulationMode.ACCUMULATING_FIRED_PANES, new Sum.SumIntegerFn().asKeyedFn(), VarIntCoder.of(), Duration.millis((long)100L));
        tester.advanceInputWatermark(new Instant(0L));
        tester.advanceProcessingTime(new Instant(0L));
        tester.injectElements(TimestampedValue.of((Object)1, (Instant)new Instant(1L)), TimestampedValue.of((Object)1, (Instant)new Instant(3L)), TimestampedValue.of((Object)1, (Instant)new Instant(7L)), TimestampedValue.of((Object)1, (Instant)new Instant(5L)));
        tester.advanceProcessingTime(new Instant(6L));
        tester.advanceInputWatermark(new Instant(11L));
        List output = tester.extractOutput();
        Assert.assertEquals((long)2L, (long)output.size());
        Assert.assertThat(output.get(0), (Matcher)WindowMatchers.isSingleWindowedValue((Object)4, (long)1L, (long)0L, (long)10L));
        Assert.assertThat(output.get(1), (Matcher)WindowMatchers.isSingleWindowedValue((Object)4, (long)9L, (long)0L, (long)10L));
        Assert.assertThat(output.get(0), (Matcher)WindowMatchers.valueWithPaneInfo((PaneInfo)PaneInfo.createPane((boolean)true, (boolean)false, (PaneInfo.Timing)PaneInfo.Timing.EARLY, (long)0L, (long)-1L)));
        Assert.assertThat(output.get(1), (Matcher)WindowMatchers.valueWithPaneInfo((PaneInfo)PaneInfo.createPane((boolean)false, (boolean)false, (PaneInfo.Timing)PaneInfo.Timing.ON_TIME, (long)1L, (long)0L)));
    }

    @Test
    public void testProcessingTime() throws Exception {
        ReduceFnTester tester = ReduceFnTester.combining(FixedWindows.of((Duration)Duration.millis((long)10L)), AfterEach.inOrder((Trigger[])new Trigger[]{Repeatedly.forever((Trigger)AfterProcessingTime.pastFirstElementInPane().plusDelayOf(new Duration(5L))).orFinally((Trigger.OnceTrigger)AfterWatermark.pastEndOfWindow()), Repeatedly.forever((Trigger)AfterProcessingTime.pastFirstElementInPane().plusDelayOf(new Duration(25L)))}), WindowingStrategy.AccumulationMode.ACCUMULATING_FIRED_PANES, new Sum.SumIntegerFn().asKeyedFn(), VarIntCoder.of(), Duration.millis((long)100L));
        tester.advanceInputWatermark(new Instant(0L));
        tester.advanceProcessingTime(new Instant(0L));
        tester.injectElements(TimestampedValue.of((Object)1, (Instant)new Instant(1L)), TimestampedValue.of((Object)1, (Instant)new Instant(3L)), TimestampedValue.of((Object)1, (Instant)new Instant(7L)), TimestampedValue.of((Object)1, (Instant)new Instant(5L)));
        tester.advanceProcessingTime(new Instant(6L));
        tester.injectElements(TimestampedValue.of((Object)1, (Instant)new Instant(8L)), TimestampedValue.of((Object)1, (Instant)new Instant(4L)));
        tester.advanceInputWatermark(new Instant(11L));
        tester.injectElements(TimestampedValue.of((Object)1, (Instant)new Instant(8L)), TimestampedValue.of((Object)1, (Instant)new Instant(4L)), TimestampedValue.of((Object)1, (Instant)new Instant(5L)));
        tester.advanceInputWatermark(new Instant(12L));
        tester.injectElements(TimestampedValue.of((Object)1, (Instant)new Instant(3L)));
        tester.advanceProcessingTime(new Instant(15L));
        tester.injectElements(TimestampedValue.of((Object)1, (Instant)new Instant(5L)));
        tester.advanceProcessingTime(new Instant(32L));
        tester.injectElements(TimestampedValue.of((Object)1, (Instant)new Instant(3L)));
        tester.advanceInputWatermark(new Instant(125L));
        List output = tester.extractOutput();
        Assert.assertEquals((long)4L, (long)output.size());
        Assert.assertThat(output.get(0), (Matcher)WindowMatchers.isSingleWindowedValue((Object)4, (long)1L, (long)0L, (long)10L));
        Assert.assertThat(output.get(1), (Matcher)WindowMatchers.isSingleWindowedValue((Object)6, (long)4L, (long)0L, (long)10L));
        Assert.assertThat(output.get(2), (Matcher)WindowMatchers.isSingleWindowedValue((Object)11, (long)9L, (long)0L, (long)10L));
        Assert.assertThat(output.get(3), (Matcher)WindowMatchers.isSingleWindowedValue((Object)12, (long)9L, (long)0L, (long)10L));
        Assert.assertThat(output.get(0), (Matcher)WindowMatchers.valueWithPaneInfo((PaneInfo)PaneInfo.createPane((boolean)true, (boolean)false, (PaneInfo.Timing)PaneInfo.Timing.EARLY, (long)0L, (long)-1L)));
        Assert.assertThat(output.get(1), (Matcher)WindowMatchers.valueWithPaneInfo((PaneInfo)PaneInfo.createPane((boolean)false, (boolean)false, (PaneInfo.Timing)PaneInfo.Timing.ON_TIME, (long)1L, (long)0L)));
        Assert.assertThat(output.get(2), (Matcher)WindowMatchers.valueWithPaneInfo((PaneInfo)PaneInfo.createPane((boolean)false, (boolean)false, (PaneInfo.Timing)PaneInfo.Timing.LATE, (long)2L, (long)1L)));
        Assert.assertThat(output.get(3), (Matcher)WindowMatchers.valueWithPaneInfo((PaneInfo)PaneInfo.createPane((boolean)false, (boolean)true, (PaneInfo.Timing)PaneInfo.Timing.LATE, (long)3L, (long)2L)));
    }

    @Test
    public void fireNonEmptyOnDrainInGlobalWindow() throws Exception {
        ReduceFnTester tester = ReduceFnTester.nonCombining(WindowingStrategy.of((WindowFn)new GlobalWindows()).withTrigger((Trigger)Repeatedly.forever((Trigger)AfterPane.elementCountAtLeast((int)3))).withMode(WindowingStrategy.AccumulationMode.DISCARDING_FIRED_PANES));
        tester.advanceInputWatermark(new Instant(0L));
        int n = 20;
        for (int i = 0; i < 20; ++i) {
            tester.injectElements(TimestampedValue.of((Object)i, (Instant)new Instant((long)i)));
        }
        List<WindowedValue<Iterable<Integer>>> output = tester.extractOutput();
        Assert.assertEquals((long)6L, (long)output.size());
        for (int i = 0; i < output.size(); ++i) {
            Assert.assertEquals((Object)PaneInfo.Timing.EARLY, (Object)output.get(i).getPane().getTiming());
            Assert.assertEquals((long)i, (long)output.get(i).getPane().getIndex());
            Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)((Iterable)output.get(i).getValue())));
        }
        tester.advanceInputWatermark(BoundedWindow.TIMESTAMP_MAX_VALUE);
        output = tester.extractOutput();
        Assert.assertEquals((long)1L, (long)output.size());
        Assert.assertEquals((Object)PaneInfo.Timing.ON_TIME, (Object)output.get(0).getPane().getTiming());
        Assert.assertEquals((long)6L, (long)output.get(0).getPane().getIndex());
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)((Iterable)output.get(0).getValue())));
    }

    @Test
    public void fireEmptyOnDrainInGlobalWindowIfRequested() throws Exception {
        ReduceFnTester tester = ReduceFnTester.nonCombining(WindowingStrategy.of((WindowFn)new GlobalWindows()).withTrigger((Trigger)Repeatedly.forever((Trigger)AfterProcessingTime.pastFirstElementInPane().plusDelayOf(new Duration(3L)))).withMode(WindowingStrategy.AccumulationMode.DISCARDING_FIRED_PANES));
        int n = 20;
        for (int i = 0; i < 20; ++i) {
            tester.advanceProcessingTime(new Instant((long)i));
            tester.injectElements(TimestampedValue.of((Object)i, (Instant)new Instant((long)i)));
        }
        tester.advanceProcessingTime(new Instant(24L));
        List<WindowedValue<Iterable<Integer>>> output = tester.extractOutput();
        Assert.assertEquals((long)5L, (long)output.size());
        for (int i = 0; i < output.size(); ++i) {
            Assert.assertEquals((Object)PaneInfo.Timing.EARLY, (Object)output.get(i).getPane().getTiming());
            Assert.assertEquals((long)i, (long)output.get(i).getPane().getIndex());
            Assert.assertEquals((long)4L, (long)Iterables.size((Iterable)((Iterable)output.get(i).getValue())));
        }
        tester.advanceInputWatermark(BoundedWindow.TIMESTAMP_MAX_VALUE);
        output = tester.extractOutput();
        Assert.assertEquals((long)1L, (long)output.size());
        Assert.assertEquals((Object)PaneInfo.Timing.ON_TIME, (Object)output.get(0).getPane().getTiming());
        Assert.assertEquals((long)5L, (long)output.get(0).getPane().getIndex());
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)((Iterable)output.get(0).getValue())));
    }

    @Test
    public void setGarbageCollectionHoldOnLateElements() throws Exception {
        ReduceFnTester tester = ReduceFnTester.nonCombining(FixedWindows.of((Duration)Duration.millis((long)10L)), (Trigger)AfterWatermark.pastEndOfWindow().withLateFirings((Trigger.OnceTrigger)AfterPane.elementCountAtLeast((int)2)), WindowingStrategy.AccumulationMode.DISCARDING_FIRED_PANES, Duration.millis((long)100L), Window.ClosingBehavior.FIRE_IF_NON_EMPTY);
        tester.advanceInputWatermark(new Instant(0L));
        tester.advanceOutputWatermark(new Instant(0L));
        tester.injectElements(TimestampedValue.of((Object)1, (Instant)new Instant(1L)));
        tester.advanceInputWatermark(new Instant(109L));
        tester.advanceOutputWatermark(new Instant(109L));
        tester.injectElements(TimestampedValue.of((Object)2, (Instant)new Instant(2L)));
        Instant hold = tester.getWatermarkHold();
        Assert.assertEquals((Object)new Instant(109L), (Object)hold);
        tester.advanceInputWatermark(new Instant(110L));
        tester.advanceOutputWatermark(new Instant(110L));
        List<WindowedValue<Iterable<Integer>>> output = tester.extractOutput();
        Assert.assertEquals((long)2L, (long)output.size());
    }

    public static interface TestOptions
    extends PipelineOptions {
        public Integer getValue();

        public void setValue(Integer var1);
    }

    private static class SumAndVerifyContextFn
    extends CombineWithContext.CombineFnWithContext<Integer, int[], Integer> {
        private final PCollectionView<Integer> view;
        private final int expectedValue;

        private SumAndVerifyContextFn(PCollectionView<Integer> view, int expectedValue) {
            this.view = view;
            this.expectedValue = expectedValue;
        }

        public int[] createAccumulator(CombineWithContext.Context c) {
            Preconditions.checkArgument((((TestOptions)c.getPipelineOptions().as(TestOptions.class)).getValue() == this.expectedValue ? 1 : 0) != 0);
            Preconditions.checkArgument(((Integer)c.sideInput(this.view) == this.expectedValue ? 1 : 0) != 0);
            return this.wrap(0);
        }

        public int[] addInput(int[] accumulator, Integer input, CombineWithContext.Context c) {
            Preconditions.checkArgument((((TestOptions)c.getPipelineOptions().as(TestOptions.class)).getValue() == this.expectedValue ? 1 : 0) != 0);
            Preconditions.checkArgument(((Integer)c.sideInput(this.view) == this.expectedValue ? 1 : 0) != 0);
            accumulator[0] = accumulator[0] + input;
            return accumulator;
        }

        public int[] mergeAccumulators(Iterable<int[]> accumulators, CombineWithContext.Context c) {
            Preconditions.checkArgument((((TestOptions)c.getPipelineOptions().as(TestOptions.class)).getValue() == this.expectedValue ? 1 : 0) != 0);
            Preconditions.checkArgument(((Integer)c.sideInput(this.view) == this.expectedValue ? 1 : 0) != 0);
            Iterator<int[]> iter = accumulators.iterator();
            if (!iter.hasNext()) {
                return this.createAccumulator(c);
            }
            int[] running = iter.next();
            while (iter.hasNext()) {
                running[0] = running[0] + iter.next()[0];
            }
            return running;
        }

        public Integer extractOutput(int[] accumulator, CombineWithContext.Context c) {
            Preconditions.checkArgument((((TestOptions)c.getPipelineOptions().as(TestOptions.class)).getValue() == this.expectedValue ? 1 : 0) != 0);
            Preconditions.checkArgument(((Integer)c.sideInput(this.view) == this.expectedValue ? 1 : 0) != 0);
            return accumulator[0];
        }

        private int[] wrap(int value) {
            return new int[]{value};
        }
    }
}

