/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.util.Arrays;
import org.apache.beam.sdk.repackaged.com.google.common.collect.ImmutableList;
import org.apache.beam.sdk.repackaged.com.google.common.collect.Iterables;
import org.apache.beam.sdk.transforms.Aggregator;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.Sum;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.LateDataDroppingDoFnRunner;
import org.apache.beam.sdk.util.TimerInternals;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.util.WindowingStrategy;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class LateDataDroppingDoFnRunnerTest {
    private static final FixedWindows WINDOW_FN = FixedWindows.of((Duration)Duration.millis((long)10L));
    @Mock
    private TimerInternals mockTimerInternals;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testLateDataFilter() throws Exception {
        Mockito.when((Object)this.mockTimerInternals.currentInputWatermarkTime()).thenReturn((Object)new Instant(15L));
        InMemoryLongSumAggregator droppedDueToLateness = new InMemoryLongSumAggregator("droppedDueToLateness");
        LateDataDroppingDoFnRunner.LateDataFilter lateDataFilter = new LateDataDroppingDoFnRunner.LateDataFilter(WindowingStrategy.of((WindowFn)WINDOW_FN), this.mockTimerInternals, (Aggregator)droppedDueToLateness);
        Iterable actual = lateDataFilter.filter((Object)"a", (Iterable)ImmutableList.of(this.createDatum(13, 13L), this.createDatum(5, 5L), this.createDatum(16, 16L), this.createDatum(18, 18L)));
        ImmutableList expected = ImmutableList.of(this.createDatum(13, 13L), this.createDatum(16, 16L), this.createDatum(18, 18L));
        Assert.assertThat((Object)expected, (Matcher)Matchers.containsInAnyOrder((Object[])Iterables.toArray((Iterable)actual, WindowedValue.class)));
        Assert.assertEquals((long)1L, (long)droppedDueToLateness.sum);
    }

    private <T> WindowedValue<T> createDatum(T element, long timestampMillis) {
        Instant timestamp = new Instant(timestampMillis);
        return WindowedValue.of(element, (Instant)timestamp, Arrays.asList(WINDOW_FN.assignWindow(timestamp)), (PaneInfo)PaneInfo.NO_FIRING);
    }

    private static class InMemoryLongSumAggregator
    implements Aggregator<Long, Long> {
        private final String name;
        private long sum = 0L;

        public InMemoryLongSumAggregator(String name) {
            this.name = name;
        }

        public void addValue(Long value) {
            this.sum += value.longValue();
        }

        public String getName() {
            return this.name;
        }

        public Combine.CombineFn<Long, ?, Long> getCombineFn() {
            return new Sum.SumLongFn();
        }
    }
}

