/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.GroupAlsoByWindowsDoFn;
import org.apache.beam.sdk.util.GroupAlsoByWindowsProperties;
import org.apache.beam.sdk.util.GroupAlsoByWindowsViaOutputBufferDoFn;
import org.apache.beam.sdk.util.SystemReduceFn;
import org.apache.beam.sdk.util.WindowingStrategy;
import org.apache.beam.sdk.util.state.StateInternalsFactory;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GroupAlsoByWindowsViaOutputBufferDoFnTest {
    @Test
    public void testEmptyInputEmptyOutput() throws Exception {
        GroupAlsoByWindowsProperties.emptyInputEmptyOutput(new BufferingGABWViaOutputBufferDoFnFactory(StringUtf8Coder.of()));
    }

    @Test
    public void testGroupsElementsIntoFixedWindows() throws Exception {
        GroupAlsoByWindowsProperties.groupsElementsIntoFixedWindows(new BufferingGABWViaOutputBufferDoFnFactory<String, String>((Coder<String>)StringUtf8Coder.of()));
    }

    @Test
    public void testGroupsElementsIntoSlidingWindows() throws Exception {
        GroupAlsoByWindowsProperties.groupsElementsIntoSlidingWindowsWithMinTimestamp(new BufferingGABWViaOutputBufferDoFnFactory<String, String>((Coder<String>)StringUtf8Coder.of()));
    }

    @Test
    public void testGroupsIntoOverlappingNonmergingWindows() throws Exception {
        GroupAlsoByWindowsProperties.groupsIntoOverlappingNonmergingWindows(new BufferingGABWViaOutputBufferDoFnFactory<String, String>((Coder<String>)StringUtf8Coder.of()));
    }

    @Test
    public void testGroupsIntoSessions() throws Exception {
        GroupAlsoByWindowsProperties.groupsElementsInMergedSessions(new BufferingGABWViaOutputBufferDoFnFactory<String, String>((Coder<String>)StringUtf8Coder.of()));
    }

    @Test
    public void testGroupsElementsIntoFixedWindowsWithEndOfWindowTimestamp() throws Exception {
        GroupAlsoByWindowsProperties.groupsElementsIntoFixedWindowsWithEndOfWindowTimestamp(new BufferingGABWViaOutputBufferDoFnFactory<String, String>((Coder<String>)StringUtf8Coder.of()));
    }

    @Test
    public void testGroupsElementsIntoFixedWindowsWithLatestTimestamp() throws Exception {
        GroupAlsoByWindowsProperties.groupsElementsIntoFixedWindowsWithLatestTimestamp(new BufferingGABWViaOutputBufferDoFnFactory<String, String>((Coder<String>)StringUtf8Coder.of()));
    }

    @Test
    public void testGroupsElementsIntoSessionsWithEndOfWindowTimestamp() throws Exception {
        GroupAlsoByWindowsProperties.groupsElementsInMergedSessionsWithEndOfWindowTimestamp(new BufferingGABWViaOutputBufferDoFnFactory<String, String>((Coder<String>)StringUtf8Coder.of()));
    }

    @Test
    public void testGroupsElementsIntoSessionsWithLatestTimestamp() throws Exception {
        GroupAlsoByWindowsProperties.groupsElementsInMergedSessionsWithLatestTimestamp(new BufferingGABWViaOutputBufferDoFnFactory<String, String>((Coder<String>)StringUtf8Coder.of()));
    }

    private class BufferingGABWViaOutputBufferDoFnFactory<K, InputT>
    implements GroupAlsoByWindowsProperties.GroupAlsoByWindowsDoFnFactory<K, InputT, Iterable<InputT>> {
        private final Coder<InputT> inputCoder;

        public BufferingGABWViaOutputBufferDoFnFactory(Coder<InputT> inputCoder) {
            this.inputCoder = inputCoder;
        }

        @Override
        public <W extends BoundedWindow> GroupAlsoByWindowsDoFn<K, InputT, Iterable<InputT>, W> forStrategy(WindowingStrategy<?, W> windowingStrategy, StateInternalsFactory<K> stateInternalsFactory) {
            return new GroupAlsoByWindowsViaOutputBufferDoFn(windowingStrategy, stateInternalsFactory, SystemReduceFn.buffering(this.inputCoder));
        }
    }
}

