/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.beam.sdk.repackaged.com.google.common.cache.CacheBuilder;
import org.apache.beam.sdk.repackaged.com.google.common.cache.CacheLoader;
import org.apache.beam.sdk.repackaged.com.google.common.cache.LoadingCache;
import org.apache.beam.sdk.repackaged.com.google.common.collect.ImmutableList;
import org.apache.beam.sdk.repackaged.com.google.common.collect.Iterables;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.DoFnTester;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.OutputTimeFns;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.transforms.windowing.Sessions;
import org.apache.beam.sdk.transforms.windowing.SlidingWindows;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.GroupAlsoByWindowsDoFn;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.util.WindowingStrategy;
import org.apache.beam.sdk.util.state.InMemoryStateInternals;
import org.apache.beam.sdk.util.state.StateInternals;
import org.apache.beam.sdk.util.state.StateInternalsFactory;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.TimestampedValue;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.junit.Assert;

public class GroupAlsoByWindowsProperties {
    public static <K, InputT, OutputT> void emptyInputEmptyOutput(GroupAlsoByWindowsDoFnFactory<K, InputT, OutputT> gabwFactory) throws Exception {
        WindowingStrategy windowingStrategy = WindowingStrategy.of((WindowFn)FixedWindows.of((Duration)Duration.millis((long)10L)));
        String fakeKey = "this key should never be used";
        DoFnTester<KV<String, Iterable<WindowedValue<InputT>>>, KV<String, OutputT>> result = GroupAlsoByWindowsProperties.runGABW(gabwFactory, windowingStrategy, fakeKey, Collections.emptyList());
        Assert.assertThat((Object)result.peekOutputElements(), (Matcher)Matchers.hasSize((int)0));
    }

    public static void groupsElementsIntoFixedWindows(GroupAlsoByWindowsDoFnFactory<String, String, Iterable<String>> gabwFactory) throws Exception {
        WindowingStrategy windowingStrategy = WindowingStrategy.of((WindowFn)FixedWindows.of((Duration)Duration.millis((long)10L)));
        DoFnTester<KV<String, Iterable<WindowedValue<String>>>, KV<String, Iterable<String>>> result = GroupAlsoByWindowsProperties.runGABW(gabwFactory, windowingStrategy, "key", WindowedValue.of((Object)"v1", (Instant)new Instant(1L), Arrays.asList(GroupAlsoByWindowsProperties.window(0L, 10L)), (PaneInfo)PaneInfo.NO_FIRING), WindowedValue.of((Object)"v2", (Instant)new Instant(2L), Arrays.asList(GroupAlsoByWindowsProperties.window(0L, 10L)), (PaneInfo)PaneInfo.NO_FIRING), WindowedValue.of((Object)"v3", (Instant)new Instant(13L), Arrays.asList(GroupAlsoByWindowsProperties.window(10L, 20L)), (PaneInfo)PaneInfo.NO_FIRING));
        Assert.assertThat((Object)result.peekOutputElements(), (Matcher)Matchers.hasSize((int)2));
        TimestampedValue item0 = (TimestampedValue)Iterables.getOnlyElement((Iterable)result.peekOutputElementsInWindow(GroupAlsoByWindowsProperties.window(0L, 10L)));
        Assert.assertThat((Object)((KV)item0.getValue()).getValue(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"v1", "v2"}));
        Assert.assertThat((Object)item0.getTimestamp(), (Matcher)Matchers.equalTo((Object)GroupAlsoByWindowsProperties.window(0L, 10L).maxTimestamp()));
        TimestampedValue item1 = (TimestampedValue)Iterables.getOnlyElement((Iterable)result.peekOutputElementsInWindow(GroupAlsoByWindowsProperties.window(10L, 20L)));
        Assert.assertThat((Object)((KV)item1.getValue()).getValue(), (Matcher)Matchers.contains((Object[])new String[]{"v3"}));
        Assert.assertThat((Object)item1.getTimestamp(), (Matcher)Matchers.equalTo((Object)GroupAlsoByWindowsProperties.window(10L, 20L).maxTimestamp()));
    }

    public static void groupsElementsIntoSlidingWindowsWithMinTimestamp(GroupAlsoByWindowsDoFnFactory<String, String, Iterable<String>> gabwFactory) throws Exception {
        WindowingStrategy windowingStrategy = WindowingStrategy.of((WindowFn)SlidingWindows.of((Duration)Duration.millis((long)20L)).every(Duration.millis((long)10L))).withOutputTimeFn(OutputTimeFns.outputAtEarliestInputTimestamp());
        DoFnTester<KV<String, Iterable<WindowedValue<String>>>, KV<String, Iterable<String>>> result = GroupAlsoByWindowsProperties.runGABW(gabwFactory, windowingStrategy, "key", WindowedValue.of((Object)"v1", (Instant)new Instant(5L), Arrays.asList(GroupAlsoByWindowsProperties.window(-10L, 10L), GroupAlsoByWindowsProperties.window(0L, 20L)), (PaneInfo)PaneInfo.NO_FIRING), WindowedValue.of((Object)"v2", (Instant)new Instant(15L), Arrays.asList(GroupAlsoByWindowsProperties.window(0L, 20L), GroupAlsoByWindowsProperties.window(10L, 30L)), (PaneInfo)PaneInfo.NO_FIRING));
        Assert.assertThat((Object)result.peekOutputElements(), (Matcher)Matchers.hasSize((int)3));
        TimestampedValue item0 = (TimestampedValue)Iterables.getOnlyElement((Iterable)result.peekOutputElementsInWindow(GroupAlsoByWindowsProperties.window(-10L, 10L)));
        Assert.assertThat((Object)((KV)item0.getValue()).getValue(), (Matcher)Matchers.contains((Object[])new String[]{"v1"}));
        Assert.assertThat((Object)item0.getTimestamp(), (Matcher)Matchers.equalTo((Object)new Instant(5L)));
        TimestampedValue item1 = (TimestampedValue)Iterables.getOnlyElement((Iterable)result.peekOutputElementsInWindow(GroupAlsoByWindowsProperties.window(0L, 20L)));
        Assert.assertThat((Object)((KV)item1.getValue()).getValue(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"v1", "v2"}));
        Assert.assertThat((Object)item1.getTimestamp(), (Matcher)Matchers.equalTo((Object)new Instant(10L)));
        TimestampedValue item2 = (TimestampedValue)Iterables.getOnlyElement((Iterable)result.peekOutputElementsInWindow(GroupAlsoByWindowsProperties.window(10L, 30L)));
        Assert.assertThat((Object)((KV)item2.getValue()).getValue(), (Matcher)Matchers.contains((Object[])new String[]{"v2"}));
        Assert.assertThat((Object)item2.getTimestamp(), (Matcher)Matchers.equalTo((Object)new Instant(20L)));
    }

    public static void combinesElementsInSlidingWindows(GroupAlsoByWindowsDoFnFactory<String, Long, Long> gabwFactory, Combine.CombineFn<Long, ?, Long> combineFn) throws Exception {
        WindowingStrategy windowingStrategy = WindowingStrategy.of((WindowFn)SlidingWindows.of((Duration)Duration.millis((long)20L)).every(Duration.millis((long)10L))).withOutputTimeFn(OutputTimeFns.outputAtEarliestInputTimestamp());
        DoFnTester<KV<String, Iterable<WindowedValue<Long>>>, KV<String, Long>> result = GroupAlsoByWindowsProperties.runGABW(gabwFactory, windowingStrategy, "k", WindowedValue.of((Object)1L, (Instant)new Instant(5L), Arrays.asList(GroupAlsoByWindowsProperties.window(-10L, 10L), GroupAlsoByWindowsProperties.window(0L, 20L)), (PaneInfo)PaneInfo.NO_FIRING), WindowedValue.of((Object)2L, (Instant)new Instant(15L), Arrays.asList(GroupAlsoByWindowsProperties.window(0L, 20L), GroupAlsoByWindowsProperties.window(10L, 30L)), (PaneInfo)PaneInfo.NO_FIRING), WindowedValue.of((Object)4L, (Instant)new Instant(18L), Arrays.asList(GroupAlsoByWindowsProperties.window(0L, 20L), GroupAlsoByWindowsProperties.window(10L, 30L)), (PaneInfo)PaneInfo.NO_FIRING));
        Assert.assertThat((Object)result.peekOutputElements(), (Matcher)Matchers.hasSize((int)3));
        TimestampedValue item0 = (TimestampedValue)Iterables.getOnlyElement((Iterable)result.peekOutputElementsInWindow(GroupAlsoByWindowsProperties.window(-10L, 10L)));
        Assert.assertThat((Object)((KV)item0.getValue()).getKey(), (Matcher)Matchers.equalTo((Object)"k"));
        Assert.assertThat((Object)((KV)item0.getValue()).getValue(), (Matcher)Matchers.equalTo((Object)combineFn.apply((Iterable)ImmutableList.of((Object)1L))));
        Assert.assertThat((Object)item0.getTimestamp(), (Matcher)Matchers.equalTo((Object)new Instant(5L)));
        TimestampedValue item1 = (TimestampedValue)Iterables.getOnlyElement((Iterable)result.peekOutputElementsInWindow(GroupAlsoByWindowsProperties.window(0L, 20L)));
        Assert.assertThat((Object)((KV)item1.getValue()).getKey(), (Matcher)Matchers.equalTo((Object)"k"));
        Assert.assertThat((Object)((KV)item1.getValue()).getValue(), (Matcher)Matchers.equalTo((Object)combineFn.apply((Iterable)ImmutableList.of((Object)1L, (Object)2L, (Object)4L))));
        Assert.assertThat((Object)item1.getTimestamp(), (Matcher)Matchers.equalTo((Object)new Instant(10L)));
        TimestampedValue item2 = (TimestampedValue)Iterables.getOnlyElement((Iterable)result.peekOutputElementsInWindow(GroupAlsoByWindowsProperties.window(10L, 30L)));
        Assert.assertThat((Object)((KV)item2.getValue()).getKey(), (Matcher)Matchers.equalTo((Object)"k"));
        Assert.assertThat((Object)((KV)item2.getValue()).getValue(), (Matcher)Matchers.equalTo((Object)combineFn.apply((Iterable)ImmutableList.of((Object)2L, (Object)4L))));
        Assert.assertThat((Object)item2.getTimestamp(), (Matcher)Matchers.equalTo((Object)new Instant(20L)));
    }

    public static void groupsIntoOverlappingNonmergingWindows(GroupAlsoByWindowsDoFnFactory<String, String, Iterable<String>> gabwFactory) throws Exception {
        WindowingStrategy windowingStrategy = WindowingStrategy.of((WindowFn)FixedWindows.of((Duration)Duration.millis((long)10L)));
        DoFnTester<KV<String, Iterable<WindowedValue<String>>>, KV<String, Iterable<String>>> result = GroupAlsoByWindowsProperties.runGABW(gabwFactory, windowingStrategy, "key", WindowedValue.of((Object)"v1", (Instant)new Instant(1L), Arrays.asList(GroupAlsoByWindowsProperties.window(0L, 5L)), (PaneInfo)PaneInfo.NO_FIRING), WindowedValue.of((Object)"v2", (Instant)new Instant(4L), Arrays.asList(GroupAlsoByWindowsProperties.window(1L, 5L)), (PaneInfo)PaneInfo.NO_FIRING), WindowedValue.of((Object)"v3", (Instant)new Instant(4L), Arrays.asList(GroupAlsoByWindowsProperties.window(0L, 5L)), (PaneInfo)PaneInfo.NO_FIRING));
        Assert.assertThat((Object)result.peekOutputElements(), (Matcher)Matchers.hasSize((int)2));
        TimestampedValue item0 = (TimestampedValue)Iterables.getOnlyElement((Iterable)result.peekOutputElementsInWindow(GroupAlsoByWindowsProperties.window(0L, 5L)));
        Assert.assertThat((Object)((KV)item0.getValue()).getValue(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"v1", "v3"}));
        Assert.assertThat((Object)item0.getTimestamp(), (Matcher)Matchers.equalTo((Object)GroupAlsoByWindowsProperties.window(1L, 5L).maxTimestamp()));
        TimestampedValue item1 = (TimestampedValue)Iterables.getOnlyElement((Iterable)result.peekOutputElementsInWindow(GroupAlsoByWindowsProperties.window(1L, 5L)));
        Assert.assertThat((Object)((KV)item1.getValue()).getValue(), (Matcher)Matchers.contains((Object[])new String[]{"v2"}));
        Assert.assertThat((Object)item1.getTimestamp(), (Matcher)Matchers.equalTo((Object)GroupAlsoByWindowsProperties.window(0L, 5L).maxTimestamp()));
    }

    public static void groupsElementsInMergedSessions(GroupAlsoByWindowsDoFnFactory<String, String, Iterable<String>> gabwFactory) throws Exception {
        WindowingStrategy windowingStrategy = WindowingStrategy.of((WindowFn)Sessions.withGapDuration((Duration)Duration.millis((long)10L)));
        DoFnTester<KV<String, Iterable<WindowedValue<String>>>, KV<String, Iterable<String>>> result = GroupAlsoByWindowsProperties.runGABW(gabwFactory, windowingStrategy, "key", WindowedValue.of((Object)"v1", (Instant)new Instant(0L), Arrays.asList(GroupAlsoByWindowsProperties.window(0L, 10L)), (PaneInfo)PaneInfo.NO_FIRING), WindowedValue.of((Object)"v2", (Instant)new Instant(5L), Arrays.asList(GroupAlsoByWindowsProperties.window(5L, 15L)), (PaneInfo)PaneInfo.NO_FIRING), WindowedValue.of((Object)"v3", (Instant)new Instant(15L), Arrays.asList(GroupAlsoByWindowsProperties.window(15L, 25L)), (PaneInfo)PaneInfo.NO_FIRING));
        Assert.assertThat((Object)result.peekOutputElements(), (Matcher)Matchers.hasSize((int)2));
        TimestampedValue item0 = (TimestampedValue)Iterables.getOnlyElement((Iterable)result.peekOutputElementsInWindow(GroupAlsoByWindowsProperties.window(0L, 15L)));
        Assert.assertThat((Object)((KV)item0.getValue()).getValue(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"v1", "v2"}));
        Assert.assertThat((Object)item0.getTimestamp(), (Matcher)Matchers.equalTo((Object)GroupAlsoByWindowsProperties.window(0L, 15L).maxTimestamp()));
        TimestampedValue item1 = (TimestampedValue)Iterables.getOnlyElement((Iterable)result.peekOutputElementsInWindow(GroupAlsoByWindowsProperties.window(15L, 25L)));
        Assert.assertThat((Object)((KV)item1.getValue()).getValue(), (Matcher)Matchers.contains((Object[])new String[]{"v3"}));
        Assert.assertThat((Object)item1.getTimestamp(), (Matcher)Matchers.equalTo((Object)GroupAlsoByWindowsProperties.window(15L, 25L).maxTimestamp()));
    }

    public static void combinesElementsPerSession(GroupAlsoByWindowsDoFnFactory<String, Long, Long> gabwFactory, Combine.CombineFn<Long, ?, Long> combineFn) throws Exception {
        WindowingStrategy windowingStrategy = WindowingStrategy.of((WindowFn)Sessions.withGapDuration((Duration)Duration.millis((long)10L)));
        DoFnTester<KV<String, Iterable<WindowedValue<Long>>>, KV<String, Long>> result = GroupAlsoByWindowsProperties.runGABW(gabwFactory, windowingStrategy, "k", WindowedValue.of((Object)1L, (Instant)new Instant(0L), Arrays.asList(GroupAlsoByWindowsProperties.window(0L, 10L)), (PaneInfo)PaneInfo.NO_FIRING), WindowedValue.of((Object)2L, (Instant)new Instant(5L), Arrays.asList(GroupAlsoByWindowsProperties.window(5L, 15L)), (PaneInfo)PaneInfo.NO_FIRING), WindowedValue.of((Object)4L, (Instant)new Instant(15L), Arrays.asList(GroupAlsoByWindowsProperties.window(15L, 25L)), (PaneInfo)PaneInfo.NO_FIRING));
        Assert.assertThat((Object)result.peekOutputElements(), (Matcher)Matchers.hasSize((int)2));
        TimestampedValue item0 = (TimestampedValue)Iterables.getOnlyElement((Iterable)result.peekOutputElementsInWindow(GroupAlsoByWindowsProperties.window(0L, 15L)));
        Assert.assertThat((Object)((KV)item0.getValue()).getKey(), (Matcher)Matchers.equalTo((Object)"k"));
        Assert.assertThat((Object)((KV)item0.getValue()).getValue(), (Matcher)Matchers.equalTo((Object)combineFn.apply((Iterable)ImmutableList.of((Object)1L, (Object)2L))));
        Assert.assertThat((Object)item0.getTimestamp(), (Matcher)Matchers.equalTo((Object)GroupAlsoByWindowsProperties.window(0L, 15L).maxTimestamp()));
        TimestampedValue item1 = (TimestampedValue)Iterables.getOnlyElement((Iterable)result.peekOutputElementsInWindow(GroupAlsoByWindowsProperties.window(15L, 25L)));
        Assert.assertThat((Object)((KV)item1.getValue()).getKey(), (Matcher)Matchers.equalTo((Object)"k"));
        Assert.assertThat((Object)((KV)item1.getValue()).getValue(), (Matcher)Matchers.equalTo((Object)combineFn.apply((Iterable)ImmutableList.of((Object)4L))));
        Assert.assertThat((Object)item1.getTimestamp(), (Matcher)Matchers.equalTo((Object)GroupAlsoByWindowsProperties.window(15L, 25L).maxTimestamp()));
    }

    public static void groupsElementsIntoFixedWindowsWithEndOfWindowTimestamp(GroupAlsoByWindowsDoFnFactory<String, String, Iterable<String>> gabwFactory) throws Exception {
        WindowingStrategy windowingStrategy = WindowingStrategy.of((WindowFn)FixedWindows.of((Duration)Duration.millis((long)10L))).withOutputTimeFn(OutputTimeFns.outputAtEndOfWindow());
        DoFnTester<KV<String, Iterable<WindowedValue<String>>>, KV<String, Iterable<String>>> result = GroupAlsoByWindowsProperties.runGABW(gabwFactory, windowingStrategy, "key", WindowedValue.of((Object)"v1", (Instant)new Instant(1L), Arrays.asList(GroupAlsoByWindowsProperties.window(0L, 10L)), (PaneInfo)PaneInfo.NO_FIRING), WindowedValue.of((Object)"v2", (Instant)new Instant(2L), Arrays.asList(GroupAlsoByWindowsProperties.window(0L, 10L)), (PaneInfo)PaneInfo.NO_FIRING), WindowedValue.of((Object)"v3", (Instant)new Instant(13L), Arrays.asList(GroupAlsoByWindowsProperties.window(10L, 20L)), (PaneInfo)PaneInfo.NO_FIRING));
        Assert.assertThat((Object)result.peekOutputElements(), (Matcher)Matchers.hasSize((int)2));
        TimestampedValue item0 = (TimestampedValue)Iterables.getOnlyElement((Iterable)result.peekOutputElementsInWindow(GroupAlsoByWindowsProperties.window(0L, 10L)));
        Assert.assertThat((Object)((KV)item0.getValue()).getValue(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"v1", "v2"}));
        Assert.assertThat((Object)item0.getTimestamp(), (Matcher)Matchers.equalTo((Object)GroupAlsoByWindowsProperties.window(0L, 10L).maxTimestamp()));
        TimestampedValue item1 = (TimestampedValue)Iterables.getOnlyElement((Iterable)result.peekOutputElementsInWindow(GroupAlsoByWindowsProperties.window(10L, 20L)));
        Assert.assertThat((Object)((KV)item1.getValue()).getValue(), (Matcher)Matchers.contains((Object[])new String[]{"v3"}));
        Assert.assertThat((Object)item1.getTimestamp(), (Matcher)Matchers.equalTo((Object)GroupAlsoByWindowsProperties.window(10L, 20L).maxTimestamp()));
    }

    public static void groupsElementsIntoFixedWindowsWithLatestTimestamp(GroupAlsoByWindowsDoFnFactory<String, String, Iterable<String>> gabwFactory) throws Exception {
        WindowingStrategy windowingStrategy = WindowingStrategy.of((WindowFn)FixedWindows.of((Duration)Duration.millis((long)10L))).withOutputTimeFn(OutputTimeFns.outputAtLatestInputTimestamp());
        DoFnTester<KV<String, Iterable<WindowedValue<String>>>, KV<String, Iterable<String>>> result = GroupAlsoByWindowsProperties.runGABW(gabwFactory, windowingStrategy, "k", WindowedValue.of((Object)"v1", (Instant)new Instant(1L), Arrays.asList(GroupAlsoByWindowsProperties.window(0L, 10L)), (PaneInfo)PaneInfo.NO_FIRING), WindowedValue.of((Object)"v2", (Instant)new Instant(2L), Arrays.asList(GroupAlsoByWindowsProperties.window(0L, 10L)), (PaneInfo)PaneInfo.NO_FIRING), WindowedValue.of((Object)"v3", (Instant)new Instant(13L), Arrays.asList(GroupAlsoByWindowsProperties.window(10L, 20L)), (PaneInfo)PaneInfo.NO_FIRING));
        Assert.assertThat((Object)result.peekOutputElements(), (Matcher)Matchers.hasSize((int)2));
        TimestampedValue item0 = (TimestampedValue)Iterables.getOnlyElement((Iterable)result.peekOutputElementsInWindow(GroupAlsoByWindowsProperties.window(0L, 10L)));
        Assert.assertThat((Object)((KV)item0.getValue()).getValue(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"v1", "v2"}));
        Assert.assertThat((Object)item0.getTimestamp(), (Matcher)Matchers.equalTo((Object)new Instant(2L)));
        TimestampedValue item1 = (TimestampedValue)Iterables.getOnlyElement((Iterable)result.peekOutputElementsInWindow(GroupAlsoByWindowsProperties.window(10L, 20L)));
        Assert.assertThat((Object)((KV)item1.getValue()).getValue(), (Matcher)Matchers.contains((Object[])new String[]{"v3"}));
        Assert.assertThat((Object)item1.getTimestamp(), (Matcher)Matchers.equalTo((Object)new Instant(13L)));
    }

    public static void groupsElementsInMergedSessionsWithEndOfWindowTimestamp(GroupAlsoByWindowsDoFnFactory<String, String, Iterable<String>> gabwFactory) throws Exception {
        WindowingStrategy windowingStrategy = WindowingStrategy.of((WindowFn)Sessions.withGapDuration((Duration)Duration.millis((long)10L))).withOutputTimeFn(OutputTimeFns.outputAtEndOfWindow());
        DoFnTester<KV<String, Iterable<WindowedValue<String>>>, KV<String, Iterable<String>>> result = GroupAlsoByWindowsProperties.runGABW(gabwFactory, windowingStrategy, "k", WindowedValue.of((Object)"v1", (Instant)new Instant(0L), Arrays.asList(GroupAlsoByWindowsProperties.window(0L, 10L)), (PaneInfo)PaneInfo.NO_FIRING), WindowedValue.of((Object)"v2", (Instant)new Instant(5L), Arrays.asList(GroupAlsoByWindowsProperties.window(5L, 15L)), (PaneInfo)PaneInfo.NO_FIRING), WindowedValue.of((Object)"v3", (Instant)new Instant(15L), Arrays.asList(GroupAlsoByWindowsProperties.window(15L, 25L)), (PaneInfo)PaneInfo.NO_FIRING));
        Assert.assertThat((Object)result.peekOutputElements(), (Matcher)Matchers.hasSize((int)2));
        TimestampedValue item0 = (TimestampedValue)Iterables.getOnlyElement((Iterable)result.peekOutputElementsInWindow(GroupAlsoByWindowsProperties.window(0L, 15L)));
        Assert.assertThat((Object)((KV)item0.getValue()).getValue(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"v1", "v2"}));
        Assert.assertThat((Object)item0.getTimestamp(), (Matcher)Matchers.equalTo((Object)GroupAlsoByWindowsProperties.window(0L, 15L).maxTimestamp()));
        TimestampedValue item1 = (TimestampedValue)Iterables.getOnlyElement((Iterable)result.peekOutputElementsInWindow(GroupAlsoByWindowsProperties.window(15L, 25L)));
        Assert.assertThat((Object)((KV)item1.getValue()).getValue(), (Matcher)Matchers.contains((Object[])new String[]{"v3"}));
        Assert.assertThat((Object)item1.getTimestamp(), (Matcher)Matchers.equalTo((Object)GroupAlsoByWindowsProperties.window(15L, 25L).maxTimestamp()));
    }

    public static void groupsElementsInMergedSessionsWithLatestTimestamp(GroupAlsoByWindowsDoFnFactory<String, String, Iterable<String>> gabwFactory) throws Exception {
        WindowingStrategy windowingStrategy = WindowingStrategy.of((WindowFn)Sessions.withGapDuration((Duration)Duration.millis((long)10L))).withOutputTimeFn(OutputTimeFns.outputAtLatestInputTimestamp());
        BoundedWindow unmergedWindow = GroupAlsoByWindowsProperties.window(15L, 25L);
        DoFnTester<KV<String, Iterable<WindowedValue<String>>>, KV<String, Iterable<String>>> result = GroupAlsoByWindowsProperties.runGABW(gabwFactory, windowingStrategy, "k", WindowedValue.of((Object)"v1", (Instant)new Instant(0L), Arrays.asList(GroupAlsoByWindowsProperties.window(0L, 10L)), (PaneInfo)PaneInfo.NO_FIRING), WindowedValue.of((Object)"v2", (Instant)new Instant(5L), Arrays.asList(GroupAlsoByWindowsProperties.window(5L, 15L)), (PaneInfo)PaneInfo.NO_FIRING), WindowedValue.of((Object)"v3", (Instant)new Instant(15L), Arrays.asList(unmergedWindow), (PaneInfo)PaneInfo.NO_FIRING));
        Assert.assertThat((Object)result.peekOutputElements(), (Matcher)Matchers.hasSize((int)2));
        BoundedWindow mergedWindow = GroupAlsoByWindowsProperties.window(0L, 15L);
        TimestampedValue item0 = (TimestampedValue)Iterables.getOnlyElement((Iterable)result.peekOutputElementsInWindow(mergedWindow));
        Assert.assertThat((Object)((KV)item0.getValue()).getValue(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"v1", "v2"}));
        Assert.assertThat((Object)item0.getTimestamp(), (Matcher)Matchers.equalTo((Object)new Instant(5L)));
        TimestampedValue item1 = (TimestampedValue)Iterables.getOnlyElement((Iterable)result.peekOutputElementsInWindow(unmergedWindow));
        Assert.assertThat((Object)((KV)item1.getValue()).getValue(), (Matcher)Matchers.contains((Object[])new String[]{"v3"}));
        Assert.assertThat((Object)item1.getTimestamp(), (Matcher)Matchers.equalTo((Object)new Instant(15L)));
    }

    public static void combinesElementsPerSessionWithEndOfWindowTimestamp(GroupAlsoByWindowsDoFnFactory<String, Long, Long> gabwFactory, Combine.CombineFn<Long, ?, Long> combineFn) throws Exception {
        WindowingStrategy windowingStrategy = WindowingStrategy.of((WindowFn)Sessions.withGapDuration((Duration)Duration.millis((long)10L))).withOutputTimeFn(OutputTimeFns.outputAtEndOfWindow());
        BoundedWindow secondWindow = GroupAlsoByWindowsProperties.window(15L, 25L);
        DoFnTester<KV<String, Iterable<WindowedValue<Long>>>, KV<String, Long>> result = GroupAlsoByWindowsProperties.runGABW(gabwFactory, windowingStrategy, "k", WindowedValue.of((Object)1L, (Instant)new Instant(0L), Arrays.asList(GroupAlsoByWindowsProperties.window(0L, 10L)), (PaneInfo)PaneInfo.NO_FIRING), WindowedValue.of((Object)2L, (Instant)new Instant(5L), Arrays.asList(GroupAlsoByWindowsProperties.window(5L, 15L)), (PaneInfo)PaneInfo.NO_FIRING), WindowedValue.of((Object)4L, (Instant)new Instant(15L), Arrays.asList(secondWindow), (PaneInfo)PaneInfo.NO_FIRING));
        Assert.assertThat((Object)result.peekOutputElements(), (Matcher)Matchers.hasSize((int)2));
        BoundedWindow firstResultWindow = GroupAlsoByWindowsProperties.window(0L, 15L);
        TimestampedValue item0 = (TimestampedValue)Iterables.getOnlyElement((Iterable)result.peekOutputElementsInWindow(firstResultWindow));
        Assert.assertThat((Object)((KV)item0.getValue()).getValue(), (Matcher)Matchers.equalTo((Object)combineFn.apply((Iterable)ImmutableList.of((Object)1L, (Object)2L))));
        Assert.assertThat((Object)item0.getTimestamp(), (Matcher)Matchers.equalTo((Object)firstResultWindow.maxTimestamp()));
        TimestampedValue item1 = (TimestampedValue)Iterables.getOnlyElement((Iterable)result.peekOutputElementsInWindow(secondWindow));
        Assert.assertThat((Object)((KV)item1.getValue()).getValue(), (Matcher)Matchers.equalTo((Object)combineFn.apply((Iterable)ImmutableList.of((Object)4L))));
        Assert.assertThat((Object)item1.getTimestamp(), (Matcher)Matchers.equalTo((Object)secondWindow.maxTimestamp()));
    }

    @SafeVarargs
    private static <K, InputT, OutputT, W extends BoundedWindow> DoFnTester<KV<K, Iterable<WindowedValue<InputT>>>, KV<K, OutputT>> runGABW(GroupAlsoByWindowsDoFnFactory<K, InputT, OutputT> gabwFactory, WindowingStrategy<?, W> windowingStrategy, K key, WindowedValue<InputT> ... values) throws Exception {
        return GroupAlsoByWindowsProperties.runGABW(gabwFactory, windowingStrategy, key, Arrays.asList(values));
    }

    private static <K, InputT, OutputT, W extends BoundedWindow> DoFnTester<KV<K, Iterable<WindowedValue<InputT>>>, KV<K, OutputT>> runGABW(GroupAlsoByWindowsDoFnFactory<K, InputT, OutputT> gabwFactory, WindowingStrategy<?, W> windowingStrategy, K key, Collection<WindowedValue<InputT>> values) throws Exception {
        CachingStateInternalsFactory stateInternalsCache = new CachingStateInternalsFactory();
        DoFnTester tester = DoFnTester.of(gabwFactory.forStrategy(windowingStrategy, stateInternalsCache));
        tester.setCloningBehavior(DoFnTester.CloningBehavior.DO_NOT_CLONE);
        tester.startBundle();
        tester.processElement((Object)KV.of(key, values));
        tester.finishBundle();
        for (KV elem : tester.peekOutputElements()) {
            Assert.assertThat((Object)elem.getKey(), (Matcher)Matchers.equalTo(key));
        }
        return tester;
    }

    private static BoundedWindow window(long start, long end) {
        return new IntervalWindow(new Instant(start), new Instant(end));
    }

    private static class StateInternalsLoader<K>
    extends CacheLoader<K, StateInternals<K>> {
        private StateInternalsLoader() {
        }

        public StateInternals<K> load(K key) throws Exception {
            return InMemoryStateInternals.forKey(key);
        }
    }

    private static final class CachingStateInternalsFactory<K>
    implements StateInternalsFactory<K> {
        private final LoadingCache<K, StateInternals<K>> stateInternalsCache = CacheBuilder.newBuilder().build(new StateInternalsLoader());

        private CachingStateInternalsFactory() {
        }

        public StateInternals<K> stateInternalsForKey(K key) {
            try {
                return (StateInternals)this.stateInternalsCache.get(key);
            }
            catch (Exception exc) {
                throw new RuntimeException(exc);
            }
        }
    }

    public static interface GroupAlsoByWindowsDoFnFactory<K, InputT, OutputT> {
        public <W extends BoundedWindow> GroupAlsoByWindowsDoFn<K, InputT, OutputT, W> forStrategy(WindowingStrategy<?, W> var1, StateInternalsFactory<K> var2);
    }
}

