/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import org.apache.beam.sdk.util.BatchTimerInternals;
import org.apache.beam.sdk.util.ReduceFnRunner;
import org.apache.beam.sdk.util.TimeDomain;
import org.apache.beam.sdk.util.TimerInternals;
import org.apache.beam.sdk.util.state.StateNamespace;
import org.apache.beam.sdk.util.state.StateNamespaceForTest;
import org.joda.time.Instant;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class BatchTimerInternalsTest {
    private static final StateNamespace NS1 = new StateNamespaceForTest("NS1");
    @Mock
    private ReduceFnRunner<?, ?, ?, ?> mockRunner;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testFiringTimers() throws Exception {
        BatchTimerInternals underTest = new BatchTimerInternals(new Instant(0L));
        TimerInternals.TimerData processingTime1 = TimerInternals.TimerData.of((StateNamespace)NS1, (Instant)new Instant(19L), (TimeDomain)TimeDomain.PROCESSING_TIME);
        TimerInternals.TimerData processingTime2 = TimerInternals.TimerData.of((StateNamespace)NS1, (Instant)new Instant(29L), (TimeDomain)TimeDomain.PROCESSING_TIME);
        underTest.setTimer(processingTime1);
        underTest.setTimer(processingTime2);
        underTest.advanceProcessingTime(this.mockRunner, new Instant(20L));
        ((ReduceFnRunner)Mockito.verify(this.mockRunner)).onTimer(processingTime1);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockRunner});
        underTest.advanceProcessingTime(this.mockRunner, new Instant(21L));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockRunner});
        underTest.setTimer(processingTime1);
        ((ReduceFnRunner)Mockito.verify(this.mockRunner)).onTimer(processingTime1);
        underTest.advanceProcessingTime(this.mockRunner, new Instant(21L));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockRunner});
        underTest.advanceProcessingTime(this.mockRunner, new Instant(30L));
        ((ReduceFnRunner)Mockito.verify(this.mockRunner)).onTimer(processingTime2);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockRunner});
    }

    @Test
    public void testTimerOrdering() throws Exception {
        BatchTimerInternals underTest = new BatchTimerInternals(new Instant(0L));
        TimerInternals.TimerData watermarkTime1 = TimerInternals.TimerData.of((StateNamespace)NS1, (Instant)new Instant(19L), (TimeDomain)TimeDomain.EVENT_TIME);
        TimerInternals.TimerData processingTime1 = TimerInternals.TimerData.of((StateNamespace)NS1, (Instant)new Instant(19L), (TimeDomain)TimeDomain.PROCESSING_TIME);
        TimerInternals.TimerData watermarkTime2 = TimerInternals.TimerData.of((StateNamespace)NS1, (Instant)new Instant(29L), (TimeDomain)TimeDomain.EVENT_TIME);
        TimerInternals.TimerData processingTime2 = TimerInternals.TimerData.of((StateNamespace)NS1, (Instant)new Instant(29L), (TimeDomain)TimeDomain.PROCESSING_TIME);
        underTest.setTimer(processingTime1);
        underTest.setTimer(watermarkTime1);
        underTest.setTimer(processingTime2);
        underTest.setTimer(watermarkTime2);
        underTest.advanceInputWatermark(this.mockRunner, new Instant(30L));
        ((ReduceFnRunner)Mockito.verify(this.mockRunner)).onTimer(watermarkTime1);
        ((ReduceFnRunner)Mockito.verify(this.mockRunner)).onTimer(watermarkTime2);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockRunner});
        underTest.advanceProcessingTime(this.mockRunner, new Instant(30L));
        ((ReduceFnRunner)Mockito.verify(this.mockRunner)).onTimer(processingTime1);
        ((ReduceFnRunner)Mockito.verify(this.mockRunner)).onTimer(processingTime2);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockRunner});
    }

    @Test
    public void testDeduplicate() throws Exception {
        BatchTimerInternals underTest = new BatchTimerInternals(new Instant(0L));
        TimerInternals.TimerData watermarkTime = TimerInternals.TimerData.of((StateNamespace)NS1, (Instant)new Instant(19L), (TimeDomain)TimeDomain.EVENT_TIME);
        TimerInternals.TimerData processingTime = TimerInternals.TimerData.of((StateNamespace)NS1, (Instant)new Instant(19L), (TimeDomain)TimeDomain.PROCESSING_TIME);
        underTest.setTimer(watermarkTime);
        underTest.setTimer(watermarkTime);
        underTest.setTimer(processingTime);
        underTest.setTimer(processingTime);
        underTest.advanceProcessingTime(this.mockRunner, new Instant(20L));
        underTest.advanceInputWatermark(this.mockRunner, new Instant(20L));
        ((ReduceFnRunner)Mockito.verify(this.mockRunner)).onTimer(processingTime);
        ((ReduceFnRunner)Mockito.verify(this.mockRunner)).onTimer(watermarkTime);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockRunner});
    }
}

