package org.apache.beam.model.jobmanagement.v1;

import static io.grpc.stub.ClientCalls.asyncUnaryCall;
import static io.grpc.stub.ClientCalls.asyncServerStreamingCall;
import static io.grpc.stub.ClientCalls.asyncClientStreamingCall;
import static io.grpc.stub.ClientCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ClientCalls.blockingUnaryCall;
import static io.grpc.stub.ClientCalls.blockingServerStreamingCall;
import static io.grpc.stub.ClientCalls.futureUnaryCall;
import static io.grpc.MethodDescriptor.generateFullMethodName;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall;

/**
 * <pre>
 * A service to stage artifacts for use in a Job.
 * RPCs made to an ArtifactStagingService endpoint should include some form of identification for
 * the job as a header.
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.2.0)",
    comments = "Source: beam_artifact_api.proto")
public final class ArtifactStagingServiceGrpc {

  private ArtifactStagingServiceGrpc() {}

  public static final String SERVICE_NAME = "org.apache.beam.model.job_management.v1.ArtifactStagingService";

  // Static method descriptors that strictly reflect the proto.
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<org.apache.beam.model.jobmanagement.v1.ArtifactApi.PutArtifactRequest,
      org.apache.beam.model.jobmanagement.v1.ArtifactApi.PutArtifactResponse> METHOD_PUT_ARTIFACT =
      io.grpc.MethodDescriptor.create(
          io.grpc.MethodDescriptor.MethodType.CLIENT_STREAMING,
          generateFullMethodName(
              "org.apache.beam.model.job_management.v1.ArtifactStagingService", "PutArtifact"),
          io.grpc.protobuf.ProtoUtils.marshaller(org.apache.beam.model.jobmanagement.v1.ArtifactApi.PutArtifactRequest.getDefaultInstance()),
          io.grpc.protobuf.ProtoUtils.marshaller(org.apache.beam.model.jobmanagement.v1.ArtifactApi.PutArtifactResponse.getDefaultInstance()));
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<org.apache.beam.model.jobmanagement.v1.ArtifactApi.CommitManifestRequest,
      org.apache.beam.model.jobmanagement.v1.ArtifactApi.CommitManifestResponse> METHOD_COMMIT_MANIFEST =
      io.grpc.MethodDescriptor.create(
          io.grpc.MethodDescriptor.MethodType.UNARY,
          generateFullMethodName(
              "org.apache.beam.model.job_management.v1.ArtifactStagingService", "CommitManifest"),
          io.grpc.protobuf.ProtoUtils.marshaller(org.apache.beam.model.jobmanagement.v1.ArtifactApi.CommitManifestRequest.getDefaultInstance()),
          io.grpc.protobuf.ProtoUtils.marshaller(org.apache.beam.model.jobmanagement.v1.ArtifactApi.CommitManifestResponse.getDefaultInstance()));

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static ArtifactStagingServiceStub newStub(io.grpc.Channel channel) {
    return new ArtifactStagingServiceStub(channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static ArtifactStagingServiceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    return new ArtifactStagingServiceBlockingStub(channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary and streaming output calls on the service
   */
  public static ArtifactStagingServiceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    return new ArtifactStagingServiceFutureStub(channel);
  }

  /**
   * <pre>
   * A service to stage artifacts for use in a Job.
   * RPCs made to an ArtifactStagingService endpoint should include some form of identification for
   * the job as a header.
   * </pre>
   */
  public static abstract class ArtifactStagingServiceImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * Stage an artifact to be available during job execution. The first request must contain the
     * name of the artifact. All future requests must contain sequential chunks of the content of
     * the artifact.
     * </pre>
     */
    public io.grpc.stub.StreamObserver<org.apache.beam.model.jobmanagement.v1.ArtifactApi.PutArtifactRequest> putArtifact(
        io.grpc.stub.StreamObserver<org.apache.beam.model.jobmanagement.v1.ArtifactApi.PutArtifactResponse> responseObserver) {
      return asyncUnimplementedStreamingCall(METHOD_PUT_ARTIFACT, responseObserver);
    }

    /**
     * <pre>
     * Commit the manifest for a Job. All artifacts must have been successfully uploaded
     * before this call is made.
     * Throws error INVALID_ARGUMENT if not all of the members of the manifest are present
     * </pre>
     */
    public void commitManifest(org.apache.beam.model.jobmanagement.v1.ArtifactApi.CommitManifestRequest request,
        io.grpc.stub.StreamObserver<org.apache.beam.model.jobmanagement.v1.ArtifactApi.CommitManifestResponse> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_COMMIT_MANIFEST, responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            METHOD_PUT_ARTIFACT,
            asyncClientStreamingCall(
              new MethodHandlers<
                org.apache.beam.model.jobmanagement.v1.ArtifactApi.PutArtifactRequest,
                org.apache.beam.model.jobmanagement.v1.ArtifactApi.PutArtifactResponse>(
                  this, METHODID_PUT_ARTIFACT)))
          .addMethod(
            METHOD_COMMIT_MANIFEST,
            asyncUnaryCall(
              new MethodHandlers<
                org.apache.beam.model.jobmanagement.v1.ArtifactApi.CommitManifestRequest,
                org.apache.beam.model.jobmanagement.v1.ArtifactApi.CommitManifestResponse>(
                  this, METHODID_COMMIT_MANIFEST)))
          .build();
    }
  }

  /**
   * <pre>
   * A service to stage artifacts for use in a Job.
   * RPCs made to an ArtifactStagingService endpoint should include some form of identification for
   * the job as a header.
   * </pre>
   */
  public static final class ArtifactStagingServiceStub extends io.grpc.stub.AbstractStub<ArtifactStagingServiceStub> {
    private ArtifactStagingServiceStub(io.grpc.Channel channel) {
      super(channel);
    }

    private ArtifactStagingServiceStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected ArtifactStagingServiceStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new ArtifactStagingServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     * Stage an artifact to be available during job execution. The first request must contain the
     * name of the artifact. All future requests must contain sequential chunks of the content of
     * the artifact.
     * </pre>
     */
    public io.grpc.stub.StreamObserver<org.apache.beam.model.jobmanagement.v1.ArtifactApi.PutArtifactRequest> putArtifact(
        io.grpc.stub.StreamObserver<org.apache.beam.model.jobmanagement.v1.ArtifactApi.PutArtifactResponse> responseObserver) {
      return asyncClientStreamingCall(
          getChannel().newCall(METHOD_PUT_ARTIFACT, getCallOptions()), responseObserver);
    }

    /**
     * <pre>
     * Commit the manifest for a Job. All artifacts must have been successfully uploaded
     * before this call is made.
     * Throws error INVALID_ARGUMENT if not all of the members of the manifest are present
     * </pre>
     */
    public void commitManifest(org.apache.beam.model.jobmanagement.v1.ArtifactApi.CommitManifestRequest request,
        io.grpc.stub.StreamObserver<org.apache.beam.model.jobmanagement.v1.ArtifactApi.CommitManifestResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(METHOD_COMMIT_MANIFEST, getCallOptions()), request, responseObserver);
    }
  }

  /**
   * <pre>
   * A service to stage artifacts for use in a Job.
   * RPCs made to an ArtifactStagingService endpoint should include some form of identification for
   * the job as a header.
   * </pre>
   */
  public static final class ArtifactStagingServiceBlockingStub extends io.grpc.stub.AbstractStub<ArtifactStagingServiceBlockingStub> {
    private ArtifactStagingServiceBlockingStub(io.grpc.Channel channel) {
      super(channel);
    }

    private ArtifactStagingServiceBlockingStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected ArtifactStagingServiceBlockingStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new ArtifactStagingServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * Commit the manifest for a Job. All artifacts must have been successfully uploaded
     * before this call is made.
     * Throws error INVALID_ARGUMENT if not all of the members of the manifest are present
     * </pre>
     */
    public org.apache.beam.model.jobmanagement.v1.ArtifactApi.CommitManifestResponse commitManifest(org.apache.beam.model.jobmanagement.v1.ArtifactApi.CommitManifestRequest request) {
      return blockingUnaryCall(
          getChannel(), METHOD_COMMIT_MANIFEST, getCallOptions(), request);
    }
  }

  /**
   * <pre>
   * A service to stage artifacts for use in a Job.
   * RPCs made to an ArtifactStagingService endpoint should include some form of identification for
   * the job as a header.
   * </pre>
   */
  public static final class ArtifactStagingServiceFutureStub extends io.grpc.stub.AbstractStub<ArtifactStagingServiceFutureStub> {
    private ArtifactStagingServiceFutureStub(io.grpc.Channel channel) {
      super(channel);
    }

    private ArtifactStagingServiceFutureStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected ArtifactStagingServiceFutureStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new ArtifactStagingServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * Commit the manifest for a Job. All artifacts must have been successfully uploaded
     * before this call is made.
     * Throws error INVALID_ARGUMENT if not all of the members of the manifest are present
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<org.apache.beam.model.jobmanagement.v1.ArtifactApi.CommitManifestResponse> commitManifest(
        org.apache.beam.model.jobmanagement.v1.ArtifactApi.CommitManifestRequest request) {
      return futureUnaryCall(
          getChannel().newCall(METHOD_COMMIT_MANIFEST, getCallOptions()), request);
    }
  }

  private static final int METHODID_COMMIT_MANIFEST = 0;
  private static final int METHODID_PUT_ARTIFACT = 1;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final ArtifactStagingServiceImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(ArtifactStagingServiceImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_COMMIT_MANIFEST:
          serviceImpl.commitManifest((org.apache.beam.model.jobmanagement.v1.ArtifactApi.CommitManifestRequest) request,
              (io.grpc.stub.StreamObserver<org.apache.beam.model.jobmanagement.v1.ArtifactApi.CommitManifestResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_PUT_ARTIFACT:
          return (io.grpc.stub.StreamObserver<Req>) serviceImpl.putArtifact(
              (io.grpc.stub.StreamObserver<org.apache.beam.model.jobmanagement.v1.ArtifactApi.PutArtifactResponse>) responseObserver);
        default:
          throw new AssertionError();
      }
    }
  }

  private static final class ArtifactStagingServiceDescriptorSupplier implements io.grpc.protobuf.ProtoFileDescriptorSupplier {
    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return org.apache.beam.model.jobmanagement.v1.ArtifactApi.getDescriptor();
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (ArtifactStagingServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new ArtifactStagingServiceDescriptorSupplier())
              .addMethod(METHOD_PUT_ARTIFACT)
              .addMethod(METHOD_COMMIT_MANIFEST)
              .build();
        }
      }
    }
    return result;
  }
}
