package org.apache.beam.model.jobmanagement.v1;

import static io.grpc.stub.ClientCalls.asyncUnaryCall;
import static io.grpc.stub.ClientCalls.asyncServerStreamingCall;
import static io.grpc.stub.ClientCalls.asyncClientStreamingCall;
import static io.grpc.stub.ClientCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ClientCalls.blockingUnaryCall;
import static io.grpc.stub.ClientCalls.blockingServerStreamingCall;
import static io.grpc.stub.ClientCalls.futureUnaryCall;
import static io.grpc.MethodDescriptor.generateFullMethodName;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall;

/**
 * <pre>
 * A service to retrieve artifacts for use in a Job.
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.2.0)",
    comments = "Source: beam_artifact_api.proto")
public final class ArtifactRetrievalServiceGrpc {

  private ArtifactRetrievalServiceGrpc() {}

  public static final String SERVICE_NAME = "org.apache.beam.model.job_management.v1.ArtifactRetrievalService";

  // Static method descriptors that strictly reflect the proto.
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<org.apache.beam.model.jobmanagement.v1.ArtifactApi.GetManifestRequest,
      org.apache.beam.model.jobmanagement.v1.ArtifactApi.GetManifestResponse> METHOD_GET_MANIFEST =
      io.grpc.MethodDescriptor.create(
          io.grpc.MethodDescriptor.MethodType.UNARY,
          generateFullMethodName(
              "org.apache.beam.model.job_management.v1.ArtifactRetrievalService", "GetManifest"),
          io.grpc.protobuf.ProtoUtils.marshaller(org.apache.beam.model.jobmanagement.v1.ArtifactApi.GetManifestRequest.getDefaultInstance()),
          io.grpc.protobuf.ProtoUtils.marshaller(org.apache.beam.model.jobmanagement.v1.ArtifactApi.GetManifestResponse.getDefaultInstance()));
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<org.apache.beam.model.jobmanagement.v1.ArtifactApi.GetArtifactRequest,
      org.apache.beam.model.jobmanagement.v1.ArtifactApi.ArtifactChunk> METHOD_GET_ARTIFACT =
      io.grpc.MethodDescriptor.create(
          io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING,
          generateFullMethodName(
              "org.apache.beam.model.job_management.v1.ArtifactRetrievalService", "GetArtifact"),
          io.grpc.protobuf.ProtoUtils.marshaller(org.apache.beam.model.jobmanagement.v1.ArtifactApi.GetArtifactRequest.getDefaultInstance()),
          io.grpc.protobuf.ProtoUtils.marshaller(org.apache.beam.model.jobmanagement.v1.ArtifactApi.ArtifactChunk.getDefaultInstance()));

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static ArtifactRetrievalServiceStub newStub(io.grpc.Channel channel) {
    return new ArtifactRetrievalServiceStub(channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static ArtifactRetrievalServiceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    return new ArtifactRetrievalServiceBlockingStub(channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary and streaming output calls on the service
   */
  public static ArtifactRetrievalServiceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    return new ArtifactRetrievalServiceFutureStub(channel);
  }

  /**
   * <pre>
   * A service to retrieve artifacts for use in a Job.
   * </pre>
   */
  public static abstract class ArtifactRetrievalServiceImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * Get the manifest for the job
     * </pre>
     */
    public void getManifest(org.apache.beam.model.jobmanagement.v1.ArtifactApi.GetManifestRequest request,
        io.grpc.stub.StreamObserver<org.apache.beam.model.jobmanagement.v1.ArtifactApi.GetManifestResponse> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_GET_MANIFEST, responseObserver);
    }

    /**
     * <pre>
     * Get an artifact staged for the job. The requested artifact must be within the manifest
     * </pre>
     */
    public void getArtifact(org.apache.beam.model.jobmanagement.v1.ArtifactApi.GetArtifactRequest request,
        io.grpc.stub.StreamObserver<org.apache.beam.model.jobmanagement.v1.ArtifactApi.ArtifactChunk> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_GET_ARTIFACT, responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            METHOD_GET_MANIFEST,
            asyncUnaryCall(
              new MethodHandlers<
                org.apache.beam.model.jobmanagement.v1.ArtifactApi.GetManifestRequest,
                org.apache.beam.model.jobmanagement.v1.ArtifactApi.GetManifestResponse>(
                  this, METHODID_GET_MANIFEST)))
          .addMethod(
            METHOD_GET_ARTIFACT,
            asyncServerStreamingCall(
              new MethodHandlers<
                org.apache.beam.model.jobmanagement.v1.ArtifactApi.GetArtifactRequest,
                org.apache.beam.model.jobmanagement.v1.ArtifactApi.ArtifactChunk>(
                  this, METHODID_GET_ARTIFACT)))
          .build();
    }
  }

  /**
   * <pre>
   * A service to retrieve artifacts for use in a Job.
   * </pre>
   */
  public static final class ArtifactRetrievalServiceStub extends io.grpc.stub.AbstractStub<ArtifactRetrievalServiceStub> {
    private ArtifactRetrievalServiceStub(io.grpc.Channel channel) {
      super(channel);
    }

    private ArtifactRetrievalServiceStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected ArtifactRetrievalServiceStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new ArtifactRetrievalServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     * Get the manifest for the job
     * </pre>
     */
    public void getManifest(org.apache.beam.model.jobmanagement.v1.ArtifactApi.GetManifestRequest request,
        io.grpc.stub.StreamObserver<org.apache.beam.model.jobmanagement.v1.ArtifactApi.GetManifestResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(METHOD_GET_MANIFEST, getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Get an artifact staged for the job. The requested artifact must be within the manifest
     * </pre>
     */
    public void getArtifact(org.apache.beam.model.jobmanagement.v1.ArtifactApi.GetArtifactRequest request,
        io.grpc.stub.StreamObserver<org.apache.beam.model.jobmanagement.v1.ArtifactApi.ArtifactChunk> responseObserver) {
      asyncServerStreamingCall(
          getChannel().newCall(METHOD_GET_ARTIFACT, getCallOptions()), request, responseObserver);
    }
  }

  /**
   * <pre>
   * A service to retrieve artifacts for use in a Job.
   * </pre>
   */
  public static final class ArtifactRetrievalServiceBlockingStub extends io.grpc.stub.AbstractStub<ArtifactRetrievalServiceBlockingStub> {
    private ArtifactRetrievalServiceBlockingStub(io.grpc.Channel channel) {
      super(channel);
    }

    private ArtifactRetrievalServiceBlockingStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected ArtifactRetrievalServiceBlockingStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new ArtifactRetrievalServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * Get the manifest for the job
     * </pre>
     */
    public org.apache.beam.model.jobmanagement.v1.ArtifactApi.GetManifestResponse getManifest(org.apache.beam.model.jobmanagement.v1.ArtifactApi.GetManifestRequest request) {
      return blockingUnaryCall(
          getChannel(), METHOD_GET_MANIFEST, getCallOptions(), request);
    }

    /**
     * <pre>
     * Get an artifact staged for the job. The requested artifact must be within the manifest
     * </pre>
     */
    public java.util.Iterator<org.apache.beam.model.jobmanagement.v1.ArtifactApi.ArtifactChunk> getArtifact(
        org.apache.beam.model.jobmanagement.v1.ArtifactApi.GetArtifactRequest request) {
      return blockingServerStreamingCall(
          getChannel(), METHOD_GET_ARTIFACT, getCallOptions(), request);
    }
  }

  /**
   * <pre>
   * A service to retrieve artifacts for use in a Job.
   * </pre>
   */
  public static final class ArtifactRetrievalServiceFutureStub extends io.grpc.stub.AbstractStub<ArtifactRetrievalServiceFutureStub> {
    private ArtifactRetrievalServiceFutureStub(io.grpc.Channel channel) {
      super(channel);
    }

    private ArtifactRetrievalServiceFutureStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected ArtifactRetrievalServiceFutureStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new ArtifactRetrievalServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * Get the manifest for the job
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<org.apache.beam.model.jobmanagement.v1.ArtifactApi.GetManifestResponse> getManifest(
        org.apache.beam.model.jobmanagement.v1.ArtifactApi.GetManifestRequest request) {
      return futureUnaryCall(
          getChannel().newCall(METHOD_GET_MANIFEST, getCallOptions()), request);
    }
  }

  private static final int METHODID_GET_MANIFEST = 0;
  private static final int METHODID_GET_ARTIFACT = 1;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final ArtifactRetrievalServiceImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(ArtifactRetrievalServiceImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_GET_MANIFEST:
          serviceImpl.getManifest((org.apache.beam.model.jobmanagement.v1.ArtifactApi.GetManifestRequest) request,
              (io.grpc.stub.StreamObserver<org.apache.beam.model.jobmanagement.v1.ArtifactApi.GetManifestResponse>) responseObserver);
          break;
        case METHODID_GET_ARTIFACT:
          serviceImpl.getArtifact((org.apache.beam.model.jobmanagement.v1.ArtifactApi.GetArtifactRequest) request,
              (io.grpc.stub.StreamObserver<org.apache.beam.model.jobmanagement.v1.ArtifactApi.ArtifactChunk>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static final class ArtifactRetrievalServiceDescriptorSupplier implements io.grpc.protobuf.ProtoFileDescriptorSupplier {
    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return org.apache.beam.model.jobmanagement.v1.ArtifactApi.getDescriptor();
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (ArtifactRetrievalServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new ArtifactRetrievalServiceDescriptorSupplier())
              .addMethod(METHOD_GET_MANIFEST)
              .addMethod(METHOD_GET_ARTIFACT)
              .build();
        }
      }
    }
    return result;
  }
}
