/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.kotlin.snippets;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.api.services.bigquery.model.TimePartitioning;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.beam.examples.kotlin.snippets.Snippets;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.coders.DoubleCoder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.io.gcp.bigquery.WriteResult;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.join.CoGbkResult;
import org.apache.beam.sdk.transforms.join.CoGroupByKey;
import org.apache.beam.sdk.transforms.join.KeyedPCollectionTuple;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.sdk.values.ValueInSingleWindow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0016\u0017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\\\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\u0018\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\n0\u00042\u0018\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\n0\u0004J,\u0010\f\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u000e2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eJ.\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00052\b\b\u0002\u0010\u0014\u001a\u00020\u00052\b\b\u0002\u0010\u0015\u001a\u00020\u0005H\u0007\u00a8\u0006\u0018"}, d2={"Lorg/apache/beam/examples/kotlin/snippets/Snippets;", "", "()V", "coGroupByKeyTuple", "Lorg/apache/beam/sdk/values/PCollection;", "", "emailsTag", "Lorg/apache/beam/sdk/values/TupleTag;", "phonesTag", "emails", "Lorg/apache/beam/sdk/values/KV;", "phones", "formatCoGbkResults", "name", "", "modelBigQueryIO", "", "pipeline", "Lorg/apache/beam/sdk/Pipeline;", "writeProject", "writeDataset", "writeTable", "Quote", "WeatherData", "beam-examples-kotlin"})
public final class Snippets {
    public static final Snippets INSTANCE;

    @JvmOverloads
    @SuppressFBWarnings(value={"SE_BAD_FIELD"})
    public final void modelBigQueryIO(@NotNull Pipeline pipeline, @NotNull String writeProject, @NotNull String writeDataset, @NotNull String writeTable) {
        Snippets snippets;
        Snippets snippets2;
        Intrinsics.checkParameterIsNotNull((Object)pipeline, (String)"pipeline");
        Intrinsics.checkParameterIsNotNull((Object)writeProject, (String)"writeProject");
        Intrinsics.checkParameterIsNotNull((Object)writeDataset, (String)"writeDataset");
        Intrinsics.checkParameterIsNotNull((Object)writeTable, (String)"writeTable");
        Snippets $receiver = snippets2 = this;
        boolean bl = false;
        String string = "clouddataflow-readonly:samples.weather_stations";
        $receiver = snippets2 = this;
        boolean bl2 = false;
        string = "samples.weather_stations";
        $receiver = snippets2 = this;
        boolean bl3 = false;
        string = new TableReference().setProjectId("clouddataflow-readonly").setDatasetId("samples").setTableId("weather_stations");
        $receiver = snippets2 = this;
        boolean bl4 = false;
        String tableSpec = "clouddataflow-readonly:samples.weather_stations";
        PCollection pCollection = (PCollection)((PCollection)pipeline.apply((PTransform)BigQueryIO.readTableRows().from(tableSpec))).apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.doubles()).via((SerializableFunction)modelBigQueryIO.4.maxTemperatures.1.INSTANCE));
        $receiver = snippets2 = this;
        boolean bl5 = false;
        tableSpec = "clouddataflow-readonly:samples.weather_stations";
        pCollection = (PCollection)pipeline.apply((PTransform)BigQueryIO.read((SerializableFunction)modelBigQueryIO.5.maxTemperatures.1.INSTANCE).from(tableSpec).withCoder((Coder)DoubleCoder.of()));
        $receiver = snippets2 = this;
        boolean bl6 = false;
        tableSpec = (PCollection)pipeline.apply((PTransform)BigQueryIO.read((SerializableFunction)modelBigQueryIO.6.maxTemperatures.1.INSTANCE).fromQuery("SELECT max_temperature FROM [clouddataflow-readonly:samples.weather_stations]").withCoder((Coder)DoubleCoder.of()));
        $receiver = snippets2 = this;
        boolean bl7 = false;
        tableSpec = (PCollection)pipeline.apply((PTransform)BigQueryIO.read((SerializableFunction)modelBigQueryIO.7.maxTemperatures.1.INSTANCE).fromQuery("SELECT max_temperature FROM `clouddataflow-readonly.samples.weather_stations`").usingStandardSql().withCoder((Coder)DoubleCoder.of()));
        String tableSchemaJson = "{  \"fields\": [    {      \"name\": \"source\",      \"type\": \"STRING\",      \"mode\": \"NULLABLE\"    },    {      \"name\": \"quote\",      \"type\": \"STRING\",      \"mode\": \"REQUIRED\"    }  ]}";
        Snippets $receiver2 = snippets = this;
        boolean bl8 = false;
        String tableSpec2 = "clouddataflow-readonly:samples.weather_stations";
        CharSequence charSequence = writeProject;
        if (charSequence.length() > 0 && (charSequence = (CharSequence)writeDataset).length() > 0 && (charSequence = (CharSequence)writeTable).length() > 0) {
            tableSpec2 = writeProject + ':' + writeDataset + '.' + writeTable;
        }
        TableSchema tableSchema = new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("source").setType("STRING").setMode("NULLABLE"), (Object)new TableFieldSchema().setName("quote").setType("STRING").setMode("REQUIRED")));
        Object quotes = (PCollection)pipeline.apply((PTransform)Create.of((Object)new Quote("Mahatma Gandhi", "My life is my message."), (Object[])new Quote[]{new Quote("Yoda", "Do, or do not. There is no 'try'.")}));
        ((PCollection)quotes.apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptor.of(TableRow.class)).via((SerializableFunction)modelBigQueryIO.8.1.INSTANCE))).apply((PTransform)BigQueryIO.writeTableRows().to(tableSpec2).withSchema(tableSchema).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_TRUNCATE));
        quotes.apply((PTransform)BigQueryIO.write().to(tableSpec2).withSchema(tableSchema).withFormatFunction((SerializableFunction)modelBigQueryIO.8.2.INSTANCE).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_TRUNCATE));
        WriteResult cfr_ignored_0 = (WriteResult)quotes.apply((PTransform)BigQueryIO.write().to(tableSpec2).withJsonSchema(tableSchemaJson).withFormatFunction((SerializableFunction)modelBigQueryIO.8.3.INSTANCE).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_TRUNCATE));
        $receiver2 = snippets = this;
        boolean bl9 = false;
        PCollection weatherData2 = (PCollection)pipeline.apply((PTransform)BigQueryIO.read((SerializableFunction)modelBigQueryIO.9.weatherData.1.INSTANCE).fromQuery(StringsKt.trimIndent((String)"\n                                SELECT year, month, day, max_temperature\n                                FROM [clouddataflow-readonly:samples.weather_stations]\n                                WHERE year BETWEEN 2007 AND 2009\n                            ")).withCoder((Coder)AvroCoder.of(WeatherData.class)));
        weatherData2.apply((PTransform)BigQueryIO.write().to((DynamicDestinations)new DynamicDestinations<WeatherData, Long>(pipeline, writeProject, writeDataset, writeTable){
            final /* synthetic */ Pipeline $pipeline$inlined;
            final /* synthetic */ String $writeProject$inlined;
            final /* synthetic */ String $writeDataset$inlined;
            final /* synthetic */ String $writeTable$inlined;
            {
                this.$pipeline$inlined = pipeline;
                this.$writeProject$inlined = string;
                this.$writeDataset$inlined = string2;
                this.$writeTable$inlined = string3;
            }

            @Nullable
            public Long getDestination(@NotNull ValueInSingleWindow<WeatherData> elem) {
                Intrinsics.checkParameterIsNotNull(elem, (String)"elem");
                Object object = elem.getValue();
                if (object == null) {
                    Intrinsics.throwNpe();
                }
                return ((WeatherData)object).getYear();
            }

            @NotNull
            public TableDestination getTable(@Nullable Long destination) {
                return new TableDestination(new TableReference().setProjectId(this.$writeProject$inlined).setDatasetId(this.$writeDataset$inlined).setTableId(this.$writeTable$inlined + '_' + destination), "Table for year " + destination);
            }

            @NotNull
            public TableSchema getSchema(@Nullable Long destination) {
                TableSchema tableSchema = new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("year").setType("INTEGER").setMode("REQUIRED"), (Object)new TableFieldSchema().setName("month").setType("INTEGER").setMode("REQUIRED"), (Object)new TableFieldSchema().setName("day").setType("INTEGER").setMode("REQUIRED"), (Object)new TableFieldSchema().setName("maxTemp").setType("FLOAT").setMode("NULLABLE")));
                Intrinsics.checkExpressionValueIsNotNull((Object)tableSchema, (String)"TableSchema()\n          \u2026   .setMode(\"NULLABLE\")))");
                return tableSchema;
            }
        }).withFormatFunction((SerializableFunction)modelBigQueryIO.9.2.INSTANCE).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_TRUNCATE));
        String tableSpec3 = "clouddataflow-readonly:samples.weather_stations";
        quotes = writeProject;
        if (quotes.length() > 0 && (quotes = (CharSequence)writeDataset).length() > 0 && (quotes = (CharSequence)writeTable).length() > 0) {
            tableSpec3 = writeProject + ':' + writeDataset + '.' + writeTable + "_partitioning";
        }
        TableSchema tableSchema2 = new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("year").setType("INTEGER").setMode("REQUIRED"), (Object)new TableFieldSchema().setName("month").setType("INTEGER").setMode("REQUIRED"), (Object)new TableFieldSchema().setName("day").setType("INTEGER").setMode("REQUIRED"), (Object)new TableFieldSchema().setName("maxTemp").setType("FLOAT").setMode("NULLABLE")));
        WriteResult cfr_ignored_1 = (WriteResult)weatherData2.apply((PTransform)BigQueryIO.write().to(tableSpec3 + "_partitioning").withSchema(tableSchema2).withFormatFunction((SerializableFunction)modelBigQueryIO.9.3.INSTANCE).withTimePartitioning(new TimePartitioning().setType("DAY")).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_TRUNCATE));
    }

    @JvmOverloads
    @SuppressFBWarnings(value={"SE_BAD_FIELD"})
    public static /* synthetic */ void modelBigQueryIO$default(Snippets snippets, Pipeline pipeline, String string, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        if ((n & 4) != 0) {
            string2 = "";
        }
        if ((n & 8) != 0) {
            string3 = "";
        }
        snippets.modelBigQueryIO(pipeline, string, string2, string3);
    }

    @JvmOverloads
    @SuppressFBWarnings(value={"SE_BAD_FIELD"})
    public final void modelBigQueryIO(@NotNull Pipeline pipeline, @NotNull String writeProject, @NotNull String writeDataset) {
        Snippets.modelBigQueryIO$default(this, pipeline, writeProject, writeDataset, null, 8, null);
    }

    @JvmOverloads
    @SuppressFBWarnings(value={"SE_BAD_FIELD"})
    public final void modelBigQueryIO(@NotNull Pipeline pipeline, @NotNull String writeProject) {
        Snippets.modelBigQueryIO$default(this, pipeline, writeProject, null, null, 12, null);
    }

    @JvmOverloads
    @SuppressFBWarnings(value={"SE_BAD_FIELD"})
    public final void modelBigQueryIO(@NotNull Pipeline pipeline) {
        Snippets.modelBigQueryIO$default(this, pipeline, null, null, null, 14, null);
    }

    @NotNull
    public final String formatCoGbkResults(@Nullable String name, @NotNull Iterable<String> emails, @NotNull Iterable<String> phones) {
        Intrinsics.checkParameterIsNotNull(emails, (String)"emails");
        Intrinsics.checkParameterIsNotNull(phones, (String)"phones");
        ArrayList<String> emailsList = new ArrayList<String>();
        for (String elem : emails) {
            emailsList.add('\'' + elem + '\'');
        }
        CollectionsKt.sort((List)emailsList);
        String emailsStr = '[' + CollectionsKt.joinToString$default((Iterable)emailsList, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + ']';
        ArrayList<String> phonesList = new ArrayList<String>();
        for (String elem : phones) {
            phonesList.add('\'' + elem + '\'');
        }
        CollectionsKt.sort((List)phonesList);
        String phonesStr = '[' + CollectionsKt.joinToString$default((Iterable)phonesList, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + ']';
        return name + "; " + emailsStr + "; " + phonesStr;
    }

    @NotNull
    public final PCollection<String> coGroupByKeyTuple(@NotNull TupleTag<String> emailsTag, @NotNull TupleTag<String> phonesTag, @NotNull PCollection<KV<String, String>> emails, @NotNull PCollection<KV<String, String>> phones) {
        Intrinsics.checkParameterIsNotNull(emailsTag, (String)"emailsTag");
        Intrinsics.checkParameterIsNotNull(phonesTag, (String)"phonesTag");
        Intrinsics.checkParameterIsNotNull(emails, (String)"emails");
        Intrinsics.checkParameterIsNotNull(phones, (String)"phones");
        PCollection results2 = (PCollection)KeyedPCollectionTuple.of(emailsTag, emails).and(phonesTag, phones).apply((PTransform)CoGroupByKey.create());
        POutput pOutput = results2.apply((PTransform)ParDo.of((DoFn)((DoFn)new DoFn<KV<String, CoGbkResult>, String>(emailsTag, phonesTag){
            final /* synthetic */ TupleTag $emailsTag;
            final /* synthetic */ TupleTag $phonesTag;

            @DoFn.ProcessElement
            public final void processElement(@NotNull DoFn.ProcessContext c) {
                KV e;
                Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
                KV kV = e = (KV)c.element();
                Intrinsics.checkExpressionValueIsNotNull((Object)kV, (String)"e");
                String name = (String)kV.getKey();
                Iterable emailsIter = ((CoGbkResult)e.getValue()).getAll(this.$emailsTag);
                Iterable phonesIter = ((CoGbkResult)e.getValue()).getAll(this.$phonesTag);
                Iterable iterable = emailsIter;
                Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"emailsIter");
                Iterable iterable2 = phonesIter;
                Intrinsics.checkExpressionValueIsNotNull((Object)iterable2, (String)"phonesIter");
                String formattedResult = Snippets.INSTANCE.formatCoGbkResults(name, iterable, iterable2);
                c.output((Object)formattedResult);
            }
            {
                this.$emailsTag = $captured_local_variable$0;
                this.$phonesTag = $captured_local_variable$1;
            }
        })));
        Intrinsics.checkExpressionValueIsNotNull((Object)pOutput, (String)"results.apply(\n         \u2026                      }))");
        return (PCollection)pOutput;
    }

    private Snippets() {
    }

    static {
        Snippets snippets;
        INSTANCE = snippets = new Snippets();
    }

    @DefaultCoder(value=AvroCoder.class)
    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0001\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\t"}, d2={"Lorg/apache/beam/examples/kotlin/snippets/Snippets$Quote;", "", "source", "", "quote", "(Ljava/lang/String;Ljava/lang/String;)V", "getQuote", "()Ljava/lang/String;", "getSource", "beam-examples-kotlin"})
    public static final class Quote {
        @NotNull
        private final String source;
        @NotNull
        private final String quote;

        @NotNull
        public final String getSource() {
            return this.source;
        }

        @NotNull
        public final String getQuote() {
            return this.quote;
        }

        public Quote(@NotNull String source, @NotNull String quote) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            Intrinsics.checkParameterIsNotNull((Object)quote, (String)"quote");
            this.source = source;
            this.quote = quote;
        }

        public /* synthetic */ Quote(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "";
            }
            if ((n & 2) != 0) {
                string2 = "";
            }
            this(string, string2);
        }

        public Quote() {
            this(null, null, 3, null);
        }
    }

    @DefaultCoder(value=AvroCoder.class)
    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\b\b\u0001\u0018\u00002\u00020\u0001B-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u000f"}, d2={"Lorg/apache/beam/examples/kotlin/snippets/Snippets$WeatherData;", "", "year", "", "month", "day", "maxTemp", "", "(JJJD)V", "getDay", "()J", "getMaxTemp", "()D", "getMonth", "getYear", "beam-examples-kotlin"})
    public static final class WeatherData {
        private final long year;
        private final long month;
        private final long day;
        private final double maxTemp;

        public final long getYear() {
            return this.year;
        }

        public final long getMonth() {
            return this.month;
        }

        public final long getDay() {
            return this.day;
        }

        public final double getMaxTemp() {
            return this.maxTemp;
        }

        public WeatherData(long year, long month, long day, double maxTemp) {
            this.year = year;
            this.month = month;
            this.day = day;
            this.maxTemp = maxTemp;
        }

        public /* synthetic */ WeatherData(long l, long l2, long l3, double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                l = 0L;
            }
            if ((n & 2) != 0) {
                l2 = 0L;
            }
            if ((n & 4) != 0) {
                l3 = 0L;
            }
            if ((n & 8) != 0) {
                d = 0.0;
            }
            this(l, l2, l3, d);
        }

        public WeatherData() {
            this(0L, 0L, 0L, 0.0, 15, null);
        }
    }
}

