/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.kotlin.cookbook;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.apache.beam.examples.kotlin.common.ExampleBigQueryTableOptions;
import org.apache.beam.examples.kotlin.common.ExampleOptions;
import org.apache.beam.examples.kotlin.common.ExampleUtils;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.StreamingOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.windowing.AfterEach;
import org.apache.beam.sdk.transforms.windowing.AfterProcessingTime;
import org.apache.beam.sdk.transforms.windowing.AfterWatermark;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.transforms.windowing.Repeatedly;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.POutput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.Duration;
import org.joda.time.Instant;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0006\u001f !\"#$B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J\u001b\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u001aH\u0007\u00a2\u0006\u0002\u0010\u001bJ\u0017\u0010\u001c\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001d\u001a\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010\u001eR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006%"}, d2={"Lorg/apache/beam/examples/kotlin/cookbook/TriggerExample;", "", "()V", "FIVE_MINUTES", "Lorg/joda/time/Duration;", "getFIVE_MINUTES", "()Lorg/joda/time/Duration;", "ONE_DAY", "getONE_DAY", "ONE_MINUTE", "getONE_MINUTE", "WINDOW_DURATION", "", "schema", "Lcom/google/api/services/bigquery/model/TableSchema;", "getSchema", "()Lcom/google/api/services/bigquery/model/TableSchema;", "getTableReference", "Lcom/google/api/services/bigquery/model/TableReference;", "project", "", "dataset", "table", "main", "", "args", "", "([Ljava/lang/String;)V", "tryIntegerParse", "number", "(Ljava/lang/String;)Ljava/lang/Integer;", "CalculateTotalFlow", "ExtractFlowInfo", "FormatTotalFlow", "InsertDelays", "TotalFlow", "TrafficFlowOptions", "beam-examples-kotlin"})
public final class TriggerExample {
    public static final int WINDOW_DURATION = 30;
    @NotNull
    private static final Duration ONE_MINUTE;
    @NotNull
    private static final Duration FIVE_MINUTES;
    @NotNull
    private static final Duration ONE_DAY;
    public static final TriggerExample INSTANCE;

    @NotNull
    public final Duration getONE_MINUTE() {
        return ONE_MINUTE;
    }

    @NotNull
    public final Duration getFIVE_MINUTES() {
        return FIVE_MINUTES;
    }

    @NotNull
    public final Duration getONE_DAY() {
        return ONE_DAY;
    }

    private final TableSchema getSchema() {
        Object[] objectArray = new TableFieldSchema[10];
        TableFieldSchema tableFieldSchema = new TableFieldSchema().setName("trigger_type").setType("STRING");
        Intrinsics.checkExpressionValueIsNotNull((Object)tableFieldSchema, (String)"TableFieldSchema().setNa\u2026_type\").setType(\"STRING\")");
        objectArray[0] = tableFieldSchema;
        TableFieldSchema tableFieldSchema2 = new TableFieldSchema().setName("freeway").setType("STRING");
        Intrinsics.checkExpressionValueIsNotNull((Object)tableFieldSchema2, (String)"TableFieldSchema().setNa\u2026eeway\").setType(\"STRING\")");
        objectArray[1] = tableFieldSchema2;
        TableFieldSchema tableFieldSchema3 = new TableFieldSchema().setName("total_flow").setType("INTEGER");
        Intrinsics.checkExpressionValueIsNotNull((Object)tableFieldSchema3, (String)"TableFieldSchema().setNa\u2026flow\").setType(\"INTEGER\")");
        objectArray[2] = tableFieldSchema3;
        TableFieldSchema tableFieldSchema4 = new TableFieldSchema().setName("number_of_records").setType("INTEGER");
        Intrinsics.checkExpressionValueIsNotNull((Object)tableFieldSchema4, (String)"TableFieldSchema().setNa\u2026ords\").setType(\"INTEGER\")");
        objectArray[3] = tableFieldSchema4;
        TableFieldSchema tableFieldSchema5 = new TableFieldSchema().setName("window").setType("STRING");
        Intrinsics.checkExpressionValueIsNotNull((Object)tableFieldSchema5, (String)"TableFieldSchema().setNa\u2026indow\").setType(\"STRING\")");
        objectArray[4] = tableFieldSchema5;
        TableFieldSchema tableFieldSchema6 = new TableFieldSchema().setName("isFirst").setType("BOOLEAN");
        Intrinsics.checkExpressionValueIsNotNull((Object)tableFieldSchema6, (String)"TableFieldSchema().setNa\u2026irst\").setType(\"BOOLEAN\")");
        objectArray[5] = tableFieldSchema6;
        TableFieldSchema tableFieldSchema7 = new TableFieldSchema().setName("isLast").setType("BOOLEAN");
        Intrinsics.checkExpressionValueIsNotNull((Object)tableFieldSchema7, (String)"TableFieldSchema().setNa\u2026Last\").setType(\"BOOLEAN\")");
        objectArray[6] = tableFieldSchema7;
        TableFieldSchema tableFieldSchema8 = new TableFieldSchema().setName("timing").setType("STRING");
        Intrinsics.checkExpressionValueIsNotNull((Object)tableFieldSchema8, (String)"TableFieldSchema().setNa\u2026iming\").setType(\"STRING\")");
        objectArray[7] = tableFieldSchema8;
        TableFieldSchema tableFieldSchema9 = new TableFieldSchema().setName("event_time").setType("TIMESTAMP");
        Intrinsics.checkExpressionValueIsNotNull((Object)tableFieldSchema9, (String)"TableFieldSchema().setNa\u2026me\").setType(\"TIMESTAMP\")");
        objectArray[8] = tableFieldSchema9;
        TableFieldSchema tableFieldSchema10 = new TableFieldSchema().setName("processing_time").setType("TIMESTAMP");
        Intrinsics.checkExpressionValueIsNotNull((Object)tableFieldSchema10, (String)"TableFieldSchema().setNa\u2026me\").setType(\"TIMESTAMP\")");
        objectArray[9] = tableFieldSchema10;
        ArrayList fields = CollectionsKt.arrayListOf((Object[])objectArray);
        TableSchema tableSchema = new TableSchema().setFields((List)fields);
        Intrinsics.checkExpressionValueIsNotNull((Object)tableSchema, (String)"TableSchema().setFields(fields)");
        return tableSchema;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void main(@NotNull String[] args) throws Exception {
        PipelineResult result;
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        PipelineOptionsFactory.Builder builder = PipelineOptionsFactory.fromArgs((String[])Arrays.copyOf(args, args.length)).withValidation();
        if (builder == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.apache.beam.examples.kotlin.cookbook.TriggerExample.TrafficFlowOptions");
        }
        TrafficFlowOptions options = (TrafficFlowOptions)builder;
        options.setStreaming(true);
        options.setBigQuerySchema(INSTANCE.getSchema());
        ExampleUtils exampleUtils = new ExampleUtils(options);
        exampleUtils.setup();
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        String string = options.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"options.project");
        TableReference tableRef = INSTANCE.getTableReference(string, options.getBigQueryDataset(), options.getBigQueryTable());
        PCollection pCollection = (PCollection)((PCollection)((PCollection)pipeline.apply("ReadMyFile", (PTransform)TextIO.read().from(options.getInput()))).apply("InsertRandomDelays", (PTransform)ParDo.of((DoFn)new InsertDelays()))).apply((PTransform)ParDo.of((DoFn)new ExtractFlowInfo()));
        Integer n = options.getWindowDuration();
        if (n == null) {
            Intrinsics.throwNpe();
        }
        PCollectionList resultList = (PCollectionList)pCollection.apply((PTransform)new CalculateTotalFlow(n));
        int n2 = 0;
        int n3 = resultList.size();
        while (n2 < n3) {
            void i;
            resultList.get((int)i).apply((PTransform)BigQueryIO.writeTableRows().to(tableRef).withSchema(INSTANCE.getSchema()));
            ++i;
        }
        PipelineResult pipelineResult = result = pipeline.run();
        Intrinsics.checkExpressionValueIsNotNull((Object)pipelineResult, (String)"result");
        exampleUtils.waitToFinish(pipelineResult);
    }

    private final TableReference getTableReference(String project, String dataset, String table) {
        TableReference tableReference;
        TableReference $receiver = tableReference = new TableReference();
        boolean bl = false;
        $receiver.setProjectId(project);
        $receiver.setDatasetId(dataset);
        $receiver.setTableId(table);
        return tableReference;
    }

    private final Integer tryIntegerParse(String number) {
        Integer n;
        try {
            n = Integer.parseInt(number);
        }
        catch (NumberFormatException e) {
            n = null;
        }
        return n;
    }

    private TriggerExample() {
    }

    static {
        TriggerExample triggerExample;
        INSTANCE = triggerExample = new TriggerExample();
        Duration duration = Duration.standardMinutes((long)1L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.standardMinutes(1)");
        ONE_MINUTE = duration;
        Duration duration2 = Duration.standardMinutes((long)5L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"Duration.standardMinutes(5)");
        FIVE_MINUTES = duration2;
        Duration duration3 = Duration.standardDays((long)1L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration3, (String)"Duration.standardDays(1)");
        ONE_DAY = duration3;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002&\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00030\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0001B\r\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ(\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0018\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00030\u0002H\u0016R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/apache/beam/examples/kotlin/cookbook/TriggerExample$CalculateTotalFlow;", "Lorg/apache/beam/sdk/transforms/PTransform;", "Lorg/apache/beam/sdk/values/PCollection;", "Lorg/apache/beam/sdk/values/KV;", "", "", "Lorg/apache/beam/sdk/values/PCollectionList;", "Lcom/google/api/services/bigquery/model/TableRow;", "windowDuration", "(I)V", "expand", "flowInfo", "beam-examples-kotlin"})
    public static final class CalculateTotalFlow
    extends PTransform<PCollection<KV<String, Integer>>, PCollectionList<TableRow>> {
        private final int windowDuration;

        @NotNull
        public PCollectionList<TableRow> expand(@NotNull PCollection<KV<String, Integer>> flowInfo) {
            Intrinsics.checkParameterIsNotNull(flowInfo, (String)"flowInfo");
            PCollection defaultTriggerResults = (PCollection)((PCollection)flowInfo.apply("Default", (PTransform)Window.into((WindowFn)((WindowFn)FixedWindows.of((Duration)Duration.standardMinutes((long)this.windowDuration)))).triggering((Trigger)Repeatedly.forever((Trigger)((Trigger)AfterWatermark.pastEndOfWindow()))).withAllowedLateness(Duration.ZERO).discardingFiredPanes())).apply((PTransform)new TotalFlow("default"));
            PCollection withAllowedLatenessResults = (PCollection)((PCollection)flowInfo.apply("WithLateData", (PTransform)Window.into((WindowFn)((WindowFn)FixedWindows.of((Duration)Duration.standardMinutes((long)this.windowDuration)))).triggering((Trigger)Repeatedly.forever((Trigger)((Trigger)AfterWatermark.pastEndOfWindow()))).discardingFiredPanes().withAllowedLateness(INSTANCE.getONE_DAY()))).apply((PTransform)new TotalFlow("withAllowedLateness"));
            PCollection speculativeResults = (PCollection)((PCollection)flowInfo.apply("Speculative", (PTransform)Window.into((WindowFn)((WindowFn)FixedWindows.of((Duration)Duration.standardMinutes((long)this.windowDuration)))).triggering((Trigger)Repeatedly.forever((Trigger)((Trigger)AfterProcessingTime.pastFirstElementInPane().plusDelayOf(INSTANCE.getONE_MINUTE())))).accumulatingFiredPanes().withAllowedLateness(INSTANCE.getONE_DAY()))).apply((PTransform)new TotalFlow("speculative"));
            PCollection sequentialResults = (PCollection)((PCollection)flowInfo.apply("Sequential", (PTransform)Window.into((WindowFn)((WindowFn)FixedWindows.of((Duration)Duration.standardMinutes((long)this.windowDuration)))).triggering((Trigger)AfterEach.inOrder((Trigger[])new Trigger[]{(Trigger)Repeatedly.forever((Trigger)((Trigger)AfterProcessingTime.pastFirstElementInPane().plusDelayOf(INSTANCE.getONE_MINUTE()))).orFinally((Trigger.OnceTrigger)AfterWatermark.pastEndOfWindow()), (Trigger)Repeatedly.forever((Trigger)((Trigger)AfterProcessingTime.pastFirstElementInPane().plusDelayOf(INSTANCE.getFIVE_MINUTES())))})).accumulatingFiredPanes().withAllowedLateness(INSTANCE.getONE_DAY()))).apply((PTransform)new TotalFlow("sequential"));
            PCollectionList pCollectionList = PCollectionList.of((PCollection)defaultTriggerResults).and(withAllowedLatenessResults).and(speculativeResults).and(sequentialResults);
            Intrinsics.checkExpressionValueIsNotNull((Object)pCollectionList, (String)"PCollectionList.of<Table\u2026  .and(sequentialResults)");
            return pCollectionList;
        }

        public CalculateTotalFlow(int windowDuration) {
            this.windowDuration = windowDuration;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002&\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00030\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00020\u0001B\r\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\bJ(\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00022\u0018\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00030\u0002H\u0016R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/apache/beam/examples/kotlin/cookbook/TriggerExample$TotalFlow;", "Lorg/apache/beam/sdk/transforms/PTransform;", "Lorg/apache/beam/sdk/values/PCollection;", "Lorg/apache/beam/sdk/values/KV;", "", "", "Lcom/google/api/services/bigquery/model/TableRow;", "triggerType", "(Ljava/lang/String;)V", "expand", "flowInfo", "beam-examples-kotlin"})
    public static final class TotalFlow
    extends PTransform<PCollection<KV<String, Integer>>, PCollection<TableRow>> {
        private final String triggerType;

        @NotNull
        public PCollection<TableRow> expand(@NotNull PCollection<KV<String, Integer>> flowInfo) {
            Intrinsics.checkParameterIsNotNull(flowInfo, (String)"flowInfo");
            PCollection flowPerFreeway = (PCollection)flowInfo.apply((PTransform)GroupByKey.create());
            PCollection results2 = (PCollection)flowPerFreeway.apply((PTransform)ParDo.of((DoFn)((DoFn)new DoFn<KV<String, Iterable<? extends Integer>>, KV<String, String>>(){

                @DoFn.ProcessElement
                public final void processElement(@NotNull DoFn.ProcessContext c) throws Exception {
                    Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
                    Object object = c.element();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"c.element()");
                    Iterable flows = (Iterable)((KV)object).getValue();
                    int sum = 0;
                    long numberOfRecords = 0L;
                    Iterator<T> iterator = flows.iterator();
                    while (iterator.hasNext()) {
                        int value = ((Number)iterator.next()).intValue();
                        sum += value;
                        long l = numberOfRecords;
                        numberOfRecords = l + 1L;
                    }
                    Object object2 = c.element();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"c.element()");
                    c.output((Object)KV.of((Object)((KV)object2).getKey(), (Object)("" + sum + ',' + numberOfRecords)));
                }
            })));
            POutput pOutput = results2.apply((PTransform)ParDo.of((DoFn)new FormatTotalFlow(this.triggerType)));
            Intrinsics.checkExpressionValueIsNotNull((Object)pOutput, (String)"results.apply(ParDo.of(F\u2026tTotalFlow(triggerType)))");
            return (PCollection)pOutput;
        }

        public TotalFlow(@NotNull String triggerType) {
            Intrinsics.checkParameterIsNotNull((Object)triggerType, (String)"triggerType");
            this.triggerType = triggerType;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u0001B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J4\u0010\u0007\u001a\u00020\b2\"\u0010\t\u001a\u001e0\nR\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0007R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/apache/beam/examples/kotlin/cookbook/TriggerExample$FormatTotalFlow;", "Lorg/apache/beam/sdk/transforms/DoFn;", "Lorg/apache/beam/sdk/values/KV;", "", "Lcom/google/api/services/bigquery/model/TableRow;", "triggerType", "(Ljava/lang/String;)V", "processElement", "", "c", "Lorg/apache/beam/sdk/transforms/DoFn$ProcessContext;", "window", "Lorg/apache/beam/sdk/transforms/windowing/BoundedWindow;", "beam-examples-kotlin"})
    public static final class FormatTotalFlow
    extends DoFn<KV<String, String>, TableRow> {
        private final String triggerType;

        /*
         * WARNING - void declaration
         */
        @DoFn.ProcessElement
        public final void processElement(@NotNull DoFn.ProcessContext c, @NotNull BoundedWindow window) throws Exception {
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
            Intrinsics.checkParameterIsNotNull((Object)window, (String)"window");
            Object object = c.element();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"c.element()");
            Object object2 = ((KV)object).getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"c.element().value");
            Object object3 = (CharSequence)object2;
            String string = ",";
            string = new Regex(string);
            int n = 0;
            object3 = string.split((CharSequence)object3, n);
            void v2 = $receiver$iv;
            if (v2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            void thisCollection$iv = v2;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] values = stringArray;
            TableRow tableRow = new TableRow().set("trigger_type", (Object)this.triggerType);
            Object object4 = c.element();
            Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"c.element()");
            TableRow tableRow2 = tableRow.set("freeway", ((KV)object4).getKey()).set("total_flow", (Object)Integer.parseInt(values[0])).set("number_of_records", (Object)Long.parseLong(values[1])).set("window", (Object)window.toString());
            PaneInfo paneInfo = c.pane();
            Intrinsics.checkExpressionValueIsNotNull((Object)paneInfo, (String)"c.pane()");
            TableRow tableRow3 = tableRow2.set("isFirst", (Object)paneInfo.isFirst());
            PaneInfo paneInfo2 = c.pane();
            Intrinsics.checkExpressionValueIsNotNull((Object)paneInfo2, (String)"c.pane()");
            TableRow tableRow4 = tableRow3.set("isLast", (Object)paneInfo2.isLast());
            PaneInfo paneInfo3 = c.pane();
            Intrinsics.checkExpressionValueIsNotNull((Object)paneInfo3, (String)"c.pane()");
            TableRow row = tableRow4.set("timing", (Object)paneInfo3.getTiming().toString()).set("event_time", (Object)c.timestamp().toString()).set("processing_time", (Object)Instant.now().toString());
            c.output((Object)row);
        }

        public FormatTotalFlow(@NotNull String triggerType) {
            Intrinsics.checkParameterIsNotNull((Object)triggerType, (String)"triggerType");
            this.triggerType = triggerType;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \n2\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00040\u00030\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0005J,\u0010\u0006\u001a\u00020\u00072\"\u0010\b\u001a\u001e0\tR\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00040\u00030\u0001H\u0007\u00a8\u0006\u000b"}, d2={"Lorg/apache/beam/examples/kotlin/cookbook/TriggerExample$ExtractFlowInfo;", "Lorg/apache/beam/sdk/transforms/DoFn;", "", "Lorg/apache/beam/sdk/values/KV;", "", "()V", "processElement", "", "c", "Lorg/apache/beam/sdk/transforms/DoFn$ProcessContext;", "Companion", "beam-examples-kotlin"})
    public static final class ExtractFlowInfo
    extends DoFn<String, KV<String, Integer>> {
        private static final int VALID_NUM_FIELDS = 50;
        public static final Companion Companion = new Companion(null);

        @DoFn.ProcessElement
        public final void processElement(@NotNull DoFn.ProcessContext c) throws Exception {
            Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
            Object object = c.element();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"c.element()");
            CharSequence charSequence = (CharSequence)object;
            String string = ",";
            string = new Regex(string);
            int n = 0;
            Collection $receiver$iv = string.split(charSequence, n);
            Collection collection = $receiver$iv;
            if (collection == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection thisCollection$iv = collection;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] laneInfo = stringArray;
            if (Intrinsics.areEqual((Object)"timestamp", (Object)laneInfo[0])) {
                return;
            }
            if (laneInfo.length < 50) {
                return;
            }
            String freeway = laneInfo[2];
            Integer totalFlow = INSTANCE.tryIntegerParse(laneInfo[7]);
            if (totalFlow == null || totalFlow <= 0) {
                return;
            }
            c.output((Object)KV.of((Object)freeway, (Object)totalFlow));
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/apache/beam/examples/kotlin/cookbook/TriggerExample$ExtractFlowInfo$Companion;", "", "()V", "VALID_NUM_FIELDS", "", "beam-examples-kotlin"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\bf\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003R\u001a\u0010\u0004\u001a\u00020\u00058gX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000b8gX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/apache/beam/examples/kotlin/cookbook/TriggerExample$TrafficFlowOptions;", "Lorg/apache/beam/examples/kotlin/common/ExampleOptions;", "Lorg/apache/beam/examples/kotlin/common/ExampleBigQueryTableOptions;", "Lorg/apache/beam/sdk/options/StreamingOptions;", "input", "", "getInput", "()Ljava/lang/String;", "setInput", "(Ljava/lang/String;)V", "windowDuration", "", "getWindowDuration", "()Ljava/lang/Integer;", "setWindowDuration", "(Ljava/lang/Integer;)V", "beam-examples-kotlin"})
    public static interface TrafficFlowOptions
    extends ExampleOptions,
    ExampleBigQueryTableOptions,
    StreamingOptions {
        @Description(value="Input file to read from")
        @Default.String(value="gs://apache-beam-samples/traffic_sensor/Freeways-5Minaa2010-01-01_to_2010-02-15.csv")
        @NotNull
        public String getInput();

        public void setInput(@NotNull String var1);

        @Description(value="Numeric value of window duration for fixed windows, in minutes")
        @Default.Integer(value=30)
        @Nullable
        public Integer getWindowDuration();

        public void setWindowDuration(@Nullable Integer var1);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \b2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0016\u0010\u0006\u001a\u00120\u0007R\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001H\u0007\u00a8\u0006\t"}, d2={"Lorg/apache/beam/examples/kotlin/cookbook/TriggerExample$InsertDelays;", "Lorg/apache/beam/sdk/transforms/DoFn;", "", "()V", "processElement", "", "c", "Lorg/apache/beam/sdk/transforms/DoFn$ProcessContext;", "Companion", "beam-examples-kotlin"})
    public static final class InsertDelays
    extends DoFn<String, String> {
        private static final double THRESHOLD = 0.001;
        private static final int MIN_DELAY = 1;
        private static final int MAX_DELAY = 100;
        public static final Companion Companion = new Companion(null);

        @DoFn.ProcessElement
        public final void processElement(@NotNull DoFn.ProcessContext c) throws Exception {
            Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
            Instant timestamp = Instant.now();
            Random random = new Random();
            if (random.nextDouble() < 0.001) {
                int range = 99;
                int delayInMinutes = random.nextInt(range) + 1;
                long delayInMillis = TimeUnit.MINUTES.toMillis(delayInMinutes);
                Instant instant = timestamp;
                Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"timestamp");
                timestamp = new Instant(instant.getMillis() - delayInMillis);
            }
            c.outputWithTimestamp(c.element(), timestamp);
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/apache/beam/examples/kotlin/cookbook/TriggerExample$InsertDelays$Companion;", "", "()V", "MAX_DELAY", "", "MIN_DELAY", "THRESHOLD", "", "beam-examples-kotlin"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

