/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.kotlin.cookbook;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.Validation;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Max;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.POutput;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004\n\u000b\f\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0007\u00a2\u0006\u0002\u0010\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/apache/beam/examples/kotlin/cookbook/MaxPerKeyExamples;", "", "()V", "WEATHER_SAMPLES_TABLE", "", "main", "", "args", "", "([Ljava/lang/String;)V", "ExtractTempFn", "FormatMaxesFn", "MaxMeanTemp", "Options", "beam-examples-kotlin"})
public final class MaxPerKeyExamples {
    private static final String WEATHER_SAMPLES_TABLE = "clouddataflow-readonly:samples.weather_stations";
    public static final MaxPerKeyExamples INSTANCE;

    @JvmStatic
    public static final void main(@NotNull String[] args) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        PipelineOptionsFactory.Builder builder = PipelineOptionsFactory.fromArgs((String[])Arrays.copyOf(args, args.length)).withValidation();
        if (builder == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.apache.beam.examples.kotlin.cookbook.MaxPerKeyExamples.Options");
        }
        Options options = (Options)builder;
        Pipeline p = Pipeline.create((PipelineOptions)options);
        Object[] objectArray = new TableFieldSchema[2];
        TableFieldSchema tableFieldSchema = new TableFieldSchema().setName("month").setType("INTEGER");
        Intrinsics.checkExpressionValueIsNotNull((Object)tableFieldSchema, (String)"TableFieldSchema().setNa\u2026onth\").setType(\"INTEGER\")");
        objectArray[0] = tableFieldSchema;
        TableFieldSchema tableFieldSchema2 = new TableFieldSchema().setName("max_mean_temp").setType("FLOAT");
        Intrinsics.checkExpressionValueIsNotNull((Object)tableFieldSchema2, (String)"TableFieldSchema().setNa\u2026n_temp\").setType(\"FLOAT\")");
        objectArray[1] = tableFieldSchema2;
        ArrayList fields = CollectionsKt.arrayListOf((Object[])objectArray);
        TableSchema schema = new TableSchema().setFields((List)fields);
        ((PCollection)((PCollection)p.apply((PTransform)BigQueryIO.readTableRows().from(options.getInput()))).apply((PTransform)new MaxMeanTemp())).apply((PTransform)BigQueryIO.writeTableRows().to(options.getOutput()).withSchema(schema).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_TRUNCATE));
        p.run().waitUntilFinish();
    }

    private MaxPerKeyExamples() {
    }

    static {
        MaxPerKeyExamples maxPerKeyExamples;
        INSTANCE = maxPerKeyExamples = new MaxPerKeyExamples();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0006J,\u0010\u0007\u001a\u00020\b2\"\u0010\t\u001a\u001e0\nR\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00030\u0001H\u0007\u00a8\u0006\u000b"}, d2={"Lorg/apache/beam/examples/kotlin/cookbook/MaxPerKeyExamples$ExtractTempFn;", "Lorg/apache/beam/sdk/transforms/DoFn;", "Lcom/google/api/services/bigquery/model/TableRow;", "Lorg/apache/beam/sdk/values/KV;", "", "", "()V", "processElement", "", "c", "Lorg/apache/beam/sdk/transforms/DoFn$ProcessContext;", "beam-examples-kotlin"})
    public static final class ExtractTempFn
    extends DoFn<TableRow, KV<Integer, Double>> {
        @DoFn.ProcessElement
        public final void processElement(@NotNull DoFn.ProcessContext c) {
            Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
            TableRow row = (TableRow)c.element();
            Object object = row.get((Object)"month");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            int month = Integer.parseInt((String)object);
            double meanTemp = Double.parseDouble(String.valueOf(row.get((Object)"mean_temp")));
            c.output((Object)KV.of((Object)month, (Object)meanTemp));
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002\u0012\u0004\u0012\u00020\u00050\u0001B\u0005\u00a2\u0006\u0002\u0010\u0006J,\u0010\u0007\u001a\u00020\b2\"\u0010\t\u001a\u001e0\nR\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002\u0012\u0004\u0012\u00020\u00050\u0001H\u0007\u00a8\u0006\u000b"}, d2={"Lorg/apache/beam/examples/kotlin/cookbook/MaxPerKeyExamples$FormatMaxesFn;", "Lorg/apache/beam/sdk/transforms/DoFn;", "Lorg/apache/beam/sdk/values/KV;", "", "", "Lcom/google/api/services/bigquery/model/TableRow;", "()V", "processElement", "", "c", "Lorg/apache/beam/sdk/transforms/DoFn$ProcessContext;", "beam-examples-kotlin"})
    public static final class FormatMaxesFn
    extends DoFn<KV<Integer, Double>, TableRow> {
        @DoFn.ProcessElement
        public final void processElement(@NotNull DoFn.ProcessContext c) {
            Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
            TableRow tableRow = new TableRow();
            Object object = c.element();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"c.element()");
            TableRow tableRow2 = tableRow.set("month", ((KV)object).getKey());
            Object object2 = c.element();
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"c.element()");
            TableRow row = tableRow2.set("max_mean_temp", ((KV)object2).getValue());
            c.output((Object)row);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/apache/beam/examples/kotlin/cookbook/MaxPerKeyExamples$MaxMeanTemp;", "Lorg/apache/beam/sdk/transforms/PTransform;", "Lorg/apache/beam/sdk/values/PCollection;", "Lcom/google/api/services/bigquery/model/TableRow;", "()V", "expand", "rows", "beam-examples-kotlin"})
    public static final class MaxMeanTemp
    extends PTransform<PCollection<TableRow>, PCollection<TableRow>> {
        @NotNull
        public PCollection<TableRow> expand(@NotNull PCollection<TableRow> rows) {
            Intrinsics.checkParameterIsNotNull(rows, (String)"rows");
            PCollection temps = (PCollection)rows.apply((PTransform)ParDo.of((DoFn)new ExtractTempFn()));
            PCollection tempMaxes = (PCollection)temps.apply((PTransform)Max.doublesPerKey());
            POutput pOutput = tempMaxes.apply((PTransform)ParDo.of((DoFn)new FormatMaxesFn()));
            Intrinsics.checkExpressionValueIsNotNull((Object)pOutput, (String)"tempMaxes.apply(ParDo.of(FormatMaxesFn()))");
            return (PCollection)pOutput;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\bf\u0018\u00002\u00020\u0001R\u001a\u0010\u0002\u001a\u00020\u00038gX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\u00038gX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\u0005\"\u0004\b\n\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lorg/apache/beam/examples/kotlin/cookbook/MaxPerKeyExamples$Options;", "Lorg/apache/beam/sdk/options/PipelineOptions;", "input", "", "getInput", "()Ljava/lang/String;", "setInput", "(Ljava/lang/String;)V", "output", "getOutput", "setOutput", "beam-examples-kotlin"})
    public static interface Options
    extends PipelineOptions {
        @Description(value="Table to read from, specified as <project_id>:<dataset_id>.<table_id>")
        @Default.String(value="clouddataflow-readonly:samples.weather_stations")
        @NotNull
        public String getInput();

        public void setInput(@NotNull String var1);

        @Description(value="Table to write to, specified as <project_id>:<dataset_id>.<table_id>")
        @Validation.Required
        @NotNull
        public String getOutput();

        public void setOutput(@NotNull String var1);
    }
}

