/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.kotlin.cookbook;

import com.google.api.services.bigquery.model.TableRow;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.Validation;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.join.CoGbkResult;
import org.apache.beam.sdk.transforms.join.CoGroupByKey;
import org.apache.beam.sdk.transforms.join.KeyedPCollectionTuple;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.TupleTag;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u0011\u0012\u0013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u0007H\u0000\u00a2\u0006\u0002\b\u000bJ\u001b\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000fH\u0007\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/apache/beam/examples/kotlin/cookbook/JoinExamples;", "", "()V", "COUNTRY_CODES", "", "GDELT_EVENTS_TABLE", "joinEvents", "Lorg/apache/beam/sdk/values/PCollection;", "eventsTable", "Lcom/google/api/services/bigquery/model/TableRow;", "countryCodes", "joinEvents$beam_examples_kotlin", "main", "", "args", "", "([Ljava/lang/String;)V", "ExtractCountryInfoFn", "ExtractEventDataFn", "Options", "beam-examples-kotlin"})
public final class JoinExamples {
    private static final String GDELT_EVENTS_TABLE = "clouddataflow-readonly:samples.gdelt_sample";
    private static final String COUNTRY_CODES = "gdelt-bq:full.crosswalk_geocountrycodetohuman";
    public static final JoinExamples INSTANCE;

    @NotNull
    public final PCollection<String> joinEvents$beam_examples_kotlin(@NotNull PCollection<TableRow> eventsTable, @NotNull PCollection<TableRow> countryCodes) throws Exception {
        Intrinsics.checkParameterIsNotNull(eventsTable, (String)"eventsTable");
        Intrinsics.checkParameterIsNotNull(countryCodes, (String)"countryCodes");
        TupleTag eventInfoTag = new TupleTag();
        TupleTag countryInfoTag = new TupleTag();
        PCollection eventInfo = (PCollection)eventsTable.apply((PTransform)ParDo.of((DoFn)new ExtractEventDataFn()));
        PCollection countryInfo = (PCollection)countryCodes.apply((PTransform)ParDo.of((DoFn)new ExtractCountryInfoFn()));
        PCollection kvpCollection = (PCollection)KeyedPCollectionTuple.of((TupleTag)eventInfoTag, (PCollection)eventInfo).and(countryInfoTag, countryInfo).apply((PTransform)CoGroupByKey.create());
        PCollection finalResultCollection2 = (PCollection)kvpCollection.apply("Process", (PTransform)ParDo.of((DoFn)((DoFn)new DoFn<KV<String, CoGbkResult>, KV<String, String>>(countryInfoTag, eventInfoTag){
            final /* synthetic */ TupleTag $countryInfoTag;
            final /* synthetic */ TupleTag $eventInfoTag;

            @DoFn.ProcessElement
            public final void processElement(@NotNull DoFn.ProcessContext c) {
                KV e;
                Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
                KV kV = e = (KV)c.element();
                Intrinsics.checkExpressionValueIsNotNull((Object)kV, (String)"e");
                String countryCode = (String)kV.getKey();
                String countryName = (String)((CoGbkResult)e.getValue()).getOnly(this.$countryInfoTag);
                Object object = c.element();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"c.element()");
                for (String ei : ((CoGbkResult)((KV)object).getValue()).getAll(this.$eventInfoTag)) {
                    c.output((Object)KV.of((Object)countryCode, (Object)("Country name: " + countryName + ", Event info: " + ei)));
                }
            }
            {
                this.$countryInfoTag = $captured_local_variable$0;
                this.$eventInfoTag = $captured_local_variable$1;
            }
        })));
        POutput pOutput = finalResultCollection2.apply("Format", (PTransform)ParDo.of((DoFn)((DoFn)new DoFn<KV<String, String>, String>(){

            @DoFn.ProcessElement
            public final void processElement(@NotNull DoFn.ProcessContext c) {
                Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
                StringBuilder stringBuilder = new StringBuilder().append("Country code: ");
                Object object = c.element();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"c.element()");
                StringBuilder stringBuilder2 = stringBuilder.append((String)((KV)object).getKey()).append(", ");
                Object object2 = c.element();
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"c.element()");
                String outputString = stringBuilder2.append((String)((KV)object2).getValue()).toString();
                c.output((Object)outputString);
            }
        })));
        Intrinsics.checkExpressionValueIsNotNull((Object)pOutput, (String)"finalResultCollection.ap\u2026                      }))");
        return (PCollection)pOutput;
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        PipelineOptionsFactory.Builder builder = PipelineOptionsFactory.fromArgs((String[])Arrays.copyOf(args, args.length)).withValidation();
        if (builder == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.apache.beam.examples.kotlin.cookbook.JoinExamples.Options");
        }
        Options options = (Options)builder;
        Pipeline p = Pipeline.create((PipelineOptions)options);
        PCollection eventsTable = (PCollection)p.apply((PTransform)BigQueryIO.readTableRows().from(GDELT_EVENTS_TABLE));
        PCollection countryCodes = (PCollection)p.apply((PTransform)BigQueryIO.readTableRows().from(COUNTRY_CODES));
        PCollection pCollection = eventsTable;
        Intrinsics.checkExpressionValueIsNotNull((Object)pCollection, (String)"eventsTable");
        PCollection pCollection2 = countryCodes;
        Intrinsics.checkExpressionValueIsNotNull((Object)pCollection2, (String)"countryCodes");
        PCollection<String> formattedResults = INSTANCE.joinEvents$beam_examples_kotlin((PCollection<TableRow>)pCollection, (PCollection<TableRow>)pCollection2);
        formattedResults.apply((PTransform)TextIO.write().to(options.getOutput()));
        p.run().waitUntilFinish();
    }

    private JoinExamples() {
    }

    static {
        JoinExamples joinExamples;
        INSTANCE = joinExamples = new JoinExamples();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0005J,\u0010\u0006\u001a\u00020\u00072\"\u0010\b\u001a\u001e0\tR\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00030\u0001H\u0007\u00a8\u0006\n"}, d2={"Lorg/apache/beam/examples/kotlin/cookbook/JoinExamples$ExtractEventDataFn;", "Lorg/apache/beam/sdk/transforms/DoFn;", "Lcom/google/api/services/bigquery/model/TableRow;", "Lorg/apache/beam/sdk/values/KV;", "", "()V", "processElement", "", "c", "Lorg/apache/beam/sdk/transforms/DoFn$ProcessContext;", "beam-examples-kotlin"})
    public static final class ExtractEventDataFn
    extends DoFn<TableRow, KV<String, String>> {
        @DoFn.ProcessElement
        public final void processElement(@NotNull DoFn.ProcessContext c) {
            Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
            TableRow row = (TableRow)c.element();
            Object object = row.get((Object)"ActionGeo_CountryCode");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            String countryCode = (String)object;
            Object object2 = row.get((Object)"SQLDATE");
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            String sqlDate = (String)object2;
            Object object3 = row.get((Object)"Actor1Name");
            if (object3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            String actor1Name = (String)object3;
            Object object4 = row.get((Object)"SOURCEURL");
            if (object4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            String sourceUrl = (String)object4;
            String eventInfo = "Date: " + sqlDate + ", Actor1: " + actor1Name + ", url: " + sourceUrl;
            c.output((Object)KV.of((Object)countryCode, (Object)eventInfo));
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0005J,\u0010\u0006\u001a\u00020\u00072\"\u0010\b\u001a\u001e0\tR\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00030\u0001H\u0007\u00a8\u0006\n"}, d2={"Lorg/apache/beam/examples/kotlin/cookbook/JoinExamples$ExtractCountryInfoFn;", "Lorg/apache/beam/sdk/transforms/DoFn;", "Lcom/google/api/services/bigquery/model/TableRow;", "Lorg/apache/beam/sdk/values/KV;", "", "()V", "processElement", "", "c", "Lorg/apache/beam/sdk/transforms/DoFn$ProcessContext;", "beam-examples-kotlin"})
    public static final class ExtractCountryInfoFn
    extends DoFn<TableRow, KV<String, String>> {
        @DoFn.ProcessElement
        public final void processElement(@NotNull DoFn.ProcessContext c) {
            Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
            TableRow row = (TableRow)c.element();
            Object object = row.get((Object)"FIPSCC");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            String countryCode = (String)object;
            Object object2 = row.get((Object)"HumanName");
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            String countryName = (String)object2;
            c.output((Object)KV.of((Object)countryCode, (Object)countryName));
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001R\u001a\u0010\u0002\u001a\u00020\u00038gX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/apache/beam/examples/kotlin/cookbook/JoinExamples$Options;", "Lorg/apache/beam/sdk/options/PipelineOptions;", "output", "", "getOutput", "()Ljava/lang/String;", "setOutput", "(Ljava/lang/String;)V", "beam-examples-kotlin"})
    public static interface Options
    extends PipelineOptions {
        @Description(value="Path of the file to write to")
        @Validation.Required
        @NotNull
        public String getOutput();

        public void setOutput(@NotNull String var1);
    }
}

