/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.kotlin.cookbook;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.Validation;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Mean;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.POutput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0005\u0013\u0014\u0015\u0016\u0017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\f\u001a\u00020\rH\u0002J\u001b\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0011H\u0007\u00a2\u0006\u0002\u0010\u0012R\u001c\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/apache/beam/examples/kotlin/cookbook/FilterExamples;", "", "()V", "LOG", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "getLOG$beam_examples_kotlin", "()Ljava/util/logging/Logger;", "MONTH_TO_FILTER", "", "WEATHER_SAMPLES_TABLE", "", "buildWeatherSchemaProjection", "Lcom/google/api/services/bigquery/model/TableSchema;", "main", "", "args", "", "([Ljava/lang/String;)V", "BelowGlobalMean", "ExtractTempFn", "FilterSingleMonthDataFn", "Options", "ProjectionFn", "beam-examples-kotlin"})
public final class FilterExamples {
    private static final String WEATHER_SAMPLES_TABLE = "clouddataflow-readonly:samples.weather_stations";
    private static final Logger LOG;
    public static final int MONTH_TO_FILTER = 7;
    public static final FilterExamples INSTANCE;

    public final Logger getLOG$beam_examples_kotlin() {
        return LOG;
    }

    private final TableSchema buildWeatherSchemaProjection() {
        Object[] objectArray = new TableFieldSchema[4];
        TableFieldSchema tableFieldSchema = new TableFieldSchema().setName("year").setType("INTEGER");
        Intrinsics.checkExpressionValueIsNotNull((Object)tableFieldSchema, (String)"TableFieldSchema().setNa\u2026year\").setType(\"INTEGER\")");
        objectArray[0] = tableFieldSchema;
        TableFieldSchema tableFieldSchema2 = new TableFieldSchema().setName("month").setType("INTEGER");
        Intrinsics.checkExpressionValueIsNotNull((Object)tableFieldSchema2, (String)"TableFieldSchema().setNa\u2026onth\").setType(\"INTEGER\")");
        objectArray[1] = tableFieldSchema2;
        TableFieldSchema tableFieldSchema3 = new TableFieldSchema().setName("day").setType("INTEGER");
        Intrinsics.checkExpressionValueIsNotNull((Object)tableFieldSchema3, (String)"TableFieldSchema().setNa\u2026\"day\").setType(\"INTEGER\")");
        objectArray[2] = tableFieldSchema3;
        TableFieldSchema tableFieldSchema4 = new TableFieldSchema().setName("mean_temp").setType("FLOAT");
        Intrinsics.checkExpressionValueIsNotNull((Object)tableFieldSchema4, (String)"TableFieldSchema().setNa\u2026n_temp\").setType(\"FLOAT\")");
        objectArray[3] = tableFieldSchema4;
        ArrayList fields = CollectionsKt.arrayListOf((Object[])objectArray);
        TableSchema tableSchema = new TableSchema().setFields((List)fields);
        Intrinsics.checkExpressionValueIsNotNull((Object)tableSchema, (String)"TableSchema().setFields(fields)");
        return tableSchema;
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        PipelineOptionsFactory.Builder builder = PipelineOptionsFactory.fromArgs((String[])Arrays.copyOf(args, args.length)).withValidation();
        if (builder == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.apache.beam.examples.kotlin.cookbook.FilterExamples.Options");
        }
        Options options = (Options)builder;
        Pipeline p = Pipeline.create((PipelineOptions)options);
        TableSchema schema = INSTANCE.buildWeatherSchemaProjection();
        ((PCollection)((PCollection)((PCollection)p.apply((PTransform)BigQueryIO.readTableRows().from(options.getInput()))).apply((PTransform)ParDo.of((DoFn)new ProjectionFn()))).apply((PTransform)new BelowGlobalMean(options.getMonthFilter()))).apply((PTransform)BigQueryIO.writeTableRows().to(options.getOutput()).withSchema(schema).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_TRUNCATE));
        p.run().waitUntilFinish();
    }

    private FilterExamples() {
    }

    static {
        FilterExamples filterExamples;
        INSTANCE = filterExamples = new FilterExamples();
        LOG = Logger.getLogger(FilterExamples.class.getName());
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0016\u0010\u0006\u001a\u00120\u0007R\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001H\u0007\u00a8\u0006\b"}, d2={"Lorg/apache/beam/examples/kotlin/cookbook/FilterExamples$ProjectionFn;", "Lorg/apache/beam/sdk/transforms/DoFn;", "Lcom/google/api/services/bigquery/model/TableRow;", "()V", "processElement", "", "c", "Lorg/apache/beam/sdk/transforms/DoFn$ProcessContext;", "beam-examples-kotlin"})
    public static final class ProjectionFn
    extends DoFn<TableRow, TableRow> {
        @DoFn.ProcessElement
        public final void processElement(@NotNull DoFn.ProcessContext c) {
            Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
            TableRow row = (TableRow)c.element();
            Object object = row.get((Object)"year");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            int year = Integer.parseInt((String)object);
            Object object2 = row.get((Object)"month");
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            int month = Integer.parseInt((String)object2);
            Object object3 = row.get((Object)"day");
            if (object3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            int day = Integer.parseInt((String)object3);
            String string = String.valueOf(row.get((Object)"mean_temp"));
            double meanTemp = Double.parseDouble(string);
            TableRow outRow = new TableRow().set("year", (Object)year).set("month", (Object)month).set("day", (Object)day).set("mean_temp", (Object)meanTemp);
            c.output((Object)outRow);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J \u0010\n\u001a\u00020\u000b2\u0016\u0010\f\u001a\u00120\rR\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001H\u0007R\u001e\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\t\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u0006\u000e"}, d2={"Lorg/apache/beam/examples/kotlin/cookbook/FilterExamples$FilterSingleMonthDataFn;", "Lorg/apache/beam/sdk/transforms/DoFn;", "Lcom/google/api/services/bigquery/model/TableRow;", "monthFilter", "", "(Ljava/lang/Integer;)V", "getMonthFilter", "()Ljava/lang/Integer;", "setMonthFilter", "Ljava/lang/Integer;", "processElement", "", "c", "Lorg/apache/beam/sdk/transforms/DoFn$ProcessContext;", "beam-examples-kotlin"})
    public static final class FilterSingleMonthDataFn
    extends DoFn<TableRow, TableRow> {
        @Nullable
        private Integer monthFilter;

        @DoFn.ProcessElement
        public final void processElement(@NotNull DoFn.ProcessContext c) {
            Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
            TableRow row = (TableRow)c.element();
            Object month = row.get((Object)"month");
            if (Intrinsics.areEqual((Object)month, (Object)this.monthFilter)) {
                c.output((Object)row);
            }
        }

        @Nullable
        public final Integer getMonthFilter() {
            return this.monthFilter;
        }

        public final void setMonthFilter(@Nullable Integer n) {
            this.monthFilter = n;
        }

        public FilterSingleMonthDataFn(@Nullable Integer monthFilter) {
            this.monthFilter = monthFilter;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0016\u0010\u0007\u001a\u00120\bR\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001H\u0007\u00a8\u0006\t"}, d2={"Lorg/apache/beam/examples/kotlin/cookbook/FilterExamples$ExtractTempFn;", "Lorg/apache/beam/sdk/transforms/DoFn;", "Lcom/google/api/services/bigquery/model/TableRow;", "", "()V", "processElement", "", "c", "Lorg/apache/beam/sdk/transforms/DoFn$ProcessContext;", "beam-examples-kotlin"})
    public static final class ExtractTempFn
    extends DoFn<TableRow, Double> {
        @DoFn.ProcessElement
        public final void processElement(@NotNull DoFn.ProcessContext c) {
            Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
            TableRow row = (TableRow)c.element();
            double meanTemp = Double.parseDouble(String.valueOf(row.get((Object)"mean_temp")));
            c.output((Object)meanTemp);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0000\u0018\u00002\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u000f\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016R\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\n\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/apache/beam/examples/kotlin/cookbook/FilterExamples$BelowGlobalMean;", "Lorg/apache/beam/sdk/transforms/PTransform;", "Lorg/apache/beam/sdk/values/PCollection;", "Lcom/google/api/services/bigquery/model/TableRow;", "monthFilter", "", "(Ljava/lang/Integer;)V", "getMonthFilter", "()Ljava/lang/Integer;", "setMonthFilter", "Ljava/lang/Integer;", "expand", "rows", "beam-examples-kotlin"})
    public static final class BelowGlobalMean
    extends PTransform<PCollection<TableRow>, PCollection<TableRow>> {
        @Nullable
        private Integer monthFilter;

        @NotNull
        public PCollection<TableRow> expand(@NotNull PCollection<TableRow> rows) {
            Intrinsics.checkParameterIsNotNull(rows, (String)"rows");
            PCollection meanTemps = (PCollection)rows.apply((PTransform)ParDo.of((DoFn)new ExtractTempFn()));
            PCollectionView globalMeanTemp = (PCollectionView)((PCollection)meanTemps.apply((PTransform)Mean.globally())).apply((PTransform)View.asSingleton());
            PCollection monthFilteredRows = (PCollection)rows.apply((PTransform)ParDo.of((DoFn)new FilterSingleMonthDataFn(this.monthFilter)));
            POutput pOutput = monthFilteredRows.apply("ParseAndFilter", (PTransform)ParDo.of((DoFn)((DoFn)new DoFn<TableRow, TableRow>(globalMeanTemp){
                final /* synthetic */ PCollectionView $globalMeanTemp;

                @DoFn.ProcessElement
                public final void processElement(@NotNull DoFn.ProcessContext c) {
                    Double gTemp;
                    Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
                    double meanTemp = Double.parseDouble(String.valueOf(((TableRow)c.element()).get((Object)"mean_temp")));
                    Double d = gTemp = (Double)c.sideInput(this.$globalMeanTemp);
                    Intrinsics.checkExpressionValueIsNotNull((Object)d, (String)"gTemp");
                    if (meanTemp < d) {
                        c.output(c.element());
                    }
                }
                {
                    this.$globalMeanTemp = $captured_local_variable$0;
                }
            })).withSideInputs(new PCollectionView[]{globalMeanTemp}));
            Intrinsics.checkExpressionValueIsNotNull((Object)pOutput, (String)"monthFilteredRows.apply(\u2026deInputs(globalMeanTemp))");
            return (PCollection)pOutput;
        }

        @Nullable
        public final Integer getMonthFilter() {
            return this.monthFilter;
        }

        public final void setMonthFilter(@Nullable Integer n) {
            this.monthFilter = n;
        }

        public BelowGlobalMean(@Nullable Integer monthFilter) {
            this.monthFilter = monthFilter;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\bf\u0018\u00002\u00020\u0001R\u001a\u0010\u0002\u001a\u00020\u00038gX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u0004\u0018\u00010\t8gX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u00038gX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0005\"\u0004\b\u0010\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/apache/beam/examples/kotlin/cookbook/FilterExamples$Options;", "Lorg/apache/beam/sdk/options/PipelineOptions;", "input", "", "getInput", "()Ljava/lang/String;", "setInput", "(Ljava/lang/String;)V", "monthFilter", "", "getMonthFilter", "()Ljava/lang/Integer;", "setMonthFilter", "(Ljava/lang/Integer;)V", "output", "getOutput", "setOutput", "beam-examples-kotlin"})
    public static interface Options
    extends PipelineOptions {
        @Description(value="Table to read from, specified as <project_id>:<dataset_id>.<table_id>")
        @Default.String(value="clouddataflow-readonly:samples.weather_stations")
        @NotNull
        public String getInput();

        public void setInput(@NotNull String var1);

        @Description(value="Table to write to, specified as <project_id>:<dataset_id>.<table_id>. The dataset_id must already exist")
        @Validation.Required
        @NotNull
        public String getOutput();

        public void setOutput(@NotNull String var1);

        @Description(value="Numeric value of month to filter on")
        @Default.Integer(value=7)
        @Nullable
        public Integer getMonthFilter();

        public void setMonthFilter(@Nullable Integer var1);
    }
}

