/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.kotlin.cookbook;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.cloud.bigquery.storage.v1beta1.ReadOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.Validation;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004\r\u000e\u000f\u0010B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/apache/beam/examples/kotlin/cookbook/BigQueryTornadoes;", "", "()V", "WEATHER_SAMPLES_TABLE", "", "main", "", "args", "", "([Ljava/lang/String;)V", "runBigQueryTornadoes", "options", "Lorg/apache/beam/examples/kotlin/cookbook/BigQueryTornadoes$Options;", "CountTornadoes", "ExtractTornadoesFn", "FormatCountsFn", "Options", "beam-examples-kotlin"})
public final class BigQueryTornadoes {
    private static final String WEATHER_SAMPLES_TABLE = "clouddataflow-readonly:samples.weather_stations";
    public static final BigQueryTornadoes INSTANCE;

    private final void runBigQueryTornadoes(Options options) {
        Pipeline p = Pipeline.create((PipelineOptions)options);
        Object[] objectArray = new TableFieldSchema[2];
        TableFieldSchema tableFieldSchema = new TableFieldSchema().setName("month").setType("INTEGER");
        Intrinsics.checkExpressionValueIsNotNull((Object)tableFieldSchema, (String)"TableFieldSchema().setNa\u2026onth\").setType(\"INTEGER\")");
        objectArray[0] = tableFieldSchema;
        TableFieldSchema tableFieldSchema2 = new TableFieldSchema().setName("tornado_count").setType("INTEGER");
        Intrinsics.checkExpressionValueIsNotNull((Object)tableFieldSchema2, (String)"TableFieldSchema().setNa\u2026ount\").setType(\"INTEGER\")");
        objectArray[1] = tableFieldSchema2;
        ArrayList fields = CollectionsKt.arrayListOf((Object[])objectArray);
        TableSchema schema = new TableSchema().setFields((List)fields);
        PCollection rowsFromBigQuery = null;
        if (options.getReadMethod() == BigQueryIO.TypedRead.Method.DIRECT_READ) {
            ReadOptions.TableReadOptions tableReadOptions = ReadOptions.TableReadOptions.newBuilder().addAllSelectedFields((Iterable)Lists.newArrayList((Object[])new String[]{"month", "tornado"})).build();
            POutput pOutput = p.apply((PTransform)BigQueryIO.readTableRows().from(options.getInput()).withMethod(BigQueryIO.TypedRead.Method.DIRECT_READ).withReadOptions(tableReadOptions));
            Intrinsics.checkExpressionValueIsNotNull((Object)pOutput, (String)"p.apply(\n               \u2026ptions(tableReadOptions))");
            rowsFromBigQuery = (PCollection)pOutput;
        } else {
            POutput pOutput = p.apply((PTransform)BigQueryIO.readTableRows().from(options.getInput()).withMethod(options.getReadMethod()));
            Intrinsics.checkExpressionValueIsNotNull((Object)pOutput, (String)"p.apply(\n               \u2026thod(options.readMethod))");
            rowsFromBigQuery = (PCollection)pOutput;
        }
        ((PCollection)rowsFromBigQuery.apply((PTransform)new CountTornadoes())).apply((PTransform)BigQueryIO.writeTableRows().to(options.getOutput()).withSchema(schema).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_TRUNCATE));
        p.run().waitUntilFinish();
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        PipelineOptionsFactory.Builder builder = PipelineOptionsFactory.fromArgs((String[])Arrays.copyOf(args, args.length)).withValidation();
        if (builder == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.apache.beam.examples.kotlin.cookbook.BigQueryTornadoes.Options");
        }
        Options options = (Options)builder;
        INSTANCE.runBigQueryTornadoes(options);
    }

    private BigQueryTornadoes() {
    }

    static {
        BigQueryTornadoes bigQueryTornadoes;
        INSTANCE = bigQueryTornadoes = new BigQueryTornadoes();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0016\u0010\u0007\u001a\u00120\bR\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001H\u0007\u00a8\u0006\t"}, d2={"Lorg/apache/beam/examples/kotlin/cookbook/BigQueryTornadoes$ExtractTornadoesFn;", "Lorg/apache/beam/sdk/transforms/DoFn;", "Lcom/google/api/services/bigquery/model/TableRow;", "", "()V", "processElement", "", "c", "Lorg/apache/beam/sdk/transforms/DoFn$ProcessContext;", "beam-examples-kotlin"})
    public static final class ExtractTornadoesFn
    extends DoFn<TableRow, Integer> {
        @DoFn.ProcessElement
        public final void processElement(@NotNull DoFn.ProcessContext c) {
            Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
            TableRow row = (TableRow)c.element();
            Object object = row.get((Object)"tornado");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Boolean");
            }
            if (((Boolean)object).booleanValue()) {
                Object object2 = row.get((Object)"month");
                if (object2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                c.output((Object)Integer.parseInt((String)object2));
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002\u0012\u0004\u0012\u00020\u00050\u0001B\u0005\u00a2\u0006\u0002\u0010\u0006J,\u0010\u0007\u001a\u00020\b2\"\u0010\t\u001a\u001e0\nR\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002\u0012\u0004\u0012\u00020\u00050\u0001H\u0007\u00a8\u0006\u000b"}, d2={"Lorg/apache/beam/examples/kotlin/cookbook/BigQueryTornadoes$FormatCountsFn;", "Lorg/apache/beam/sdk/transforms/DoFn;", "Lorg/apache/beam/sdk/values/KV;", "", "", "Lcom/google/api/services/bigquery/model/TableRow;", "()V", "processElement", "", "c", "Lorg/apache/beam/sdk/transforms/DoFn$ProcessContext;", "beam-examples-kotlin"})
    public static final class FormatCountsFn
    extends DoFn<KV<Integer, Long>, TableRow> {
        @DoFn.ProcessElement
        public final void processElement(@NotNull DoFn.ProcessContext c) {
            Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
            TableRow row = new TableRow().set("month", ((KV)c.element()).getKey()).set("tornado_count", ((KV)c.element()).getValue());
            c.output((Object)row);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/apache/beam/examples/kotlin/cookbook/BigQueryTornadoes$CountTornadoes;", "Lorg/apache/beam/sdk/transforms/PTransform;", "Lorg/apache/beam/sdk/values/PCollection;", "Lcom/google/api/services/bigquery/model/TableRow;", "()V", "expand", "rows", "beam-examples-kotlin"})
    public static final class CountTornadoes
    extends PTransform<PCollection<TableRow>, PCollection<TableRow>> {
        @NotNull
        public PCollection<TableRow> expand(@NotNull PCollection<TableRow> rows) {
            Intrinsics.checkParameterIsNotNull(rows, (String)"rows");
            PCollection tornadoes = (PCollection)rows.apply((PTransform)ParDo.of((DoFn)new ExtractTornadoesFn()));
            PCollection tornadoCounts = (PCollection)tornadoes.apply(Count.perElement());
            POutput pOutput = tornadoCounts.apply((PTransform)ParDo.of((DoFn)new FormatCountsFn()));
            Intrinsics.checkExpressionValueIsNotNull((Object)pOutput, (String)"tornadoCounts.apply(ParDo.of(FormatCountsFn()))");
            return (PCollection)pOutput;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001R\u001a\u0010\u0002\u001a\u00020\u00038gX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\u00038gX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\u0005\"\u0004\b\n\u0010\u0007R\u001a\u0010\u000b\u001a\u00020\f8gX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/apache/beam/examples/kotlin/cookbook/BigQueryTornadoes$Options;", "Lorg/apache/beam/sdk/options/PipelineOptions;", "input", "", "getInput", "()Ljava/lang/String;", "setInput", "(Ljava/lang/String;)V", "output", "getOutput", "setOutput", "readMethod", "Lorg/apache/beam/sdk/io/gcp/bigquery/BigQueryIO$TypedRead$Method;", "getReadMethod", "()Lorg/apache/beam/sdk/io/gcp/bigquery/BigQueryIO$TypedRead$Method;", "setReadMethod", "(Lorg/apache/beam/sdk/io/gcp/bigquery/BigQueryIO$TypedRead$Method;)V", "beam-examples-kotlin"})
    public static interface Options
    extends PipelineOptions {
        @Description(value="Table to read from, specified as <project_id>:<dataset_id>.<table_id>")
        @Default.String(value="clouddataflow-readonly:samples.weather_stations")
        @NotNull
        public String getInput();

        public void setInput(@NotNull String var1);

        @Description(value="Mode to use when reading from BigQuery")
        @Default.Enum(value="EXPORT")
        @NotNull
        public BigQueryIO.TypedRead.Method getReadMethod();

        public void setReadMethod(@NotNull BigQueryIO.TypedRead.Method var1);

        @Description(value="BigQuery table to write to, specified as <project_id>:<dataset_id>.<table_id>. The dataset must already exist.")
        @Validation.Required
        @NotNull
        public String getOutput();

        public void setOutput(@NotNull String var1);
    }
}

