/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.kotlin.common;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.beam.sdk.io.FileBasedSink;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u0000 \f2\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u0001:\u0002\f\rB\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\n\u001a\u00020\u00042\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u000e"}, d2={"Lorg/apache/beam/examples/kotlin/common/WriteOneFilePerWindow;", "Lorg/apache/beam/sdk/transforms/PTransform;", "Lorg/apache/beam/sdk/values/PCollection;", "", "Lorg/apache/beam/sdk/values/PDone;", "filenamePrefix", "numShards", "", "(Ljava/lang/String;Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "expand", "input", "Companion", "PerWindowFiles", "beam-examples-kotlin"})
public final class WriteOneFilePerWindow
extends PTransform<PCollection<String>, PDone> {
    private final String filenamePrefix;
    private final Integer numShards;
    private static final DateTimeFormatter FORMATTER;
    public static final Companion Companion;

    @NotNull
    public PDone expand(@NotNull PCollection<String> input) {
        TextIO.Write write;
        Intrinsics.checkParameterIsNotNull(input, (String)"input");
        ResourceId resource = FileBasedSink.convertToFileResourceIfPossible((String)this.filenamePrefix);
        TextIO.Write write2 = TextIO.write();
        ResourceId resourceId = resource;
        Intrinsics.checkExpressionValueIsNotNull((Object)resourceId, (String)"resource");
        TextIO.Write write3 = write2.to((FileBasedSink.FilenamePolicy)new PerWindowFiles(resourceId)).withTempDirectory(resource.getCurrentDirectory()).withWindowedWrites();
        Integer n = this.numShards;
        if (n != null) {
            TextIO.Write write4;
            Integer n2 = n;
            int it = ((Number)n2).intValue();
            boolean bl = false;
            write = write4 = write3.withNumShards(it);
        } else {
            write = null;
        }
        write3 = write;
        POutput pOutput = input.apply((PTransform)write3);
        Intrinsics.checkExpressionValueIsNotNull((Object)pOutput, (String)"input.apply(write)");
        return (PDone)pOutput;
    }

    public WriteOneFilePerWindow(@NotNull String filenamePrefix, @Nullable Integer numShards) {
        Intrinsics.checkParameterIsNotNull((Object)filenamePrefix, (String)"filenamePrefix");
        this.filenamePrefix = filenamePrefix;
        this.numShards = numShards;
    }

    static {
        Companion = new Companion(null);
        FORMATTER = ISODateTimeFormat.hourMinute();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\"\u0010\t\u001a\u0004\u0018\u00010\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J0\u0010\u000f\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/apache/beam/examples/kotlin/common/WriteOneFilePerWindow$PerWindowFiles;", "Lorg/apache/beam/sdk/io/FileBasedSink$FilenamePolicy;", "baseFilename", "Lorg/apache/beam/sdk/io/fs/ResourceId;", "(Lorg/apache/beam/sdk/io/fs/ResourceId;)V", "filenamePrefixForWindow", "", "window", "Lorg/apache/beam/sdk/transforms/windowing/IntervalWindow;", "unwindowedFilename", "shardNumber", "", "numShards", "outputFileHints", "Lorg/apache/beam/sdk/io/FileBasedSink$OutputFileHints;", "windowedFilename", "Lorg/apache/beam/sdk/transforms/windowing/BoundedWindow;", "paneInfo", "Lorg/apache/beam/sdk/transforms/windowing/PaneInfo;", "beam-examples-kotlin"})
    public static final class PerWindowFiles
    extends FileBasedSink.FilenamePolicy {
        private final ResourceId baseFilename;

        @NotNull
        public final String filenamePrefixForWindow(@NotNull IntervalWindow window) {
            Intrinsics.checkParameterIsNotNull((Object)window, (String)"window");
            String prefix = this.baseFilename.isDirectory() ? "" : (String)MoreObjects.firstNonNull((Object)this.baseFilename.getFilename(), (Object)"");
            return prefix + '-' + FORMATTER.print((ReadableInstant)window.start()) + '-' + FORMATTER.print((ReadableInstant)window.end());
        }

        @NotNull
        public ResourceId windowedFilename(int shardNumber, int numShards, @NotNull BoundedWindow window, @NotNull PaneInfo paneInfo, @NotNull FileBasedSink.OutputFileHints outputFileHints) {
            Intrinsics.checkParameterIsNotNull((Object)window, (String)"window");
            Intrinsics.checkParameterIsNotNull((Object)paneInfo, (String)"paneInfo");
            Intrinsics.checkParameterIsNotNull((Object)outputFileHints, (String)"outputFileHints");
            IntervalWindow intervalWindow = (IntervalWindow)window;
            String filename = this.filenamePrefixForWindow(intervalWindow) + '-' + shardNumber + "-of-" + numShards + outputFileHints.getSuggestedFilenameSuffix();
            ResourceId resourceId = this.baseFilename.getCurrentDirectory().resolve(filename, (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE);
            Intrinsics.checkExpressionValueIsNotNull((Object)resourceId, (String)"baseFilename\n           \u2026olveOptions.RESOLVE_FILE)");
            return resourceId;
        }

        @Nullable
        public ResourceId unwindowedFilename(int shardNumber, int numShards, @NotNull FileBasedSink.OutputFileHints outputFileHints) {
            Intrinsics.checkParameterIsNotNull((Object)outputFileHints, (String)"outputFileHints");
            throw (Throwable)new UnsupportedOperationException("Unsupported.");
        }

        public PerWindowFiles(@NotNull ResourceId baseFilename) {
            Intrinsics.checkParameterIsNotNull((Object)baseFilename, (String)"baseFilename");
            this.baseFilename = baseFilename;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/apache/beam/examples/kotlin/common/WriteOneFilePerWindow$Companion;", "", "()V", "FORMATTER", "Lorg/joda/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "beam-examples-kotlin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

