/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.kotlin.common;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.Dataset;
import com.google.api.services.bigquery.model.DatasetReference;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.api.services.pubsub.Pubsub;
import com.google.api.services.pubsub.model.Empty;
import com.google.api.services.pubsub.model.Subscription;
import com.google.api.services.pubsub.model.Topic;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.cloud.hadoop.util.ChainingHttpRequestInitializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.apache.beam.examples.kotlin.common.ExampleBigQueryTableOptions;
import org.apache.beam.examples.kotlin.common.ExampleOptions;
import org.apache.beam.examples.kotlin.common.ExamplePubsubTopicAndSubscriptionOptions;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.extensions.gcp.auth.NullCredentialInitializer;
import org.apache.beam.sdk.extensions.gcp.util.RetryHttpRequestInitializer;
import org.apache.beam.sdk.extensions.gcp.util.Transport;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.util.BackOff;
import org.apache.beam.sdk.util.BackOffUtils;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.util.Sleeper;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.Uninterruptibles;
import org.jetbrains.annotations.NotNull;
import org.joda.time.Duration;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 .2\u00020\u0001:\u0001.B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\rH\u0002J\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\rH\u0002J\b\u0010\u001f\u001a\u00020\u0018H\u0002J\u0006\u0010 \u001a\u00020\u0018J\u0006\u0010!\u001a\u00020\u0018J(\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\r2\u0006\u0010$\u001a\u00020\r2\u0006\u0010%\u001a\u00020&H\u0002J\u0006\u0010'\u001a\u00020\u0018J\u0018\u0010(\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\rH\u0002J\u0018\u0010)\u001a\n \u000e*\u0004\u0018\u00010*0*2\u0006\u0010\u001e\u001a\u00020\rH\u0002J\b\u0010+\u001a\u00020\u0018H\u0002J\u000e\u0010,\u001a\u00020\u00182\u0006\u0010-\u001a\u00020\u0011R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u000b\u001a&\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r \u000e*\u0012\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u000f\u001a&\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00110\u0011 \u000e*\u0012\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00110\u0011\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0012\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\n\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006/"}, d2={"Lorg/apache/beam/examples/kotlin/common/ExampleUtils;", "", "options", "Lorg/apache/beam/sdk/options/PipelineOptions;", "(Lorg/apache/beam/sdk/options/PipelineOptions;)V", "bigQueryClient", "Lcom/google/api/services/bigquery/Bigquery;", "getBigQueryClient", "()Lcom/google/api/services/bigquery/Bigquery;", "bigQueryClient$delegate", "Lkotlin/Lazy;", "pendingMessages", "Ljava/util/ArrayList;", "", "kotlin.jvm.PlatformType", "pipelinesToCancel", "Ljava/util/HashSet;", "Lorg/apache/beam/sdk/PipelineResult;", "pubsubClient", "Lcom/google/api/services/pubsub/Pubsub;", "getPubsubClient", "()Lcom/google/api/services/pubsub/Pubsub;", "pubsubClient$delegate", "addShutdownHook", "", "pipelineResults", "", "deletePubsubSubscription", "subscription", "deletePubsubTopic", "topic", "printPendingMessages", "setup", "setupBigQueryTable", "projectId", "datasetId", "tableId", "schema", "Lcom/google/api/services/bigquery/model/TableSchema;", "setupPubsub", "setupPubsubSubscription", "setupPubsubTopic", "Lcom/google/api/services/pubsub/model/Topic;", "tearDown", "waitToFinish", "result", "Companion", "beam-examples-kotlin"})
public final class ExampleUtils {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final Lazy bigQueryClient$delegate;
    private final Lazy pubsubClient$delegate;
    private final HashSet<PipelineResult> pipelinesToCancel;
    private final ArrayList<String> pendingMessages;
    private final PipelineOptions options;
    private static final int SC_NOT_FOUND = 404;
    @NotNull
    public static final String TOKENIZER_PATTERN = "[^\\p{L}]+";
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ExampleUtils.class), "bigQueryClient", "getBigQueryClient()Lcom/google/api/services/bigquery/Bigquery;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ExampleUtils.class), "pubsubClient", "getPubsubClient()Lcom/google/api/services/pubsub/Pubsub;"))};
        Companion = new Companion(null);
    }

    private final Bigquery getBigQueryClient() {
        Lazy lazy = this.bigQueryClient$delegate;
        ExampleUtils exampleUtils = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (Bigquery)lazy.getValue();
    }

    private final Pubsub getPubsubClient() {
        Lazy lazy = this.pubsubClient$delegate;
        ExampleUtils exampleUtils = this;
        KProperty kProperty = $$delegatedProperties[1];
        return (Pubsub)lazy.getValue();
    }

    public final void setup() throws IOException {
        Sleeper sleeper = Sleeper.DEFAULT;
        BackOff backOff = FluentBackoff.DEFAULT.withMaxRetries(3).withInitialBackoff(Duration.millis((long)200L)).backoff();
        Throwable lastException = null;
        try {
            while (true) {
                try {
                    this.setupPubsub();
                    this.setupBigQueryTable();
                    return;
                }
                catch (GoogleJsonResponseException e) {
                    lastException = e;
                    if (BackOffUtils.next((Sleeper)sleeper, (BackOff)backOff)) continue;
                }
                break;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        throw (Throwable)new RuntimeException(lastException);
    }

    public final void setupPubsub() throws IOException {
        PipelineOptions pipelineOptions = this.options;
        if (pipelineOptions == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.apache.beam.examples.kotlin.common.ExamplePubsubTopicAndSubscriptionOptions");
        }
        ExamplePubsubTopicAndSubscriptionOptions pubsubOptions = (ExamplePubsubTopicAndSubscriptionOptions)pipelineOptions;
        CharSequence charSequence = pubsubOptions.getPubsubTopic();
        if (charSequence.length() > 0) {
            this.pendingMessages.add("**********************Set Up Pubsub************************");
            this.setupPubsubTopic(pubsubOptions.getPubsubTopic());
            this.pendingMessages.add("The Pub/Sub topic has been set up for this example: " + pubsubOptions.getPubsubTopic());
            charSequence = pubsubOptions.getPubsubSubscription();
            if (charSequence.length() > 0) {
                this.setupPubsubSubscription(pubsubOptions.getPubsubTopic(), pubsubOptions.getPubsubSubscription());
                this.pendingMessages.add("The Pub/Sub subscription has been set up for this example: " + pubsubOptions.getPubsubSubscription());
            }
        }
    }

    public final void setupBigQueryTable() throws IOException {
        PipelineOptions pipelineOptions = this.options;
        if (pipelineOptions == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.apache.beam.examples.kotlin.common.ExampleBigQueryTableOptions");
        }
        ExampleBigQueryTableOptions bigQueryTableOptions = (ExampleBigQueryTableOptions)pipelineOptions;
        this.pendingMessages.add("******************Set Up Big Query Table*******************");
        String string = bigQueryTableOptions.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"bigQueryTableOptions.project");
        this.setupBigQueryTable(string, bigQueryTableOptions.getBigQueryDataset(), bigQueryTableOptions.getBigQueryTable(), bigQueryTableOptions.getBigQuerySchema());
        this.pendingMessages.add(StringsKt.trimIndent((String)("\n                    The BigQuery table has been set up for this example:\n                    " + bigQueryTableOptions.getProject() + ":\n                    " + bigQueryTableOptions.getBigQueryDataset() + ".\n                    " + bigQueryTableOptions.getBigQueryTable() + "\n                ")));
    }

    private final void tearDown() {
        this.pendingMessages.add("*************************Tear Down*************************");
        PipelineOptions pipelineOptions = this.options;
        if (pipelineOptions == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.apache.beam.examples.kotlin.common.ExamplePubsubTopicAndSubscriptionOptions");
        }
        ExamplePubsubTopicAndSubscriptionOptions pubsubOptions = (ExamplePubsubTopicAndSubscriptionOptions)pipelineOptions;
        CharSequence charSequence = pubsubOptions.getPubsubTopic();
        if (charSequence.length() > 0) {
            try {
                this.deletePubsubTopic(pubsubOptions.getPubsubTopic());
                this.pendingMessages.add("The Pub/Sub topic has been deleted: " + pubsubOptions.getPubsubTopic());
            }
            catch (IOException e) {
                this.pendingMessages.add("Failed to delete the Pub/Sub topic : " + pubsubOptions.getPubsubTopic());
            }
            CharSequence e = pubsubOptions.getPubsubSubscription();
            if (e.length() > 0) {
                try {
                    this.deletePubsubSubscription(pubsubOptions.getPubsubSubscription());
                    this.pendingMessages.add("The Pub/Sub subscription has been deleted: " + pubsubOptions.getPubsubSubscription());
                }
                catch (IOException e2) {
                    this.pendingMessages.add("Failed to delete the Pub/Sub subscription : " + pubsubOptions.getPubsubSubscription());
                }
            }
        }
        PipelineOptions pipelineOptions2 = this.options;
        if (pipelineOptions2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.apache.beam.examples.kotlin.common.ExampleBigQueryTableOptions");
        }
        ExampleBigQueryTableOptions bigQueryTableOptions = (ExampleBigQueryTableOptions)pipelineOptions2;
        this.pendingMessages.add(StringsKt.trimIndent((String)("\n                    The BigQuery table might contain the example's output, and it is not deleted automatically:\n                    " + bigQueryTableOptions.getProject() + ":\n                    " + bigQueryTableOptions.getBigQueryDataset() + ".\n                    " + bigQueryTableOptions.getBigQueryTable() + "\n                ")));
        this.pendingMessages.add("Please go to the Developers Console to delete it manually. Otherwise, you may be charged for its usage.");
    }

    private final void setupBigQueryTable(String projectId, String datasetId, String tableId, TableSchema schema) throws IOException {
        Table table;
        Bigquery.Datasets datasetService = this.getBigQueryClient().datasets();
        Bigquery.Datasets.Get get = datasetService.get(projectId, datasetId);
        Intrinsics.checkExpressionValueIsNotNull((Object)get, (String)"datasetService.get(projectId, datasetId)");
        if (ExampleUtils.Companion.executeNullIfNotFound((AbstractGoogleClientRequest)get) == null) {
            Dataset newDataset = new Dataset().setDatasetReference(new DatasetReference().setProjectId(projectId).setDatasetId(datasetId));
            datasetService.insert(projectId, newDataset).execute();
        }
        Bigquery.Tables tableService = this.getBigQueryClient().tables();
        Bigquery.Tables.Get get2 = tableService.get(projectId, datasetId, tableId);
        Intrinsics.checkExpressionValueIsNotNull((Object)get2, (String)"tableService.get(projectId, datasetId, tableId)");
        Table table2 = table = (Table)ExampleUtils.Companion.executeNullIfNotFound((AbstractGoogleClientRequest)get2);
        if (table2 != null) {
            Table table3;
            Table it = table3 = table2;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it.getSchema(), (Object)schema) ^ true) {
                throw (Throwable)new RuntimeException(StringsKt.trimIndent((String)("\n                        Table exists and schemas do not match, expecting:\n                        " + schema.toPrettyString() + ", actual:\n                        " + table.getSchema().toPrettyString() + "\n                    ")));
            }
        } else {
            ExampleUtils exampleUtils;
            ExampleUtils $receiver = exampleUtils = this;
            boolean bl = false;
            Table newTable = new Table().setSchema(schema).setTableReference(new TableReference().setProjectId(projectId).setDatasetId(datasetId).setTableId(tableId));
            Table cfr_ignored_0 = (Table)tableService.insert(projectId, datasetId, newTable).execute();
        }
    }

    private final Topic setupPubsubTopic(String topic) throws IOException {
        return (Topic)this.getPubsubClient().projects().topics().create(topic, new Topic().setName(topic)).execute();
    }

    private final void setupPubsubSubscription(String topic, String subscription) throws IOException {
        Subscription subInfo = new Subscription().setAckDeadlineSeconds(Integer.valueOf(60)).setTopic(topic);
        this.getPubsubClient().projects().subscriptions().create(subscription, subInfo).execute();
    }

    private final void deletePubsubTopic(String topic) throws IOException {
        block0: {
            Topic topic2;
            Pubsub.Projects.Topics topics;
            Pubsub.Projects.Topics $receiver = topics = this.getPubsubClient().projects().topics();
            boolean bl = false;
            Pubsub.Projects.Topics.Get get = $receiver.get(topic);
            Intrinsics.checkExpressionValueIsNotNull((Object)get, (String)"get(topic)");
            Topic topic3 = (Topic)ExampleUtils.Companion.executeNullIfNotFound((AbstractGoogleClientRequest)get);
            if (topic3 == null) break block0;
            Topic it = topic2 = topic3;
            boolean bl2 = false;
            Empty cfr_ignored_0 = (Empty)$receiver.delete(topic).execute();
        }
    }

    private final void deletePubsubSubscription(String subscription) throws IOException {
        block0: {
            Pubsub.Projects.Subscriptions.Get get;
            Pubsub.Projects.Subscriptions subscriptions;
            Pubsub.Projects.Subscriptions $receiver = subscriptions = new Pubsub.Projects(this.getPubsubClient()).subscriptions();
            boolean bl = false;
            Pubsub.Projects.Subscriptions.Get get2 = $receiver.get(subscription);
            if (get2 == null) break block0;
            Pubsub.Projects.Subscriptions.Get it = get = get2;
            boolean bl2 = false;
            Empty cfr_ignored_0 = (Empty)$receiver.delete(subscription).execute();
        }
    }

    public final void waitToFinish(@NotNull PipelineResult result) {
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        this.pipelinesToCancel.add(result);
        PipelineOptions pipelineOptions = this.options;
        if (pipelineOptions == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.apache.beam.examples.kotlin.common.ExampleOptions");
        }
        if (!((ExampleOptions)pipelineOptions).getKeepJobsRunning()) {
            HashSet<PipelineResult> hashSet = this.pipelinesToCancel;
            Intrinsics.checkExpressionValueIsNotNull(hashSet, (String)"pipelinesToCancel");
            this.addShutdownHook((Collection<? extends PipelineResult>)hashSet);
        }
        try {
            result.waitUntilFinish();
        }
        catch (UnsupportedOperationException e) {
            this.tearDown();
            this.printPendingMessages();
        }
        catch (Exception e) {
            throw (Throwable)new RuntimeException("Failed to wait the pipeline until finish: " + result);
        }
    }

    private final void addShutdownHook(Collection<? extends PipelineResult> pipelineResults) {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(this, pipelineResults){
            final /* synthetic */ ExampleUtils this$0;
            final /* synthetic */ Collection $pipelineResults;

            /*
             * WARNING - void declaration
             */
            public final void run() {
                ExampleUtils.access$tearDown(this.this$0);
                ExampleUtils.access$printPendingMessages(this.this$0);
                for (PipelineResult pipelineResult : this.$pipelineResults) {
                    try {
                        pipelineResult.cancel();
                    }
                    catch (IOException e) {
                        String string = "Failed to cancel the job.";
                        System.out.println((Object)string);
                        string = e.getMessage();
                        System.out.println((Object)string);
                    }
                }
                for (PipelineResult pipelineResult : this.$pipelineResults) {
                    boolean cancellationVerified = false;
                    int n = 6;
                    int n2 = 1;
                    while (n >= n2) {
                        void retryAttempts;
                        PipelineResult.State state = pipelineResult.getState();
                        Intrinsics.checkExpressionValueIsNotNull((Object)state, (String)"pipelineResult.state");
                        if (state.isTerminal()) {
                            cancellationVerified = true;
                            break;
                        }
                        String string = "The example pipeline is still running. Verifying the cancellation.";
                        System.out.println((Object)string);
                        Uninterruptibles.sleepUninterruptibly((long)10L, (TimeUnit)TimeUnit.SECONDS);
                        --retryAttempts;
                    }
                    if (cancellationVerified) continue;
                    String string = "Failed to verify the cancellation for job: " + pipelineResult;
                    System.out.println((Object)string);
                }
            }
            {
                this.this$0 = exampleUtils;
                this.$pipelineResults = collection;
            }
        }));
    }

    private final void printPendingMessages() {
        System.out.println();
        String string = "***********************************************************";
        System.out.println((Object)string);
        string = "***********************************************************";
        System.out.println((Object)string);
        for (String message : this.pendingMessages) {
            System.out.println((Object)message);
        }
        string = "***********************************************************";
        System.out.println((Object)string);
        string = "***********************************************************";
        System.out.println((Object)string);
    }

    public ExampleUtils(@NotNull PipelineOptions options) {
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        this.options = options;
        this.bigQueryClient$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Bigquery>(this){
            final /* synthetic */ ExampleUtils this$0;

            public final Bigquery invoke() {
                PipelineOptions pipelineOptions = ExampleUtils.access$getOptions$p(this.this$0);
                if (pipelineOptions == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions");
                }
                return org.apache.beam.examples.kotlin.common.ExampleUtils$Companion.access$newBigQueryClient(ExampleUtils.Companion, (BigQueryOptions)pipelineOptions).build();
            }
            {
                this.this$0 = exampleUtils;
                super(0);
            }
        }));
        this.pubsubClient$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Pubsub>(this){
            final /* synthetic */ ExampleUtils this$0;

            public final Pubsub invoke() {
                PipelineOptions pipelineOptions = ExampleUtils.access$getOptions$p(this.this$0);
                if (pipelineOptions == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.apache.beam.sdk.io.gcp.pubsub.PubsubOptions");
                }
                return org.apache.beam.examples.kotlin.common.ExampleUtils$Companion.access$newPubsubClient(ExampleUtils.Companion, (PubsubOptions)pipelineOptions).build();
            }
            {
                this.this$0 = exampleUtils;
                super(0);
            }
        }));
        this.pipelinesToCancel = Sets.newHashSet();
        this.pendingMessages = Lists.newArrayList();
    }

    public static final /* synthetic */ void access$tearDown(ExampleUtils $this) {
        $this.tearDown();
    }

    public static final /* synthetic */ void access$printPendingMessages(ExampleUtils $this) {
        $this.printPendingMessages();
    }

    public static final /* synthetic */ PipelineOptions access$getOptions$p(ExampleUtils $this) {
        return $this.options;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\bH\u0002J#\u0010\f\u001a\u0004\u0018\u0001H\r\"\u0004\b\u0000\u0010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000fH\u0002\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0017H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/apache/beam/examples/kotlin/common/ExampleUtils$Companion;", "", "()V", "SC_NOT_FOUND", "", "TOKENIZER_PATTERN", "", "chainHttpRequestInitializer", "Lcom/google/api/client/http/HttpRequestInitializer;", "credential", "Lcom/google/auth/Credentials;", "httpRequestInitializer", "executeNullIfNotFound", "T", "request", "Lcom/google/api/client/googleapis/services/AbstractGoogleClientRequest;", "(Lcom/google/api/client/googleapis/services/AbstractGoogleClientRequest;)Ljava/lang/Object;", "newBigQueryClient", "Lcom/google/api/services/bigquery/Bigquery$Builder;", "options", "Lorg/apache/beam/sdk/io/gcp/bigquery/BigQueryOptions;", "newPubsubClient", "Lcom/google/api/services/pubsub/Pubsub$Builder;", "Lorg/apache/beam/sdk/io/gcp/pubsub/PubsubOptions;", "beam-examples-kotlin"})
    public static final class Companion {
        private final Bigquery.Builder newBigQueryClient(BigQueryOptions options) {
            Bigquery.Builder builder = new Bigquery.Builder(Transport.getTransport(), Transport.getJsonFactory(), this.chainHttpRequestInitializer(options.getGcpCredential(), (HttpRequestInitializer)new RetryHttpRequestInitializer((Collection)ImmutableList.of((Object)404)))).setApplicationName(options.getAppName()).setGoogleClientRequestInitializer((GoogleClientRequestInitializer)options.getGoogleApiTrace());
            Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"Bigquery.Builder(\n      \u2026r(options.googleApiTrace)");
            return builder;
        }

        private final Pubsub.Builder newPubsubClient(PubsubOptions options) {
            Pubsub.Builder builder = new Pubsub.Builder(Transport.getTransport(), Transport.getJsonFactory(), this.chainHttpRequestInitializer(options.getGcpCredential(), (HttpRequestInitializer)new RetryHttpRequestInitializer((Collection)ImmutableList.of((Object)404)))).setRootUrl(options.getPubsubRootUrl()).setApplicationName(options.getAppName()).setGoogleClientRequestInitializer((GoogleClientRequestInitializer)options.getGoogleApiTrace());
            Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"Pubsub.Builder(\n        \u2026r(options.googleApiTrace)");
            return builder;
        }

        private final HttpRequestInitializer chainHttpRequestInitializer(Credentials credential, HttpRequestInitializer httpRequestInitializer) {
            HttpRequestInitializer httpRequestInitializer2;
            Credentials credentials = credential;
            if (credentials != null) {
                Credentials credentials2;
                Credentials it = credentials2 = credentials;
                boolean bl = false;
                httpRequestInitializer2 = (HttpRequestInitializer)new ChainingHttpRequestInitializer(new HttpRequestInitializer[]{(HttpRequestInitializer)new HttpCredentialsAdapter(credential), httpRequestInitializer});
            } else {
                Companion companion;
                Companion $receiver = companion = this;
                boolean bl = false;
                httpRequestInitializer2 = (HttpRequestInitializer)new ChainingHttpRequestInitializer(new HttpRequestInitializer[]{(HttpRequestInitializer)new NullCredentialInitializer(), httpRequestInitializer});
            }
            return httpRequestInitializer2;
        }

        private final <T> T executeNullIfNotFound(AbstractGoogleClientRequest<T> request) throws IOException {
            Object object;
            try {
                object = request.execute();
            }
            catch (GoogleJsonResponseException e) {
                if (e.getStatusCode() != 404) {
                    throw (Throwable)e;
                }
                object = null;
            }
            return (T)object;
        }

        private Companion() {
        }

        public static final /* synthetic */ Bigquery.Builder access$newBigQueryClient(Companion $this, BigQueryOptions options) {
            return $this.newBigQueryClient(options);
        }

        public static final /* synthetic */ Pubsub.Builder access$newPubsubClient(Companion $this, PubsubOptions options) {
            return $this.newPubsubClient(options);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

