/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.kotlin;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Distribution;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.Validation;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004\f\r\u000e\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\u0010"}, d2={"Lorg/apache/beam/examples/kotlin/WordCount;", "", "()V", "main", "", "args", "", "", "([Ljava/lang/String;)V", "runWordCount", "options", "Lorg/apache/beam/examples/kotlin/WordCount$WordCountOptions;", "CountWords", "ExtractWordsFn", "FormatAsTextFn", "WordCountOptions", "beam-examples-kotlin"})
public final class WordCount {
    public static final WordCount INSTANCE;

    @JvmStatic
    public static final void runWordCount(@NotNull WordCountOptions options) {
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        Pipeline p = Pipeline.create((PipelineOptions)options);
        ((PCollection)((PCollection)((PCollection)p.apply("ReadLines", (PTransform)TextIO.read().from(options.getInputFile()))).apply((PTransform)new CountWords())).apply((PTransform)MapElements.via((SimpleFunction)new FormatAsTextFn()))).apply("WriteCounts", (PTransform)TextIO.write().to(options.getOutput()));
        p.run().waitUntilFinish();
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        PipelineOptionsFactory.Builder builder = PipelineOptionsFactory.fromArgs((String[])Arrays.copyOf(args, args.length)).withValidation();
        if (builder == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.apache.beam.examples.kotlin.WordCount.WordCountOptions");
        }
        WordCountOptions options = (WordCountOptions)builder;
        WordCount.runWordCount(options);
    }

    private WordCount() {
    }

    static {
        WordCount wordCount;
        INSTANCE = wordCount = new WordCount();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\u00022\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\rH\u0007R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \u0006*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/apache/beam/examples/kotlin/WordCount$ExtractWordsFn;", "Lorg/apache/beam/sdk/transforms/DoFn;", "", "()V", "emptyLines", "Lorg/apache/beam/sdk/metrics/Counter;", "kotlin.jvm.PlatformType", "lineLenDist", "Lorg/apache/beam/sdk/metrics/Distribution;", "processElement", "", "element", "receiver", "Lorg/apache/beam/sdk/transforms/DoFn$OutputReceiver;", "beam-examples-kotlin"})
    public static final class ExtractWordsFn
    extends DoFn<String, String> {
        private final Counter emptyLines = Metrics.counter(ExtractWordsFn.class, (String)"emptyLines");
        private final Distribution lineLenDist = Metrics.distribution(ExtractWordsFn.class, (String)"lineLenDistro");

        /*
         * WARNING - void declaration
         */
        @DoFn.ProcessElement
        public final void processElement(@DoFn.Element @NotNull String element, @NotNull DoFn.OutputReceiver<String> receiver) {
            String[] words;
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull(receiver, (String)"receiver");
            this.lineLenDist.update((long)element.length());
            CharSequence charSequence = StringsKt.trim((String)element, (char[])new char[]{' '});
            if (charSequence.length() == 0) {
                this.emptyLines.inc();
            }
            Object object = element;
            String string = "[^\\p{L}]+";
            string = new Regex(string);
            int n = 0;
            object = string.split((CharSequence)object, n);
            void v0 = $receiver$iv;
            if (v0 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            void thisCollection$iv = v0;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            for (String word : words = stringArray) {
                CharSequence charSequence2 = word;
                if (!(charSequence2.length() > 0)) continue;
                receiver.output((Object)word);
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u00002\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\u0006\u001a\u00020\u00032\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u0016\u00a8\u0006\b"}, d2={"Lorg/apache/beam/examples/kotlin/WordCount$FormatAsTextFn;", "Lorg/apache/beam/sdk/transforms/SimpleFunction;", "Lorg/apache/beam/sdk/values/KV;", "", "", "()V", "apply", "input", "beam-examples-kotlin"})
    public static final class FormatAsTextFn
    extends SimpleFunction<KV<String, Long>, String> {
        @NotNull
        public String apply(@NotNull KV<String, Long> input) {
            Intrinsics.checkParameterIsNotNull(input, (String)"input");
            return (String)input.getKey() + " : " + (Long)input.getValue();
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u00002&\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00050\u00040\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00050\u00040\u00022\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016\u00a8\u0006\t"}, d2={"Lorg/apache/beam/examples/kotlin/WordCount$CountWords;", "Lorg/apache/beam/sdk/transforms/PTransform;", "Lorg/apache/beam/sdk/values/PCollection;", "", "Lorg/apache/beam/sdk/values/KV;", "", "()V", "expand", "lines", "beam-examples-kotlin"})
    public static final class CountWords
    extends PTransform<PCollection<String>, PCollection<KV<String, Long>>> {
        @NotNull
        public PCollection<KV<String, Long>> expand(@NotNull PCollection<String> lines) {
            PCollection wordCounts;
            Intrinsics.checkParameterIsNotNull(lines, (String)"lines");
            PCollection words = (PCollection)lines.apply((PTransform)ParDo.of((DoFn)new ExtractWordsFn()));
            PCollection pCollection = wordCounts = (PCollection)words.apply(Count.perElement());
            Intrinsics.checkExpressionValueIsNotNull((Object)pCollection, (String)"wordCounts");
            return pCollection;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\bf\u0018\u00002\u00020\u0001R\u001a\u0010\u0002\u001a\u00020\u00038gX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\u00038gX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\u0005\"\u0004\b\n\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lorg/apache/beam/examples/kotlin/WordCount$WordCountOptions;", "Lorg/apache/beam/sdk/options/PipelineOptions;", "inputFile", "", "getInputFile", "()Ljava/lang/String;", "setInputFile", "(Ljava/lang/String;)V", "output", "getOutput", "setOutput", "beam-examples-kotlin"})
    public static interface WordCountOptions
    extends PipelineOptions {
        @Description(value="Path of the file to read from")
        @Default.String(value="gs://apache-beam-samples/shakespeare/kinglear.txt")
        @NotNull
        public String getInputFile();

        public void setInputFile(@NotNull String var1);

        @Description(value="Path of the file to write to")
        @Validation.Required
        @NotNull
        public String getOutput();

        public void setOutput(@NotNull String var1);
    }
}

