/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.kotlin;

import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.apache.beam.examples.kotlin.WordCount;
import org.apache.beam.examples.kotlin.common.ExampleBigQueryTableOptions;
import org.apache.beam.examples.kotlin.common.ExampleOptions;
import org.apache.beam.examples.kotlin.common.WriteOneFilePerWindow;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.PCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.Duration;
import org.joda.time.Instant;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004\u000e\u000f\u0010\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0007\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/apache/beam/examples/kotlin/WindowedWordCount;", "", "()V", "WINDOW_SIZE", "", "main", "", "args", "", "", "([Ljava/lang/String;)V", "runWindowedWordCount", "options", "Lorg/apache/beam/examples/kotlin/WindowedWordCount$Options;", "AddTimestampFn", "DefaultToCurrentSystemTime", "DefaultToMinTimestampPlusOneHour", "Options", "beam-examples-kotlin"})
public final class WindowedWordCount {
    public static final int WINDOW_SIZE = 10;
    public static final WindowedWordCount INSTANCE;

    @JvmStatic
    public static final void runWindowedWordCount(@NotNull Options options) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        String output = options.getOutput();
        Instant minTimestamp = new Instant((Object)options.getMinTimestampMillis());
        Instant maxTimestamp = new Instant((Object)options.getMaxTimestampMillis());
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        PCollection input = (PCollection)((PCollection)pipeline.apply((PTransform)TextIO.read().from(options.getInputFile()))).apply((PTransform)ParDo.of((DoFn)new AddTimestampFn(minTimestamp, maxTimestamp)));
        Integer n = options.getWindowSize();
        if (n == null) {
            Intrinsics.throwNpe();
        }
        PCollection windowedWords = (PCollection)input.apply((PTransform)Window.into((WindowFn)((WindowFn)FixedWindows.of((Duration)Duration.standardMinutes((long)n.intValue())))));
        PCollection wordCounts = (PCollection)windowedWords.apply((PTransform)new WordCount.CountWords());
        ((PCollection)wordCounts.apply((PTransform)MapElements.via((SimpleFunction)new WordCount.FormatAsTextFn()))).apply((PTransform)new WriteOneFilePerWindow(output, options.getNumShards()));
        PipelineResult result = pipeline.run();
        try {
            result.waitUntilFinish();
        }
        catch (Exception exc) {
            result.cancel();
        }
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        PipelineOptionsFactory.Builder builder = PipelineOptionsFactory.fromArgs((String[])Arrays.copyOf(args, args.length)).withValidation();
        if (builder == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.apache.beam.examples.kotlin.WindowedWordCount.Options");
        }
        Options options = (Options)builder;
        WindowedWordCount.runWindowedWordCount(options);
    }

    private WindowedWordCount() {
    }

    static {
        WindowedWordCount windowedWordCount;
        INSTANCE = windowedWordCount = new WindowedWordCount();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\u00022\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bH\u0007R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/apache/beam/examples/kotlin/WindowedWordCount$AddTimestampFn;", "Lorg/apache/beam/sdk/transforms/DoFn;", "", "minTimestamp", "Lorg/joda/time/Instant;", "maxTimestamp", "(Lorg/joda/time/Instant;Lorg/joda/time/Instant;)V", "processElement", "", "element", "receiver", "Lorg/apache/beam/sdk/transforms/DoFn$OutputReceiver;", "beam-examples-kotlin"})
    public static final class AddTimestampFn
    extends DoFn<String, String> {
        private final Instant minTimestamp;
        private final Instant maxTimestamp;

        @DoFn.ProcessElement
        public final void processElement(@DoFn.Element @NotNull String element, @NotNull DoFn.OutputReceiver<String> receiver) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull(receiver, (String)"receiver");
            Instant randomTimestamp = new Instant(ThreadLocalRandom.current().nextLong(this.minTimestamp.getMillis(), this.maxTimestamp.getMillis()));
            receiver.outputWithTimestamp((Object)element, new Instant((Object)randomTimestamp));
        }

        public AddTimestampFn(@NotNull Instant minTimestamp, @NotNull Instant maxTimestamp) {
            Intrinsics.checkParameterIsNotNull((Object)minTimestamp, (String)"minTimestamp");
            Intrinsics.checkParameterIsNotNull((Object)maxTimestamp, (String)"maxTimestamp");
            this.minTimestamp = minTimestamp;
            this.maxTimestamp = maxTimestamp;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/apache/beam/examples/kotlin/WindowedWordCount$DefaultToCurrentSystemTime;", "Lorg/apache/beam/sdk/options/DefaultValueFactory;", "", "()V", "create", "options", "Lorg/apache/beam/sdk/options/PipelineOptions;", "(Lorg/apache/beam/sdk/options/PipelineOptions;)Ljava/lang/Long;", "beam-examples-kotlin"})
    public static final class DefaultToCurrentSystemTime
    implements DefaultValueFactory<Long> {
        @NotNull
        public Long create(@NotNull PipelineOptions options) {
            Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
            return System.currentTimeMillis();
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/apache/beam/examples/kotlin/WindowedWordCount$DefaultToMinTimestampPlusOneHour;", "Lorg/apache/beam/sdk/options/DefaultValueFactory;", "", "()V", "create", "options", "Lorg/apache/beam/sdk/options/PipelineOptions;", "(Lorg/apache/beam/sdk/options/PipelineOptions;)Ljava/lang/Long;", "beam-examples-kotlin"})
    public static final class DefaultToMinTimestampPlusOneHour
    implements DefaultValueFactory<Long> {
        @NotNull
        public Long create(@NotNull PipelineOptions options) {
            Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
            Long l = ((Options)options).getMinTimestampMillis();
            if (l == null) {
                Intrinsics.throwNpe();
            }
            long l2 = l;
            Duration duration = Duration.standardHours((long)1L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.standardHours(1)");
            return l2 + duration.getMillis();
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\b\bf\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00058gX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u00058gX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000e8gX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u000e8gX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lorg/apache/beam/examples/kotlin/WindowedWordCount$Options;", "Lorg/apache/beam/examples/kotlin/WordCount$WordCountOptions;", "Lorg/apache/beam/examples/kotlin/common/ExampleOptions;", "Lorg/apache/beam/examples/kotlin/common/ExampleBigQueryTableOptions;", "maxTimestampMillis", "", "getMaxTimestampMillis", "()Ljava/lang/Long;", "setMaxTimestampMillis", "(Ljava/lang/Long;)V", "minTimestampMillis", "getMinTimestampMillis", "setMinTimestampMillis", "numShards", "", "getNumShards", "()Ljava/lang/Integer;", "setNumShards", "(Ljava/lang/Integer;)V", "windowSize", "getWindowSize", "setWindowSize", "beam-examples-kotlin"})
    public static interface Options
    extends WordCount.WordCountOptions,
    ExampleOptions,
    ExampleBigQueryTableOptions {
        @Description(value="Fixed window duration, in minutes")
        @Default.Integer(value=10)
        @Nullable
        public Integer getWindowSize();

        public void setWindowSize(@Nullable Integer var1);

        @Description(value="Minimum randomly assigned timestamp, in milliseconds-since-epoch")
        @Default.InstanceFactory(value=DefaultToCurrentSystemTime.class)
        @Nullable
        public Long getMinTimestampMillis();

        public void setMinTimestampMillis(@Nullable Long var1);

        @Description(value="Maximum randomly assigned timestamp, in milliseconds-since-epoch")
        @Default.InstanceFactory(value=DefaultToMinTimestampPlusOneHour.class)
        @Nullable
        public Long getMaxTimestampMillis();

        public void setMaxTimestampMillis(@Nullable Long var1);

        @Description(value="Fixed number of shards to produce per window")
        @Nullable
        public Integer getNumShards();

        public void setNumShards(@Nullable Integer var1);
    }
}

